# Practical Food Guide

## Avoiding Tourist Traps

### Red Flags
- ❌ Photos of food on menu or window
- ❌ Staff outside recruiting diners
- ❌ "Tourist menu" / "Menu turistico"
- ❌ Prices not clearly displayed
- ❌ Within 50m of San Marco Piazza
- ❌ Laminated menus in 6 languages
- ❌ Lasagna, fettuccine Alfredo on menu (not Venetian)
- ❌ Empty at 1pm or 8pm

### Green Flags
- ✓ Menu in Italian only (or awkward translation)
- ✓ Locals at bar or tables
- ✓ Handwritten daily specials
- ✓ Staff ignores you until you order
- ✓ Crowded at 12:30pm or 7:30pm
- ✓ Small, limited menu
- ✓ No photos anywhere

### Specific Traps to Avoid
| Area | What to Avoid |
|------|---------------|
| San Marco | Everything within 100m of piazza |
| Rialto | Restaurants ON the bridge |
| Lista di Spagna | Station-to-Rialto corridor |
| Riva degli Schiavoni | Waterfront tourist restaurants |

---

## Reservation Guide

### Need Reservations
| Restaurant | Lead Time |
|------------|-----------|
| Alle Testiere | 2-3 weeks |
| Antiche Carampane | 1-2 weeks |
| Da Fiore | 2-4 weeks |
| Al Covo | 1 week |
| Trattoria al Gatto Nero (Burano) | 1 week |

### Walk-In Usually OK
- Most bacari (standing only)
- Casual trattorias
- Pizza places
- Lunch service (less busy than dinner)

### Booking Tips
- Email often better than phone
- Book in Italian if possible
- Confirm day before for fancy places
- Don't no-show — Venice is small, they remember

---

## Understanding Menus

### Structure
| Course | Italian | What It Means |
|--------|---------|---------------|
| Appetizers | Antipasti | Starters, cold plates |
| First course | Primi | Pasta, risotto, soup |
| Second course | Secondi | Fish, meat main dishes |
| Sides | Contorni | Vegetables, salads (order separately) |
| Cheese | Formaggi | Cheese course |
| Dessert | Dolci | Sweets |

**Note**: You don't have to order every course. Primo + secondo is standard. Solo primo is fine.

### Common Terms
| Italian | Meaning |
|---------|---------|
| Del giorno | Of the day |
| Alla griglia | Grilled |
| Fritto/a | Fried |
| Al forno | Baked |
| In umido | Stewed |
| Crudo | Raw |
| (*) asterisk | Frozen (by law must indicate) |

### Fish Pricing
**Warning**: Fish often priced by weight (per etto = per 100g)

- Check price BEFORE ordering
- Ask "Quanto viene?" (How much will it come to?)
- A 400g fish at €6/etto = €24

---

## Hidden Costs

### Coperto (Cover Charge)
- **What**: Per-person charge for bread, table setting
- **Normal**: €2-3
- **Tourist**: €4-6
- **Legal**: Yes, must be on menu
- **Tip**: Check menu for coperto before sitting

### Servizio (Service Charge)
- **What**: Service fee (sometimes auto-added)
- **Normal**: 10-15% if included
- **Check**: Bill should say "servizio incluso" if added
- **If not included**: Tip 5-10% for good service

### Standing vs Sitting
At bars:
- **Standing** (al banco): €1.50 espresso
- **Sitting** (al tavolo): €3-6 espresso
- **San Marco terrace**: €8-15 espresso

This is legal and normal. Choose accordingly.

### Water
- **Bottled** (acqua minerale): €2-4
- **Tap** (acqua del rubinetto): Free but rarely offered
- **Tip**: "Acqua del rubinetto" gets you free tap water (perfectly safe)

---

## Dietary Restrictions

### Vegetarian (Vegetariano)
**Good news**: Plenty of options
- Cicchetti: Many vegetable options
- Primi: Pasta/risotto often vegetarian
- Contorni: Vegetable sides

**Say**: "Sono vegetariano/a" (I'm vegetarian)

**Watch for**: Anchovies in sauces, meat broth in risotto

### Vegan (Vegano)
**Harder** but possible:
- Fresh vegetables
- Simple pasta with tomato sauce
- Vegetable antipasti
- Avoid: Cheese, butter (in almost everything)

**Say**: "Sono vegano/a. Senza carne, pesce, latticini, uova" (I'm vegan. Without meat, fish, dairy, eggs)

### Gluten-Free (Senza Glutine)
**Options exist**:
- Risotto (naturally GF)
- Grilled fish/meat
- Polenta
- GF pasta available at some restaurants

**Say**: "Sono celiaco/a" (I'm celiac) — taken seriously

**Reality**: Cross-contamination common. Ask carefully.

### Kosher
**In Jewish Ghetto**:
- Gam Gam restaurant
- Ba'Ghetto (related)
- Kosher bakeries

**Shabbat note**: These close Friday sunset to Saturday night

### Halal
**Limited options**:
- Some kebab shops
- Fish is always permissible
- Vegetarian safe option
- No dedicated halal restaurants in tourist areas

---

## Tipping Guide

### At Restaurants
- **If servizio included**: Nothing extra needed
- **If no servizio**: 5-10% for good service
- **How**: Leave cash on table or round up

### At Bars
- **Standing**: Coins in jar, nothing expected
- **Sitting**: Round up bill

### General Rule
Tipping is appreciated but not expected like in US. Italians tip minimally. Don't overthink it.

---

## Meal Timing

### Breakfast
- **Time**: 7-10am
- **What**: Cornetto + cappuccino, standing
- **Where**: Any bar
- **Cost**: €2-3 standing

### Lunch
- **Time**: 12:30-2:30pm
- **Reality**: Kitchen often closes 2pm
- **Tip**: Arrive by 1pm for full menu

### Aperitivo
- **Time**: 6-8pm
- **What**: Spritz + cicchetti
- **Where**: Bacari, campo bars

### Dinner
- **Time**: 7:30-10pm
- **Reality**: Kitchen closes 9-9:30pm
- **Tip**: Arrive by 8pm for relaxed meal

### Late Night
- **Options**: Very limited after 10pm
- **Best bet**: Campo Santa Margherita area

---

## Coffee Culture

### Types
| Name | What It Is |
|------|------------|
| Caffè / Espresso | Standard small coffee |
| Caffè doppio | Double espresso |
| Caffè macchiato | Espresso with milk spot |
| Cappuccino | Espresso + steamed milk + foam |
| Caffè latte | Coffee with lots of milk |
| Caffè corretto | Espresso with alcohol |
| Caffè shakerato | Iced shaken espresso |

### Rules
- Cappuccino is for morning only (before 11am)
- After meals: espresso only
- Order at bar, pay at register (or vice versa depending on place)
- Stand at bar for lowest prices

---

## Alcohol in Venice

### The Spritz
Venetian invention, aperitivo essential:
- **Aperol Spritz**: Orange, sweeter, mainstream
- **Select Spritz**: Local bitter, more complex
- **Campari Spritz**: More bitter, red

Build: 3-2-1 (prosecco-bitter-soda) + orange slice

### Wine
- **Ombra**: Small glass, house wine
- **Prosecco**: Local sparkling, very common
- **Vino della casa**: House wine (usually good value)
- **Quarter (quarto)**: 250ml carafe
- **Half (mezzo)**: 500ml carafe

### Grappa
Strong grape pomace spirit:
- Traditional digestivo
- Order after dinner
- Quality varies wildly

---

## Food Shopping

### For Picnics
- **Rialto Market**: Fresh produce, cheese, bread (closed Sun-Mon)
- **Alimentari**: Small grocery shops
- **Coop**: Supermarket near Piazzale Roma
- **Punto Simply**: Near train station

### What to Buy
- Bread from panificio (bakery)
- Cheese and salumi from alimentari
- Fruit from market
- Wine from enoteca

### Picnic Spots
- Giardini Pubblici (park with benches)
- Zattere waterfront (informal)
- Any campo (square)
- Note: Eating on ground near monuments = fines possible

---

## Bringing Food Home

### What to Pack
- **Vacuum-sealed cheese**: Asiago, Montasio
- **Dry goods**: Risi (rice), polenta, pasta
- **Sweets**: Baicoli biscuits, zaletti
- **Coffee**: Local roasters

### Where to Buy
- **Rialto Market**: Spices, dried goods
- **Mascari** (near Rialto): Quality spices, chocolate
- **Specialty shops**: Throughout San Polo

### What to Skip
- Fresh fish (won't survive journey)
- Perishable cheese (unless vacuum-sealed)
- Alcohol (buy at airport duty-free instead)
