# Cicchetti & Bacari Guide

## What Are Cicchetti?

Venetian small bites — the city's answer to Spanish tapas. Eaten standing at bacari (wine bars), typically with an "ombra" (glass of wine).

### Characteristics
- Small, 2-3 bites each
- Displayed on counter
- Point and choose
- Eaten standing
- Meant to hop between bars
- €1.50-3.50 each

### Types

**Crostini**: Small toasts with toppings
- Baccalà mantecato
- Lardo
- Soppressa
- Various fish spreads

**Polpette**: Fried balls
- Meat (carne)
- Fish (pesce)
- Vegetable

**Seafood**: Often the star
- Octopus (polpo)
- Sardines (sarde)
- Anchovies (acciughe)
- Tiny shrimp (schie)

**Vegetables**: Seasonal
- Artichoke hearts
- Fried zucchini
- Roasted peppers

---

## The Ombra

"Ombra" = shadow. Wine sellers stood in the campanile's shadow, moving with it throughout the day.

Now means a small glass of wine:
- €2-4
- Usually house wine
- White (bianco) or red (rosso)
- Prosecco also common

**Ordering**: "Un'ombra di bianco/rosso" or just point to what others are drinking.

---

## How to Do a Bacaro Crawl

### The Ritual
1. **Enter bacaro** (no reservation, standing)
2. **Order ombra** at bar
3. **Point to 2-3 cicchetti** you want
4. **Eat standing** at counter or outside
5. **Pay** (usually on honor system, pay when leaving)
6. **Move to next bacaro**

### Timing
- **Morning crawl**: 10am-12pm (yes, wine included)
- **Lunch crawl**: 12-2pm (busiest with locals)
- **Evening crawl**: 6-8pm (aperitivo hour, most popular)

### How Many Stops?
- **Light lunch**: 3-4 bacari, 2-3 cicchetti each
- **Full experience**: 5-6 bacari over 2-3 hours
- **Budget**: €20-30 for substantial crawl with wine

---

## Bacaro Etiquette

### Do
- Stand at counter (sitting costs more if available)
- Order at bar, pay at bar
- Try what looks interesting
- Accept small portions
- Move on after 15-20 minutes
- Leave a few coins tip in jar

### Don't
- Ask for table service
- Take photos blocking counter
- Linger too long at crowded bacaro
- Expect English menus
- Ask for substitutions
- Use credit card for small amounts

---

## Classic Cicchetti to Try

### Must-Have
| Cicchetto | Description |
|-----------|-------------|
| **Baccalà mantecato** | Creamed salt cod — the essential one |
| **Sarde in saor** | Sweet-sour sardines with onions |
| **Polpette** | Fried meatballs (or fish balls) |
| **Tramezzini** | Triangle sandwiches (Venetian invention) |

### Seafood
| Cicchetto | Description |
|-----------|-------------|
| **Schie con polenta** | Tiny shrimp on polenta |
| **Polpo** | Octopus pieces |
| **Acciughe marinate** | Marinated anchovies |
| **Seppie** | Small cuttlefish |
| **Gamberetti** | Shrimp |

### Meat
| Cicchetto | Description |
|-----------|-------------|
| **Soppressa** | Veneto salami on bread |
| **Lardo** | Cured pork fat on crostino |
| **Nervetti** | Cartilage salad (adventurous) |
| **Spienza** | Spleen (very local) |

### Vegetable
| Cicchetto | Description |
|-----------|-------------|
| **Carciofi** | Artichoke hearts |
| **Melanzane** | Eggplant preparations |
| **Zucchine fritte** | Fried zucchini |
| **Peperoni** | Roasted peppers |

---

## Top Bacari by Area

### San Polo (Rialto) — Best Concentration

**All'Arco**
- Morning cicchetti institution
- Fresh, creative toppings
- Tiny, crowded, perfect
- Go by 11am

**Cantina Do Spade**
- Since 1488
- Traditional cicchetti
- Good wine selection
- Can be touristy but quality holds

**Do Mori**
- Venice's oldest bacaro (1462)
- Francobolli (tiny sandwiches)
- Standing room only
- No seats ever

**Bancogiro**
- Grand Canal terrace
- More upscale cicchetti
- Aperitivo destination
- Pricier but location

**Cantina Do Mori**
- Historic, dark interior
- Copper pots hanging
- Excellent wines
- Classic experience

### Cannaregio — Local Scene

**Al Timon**
- Canalside seating on boat
- Young, local crowd
- Evening only
- Get there early for canal spot

**Alla Vedova**
- Legendary polpette (meatballs)
- Tiny space
- Worth the squeeze
- Also does full meals

**Vino Vero**
- Natural wines
- Modern cicchetti
- Younger crowd
- Excellent selection

**Un Mondo di Vino**
- 900+ wine labels
- Quality cicchetti
- Serious wine bar
- Knowledgeable staff

### Dorsoduro — Art District

**Osteria Al Squero**
- Facing gondola workshop
- Excellent cicchetti
- Popular with locals
- Morning or early evening

**Cantinone Già Schiavi**
- Legendary spot
- Canal terrace
- Huge cicchetti selection
- Can get crowded

**Estro**
- Modern enoteca
- Creative cicchetti
- Wine focus
- Slightly upscale

### Castello

**Bacaro Risorto**
- Off tourist track
- Quality cicchetti
- Local neighborhood bar

**El Refolo**
- Near Via Garibaldi
- Local workers' bar
- Cheap, authentic
- No frills

---

## Suggested Crawl Routes

### Classic Rialto Crawl (2-3 hours)
1. **All'Arco** — Start with fresh crostini (10-11am)
2. Walk 2 minutes
3. **Do Mori** — Historic, francobolli
4. Walk 3 minutes
5. **Cantina Do Spade** — Traditional
6. Walk 2 minutes
7. **Bancogiro** — Finish with canal view spritz

### Evening Cannaregio Crawl (2-3 hours)
1. **Vino Vero** — Start with natural wine (6pm)
2. Walk 5 minutes
3. **Al Timon** — Canalside boat seating
4. Walk 3 minutes
5. **Alla Vedova** — Famous polpette
6. Optional: dinner at Anice Stellato nearby

### Dorsoduro Art Crawl (after museums)
1. **Cantinone Già Schiavi** — Post-Accademia (5pm)
2. Walk 10 minutes
3. **Osteria Al Squero** — Watch gondola workshop
4. Walk to Campo Santa Margherita
5. Any bar — Spritz in the campo

---

## Budget Planning

### Typical Costs
| Item | Price |
|------|-------|
| Cicchetto | €1.50-3.50 |
| Ombra (wine glass) | €2-4 |
| Spritz | €3-4 |
| Prosecco glass | €3-5 |

### Sample Budgets

**Light Snack (1 bacaro)**
- 2 cicchetti + 1 ombra = €6-10

**Cicchetti Lunch (3-4 bacari)**
- 8-10 cicchetti + 3-4 ombra = €20-30

**Full Crawl (5-6 bacari, 3 hours)**
- 12-15 cicchetti + 5-6 drinks = €35-50

---

## Vocabulary

| Term | Meaning |
|------|---------|
| Bacaro | Wine bar |
| Cicchetto | Small bite |
| Ombra | Glass of wine |
| Crostino | Small toast |
| Polpetta | Fried ball |
| Francobollo | "Stamp" — tiny sandwich |
| Tramezzino | Triangle sandwich |
| Bianco | White wine |
| Rosso | Red wine |
| Prosecco | Sparkling wine |
| Spritz | Aperitivo drink |

### Ordering Phrases
- "Un'ombra di bianco/rosso" — Glass of white/red
- "Quello lì" — That one there (pointing)
- "Ancora uno" — Another one
- "Il conto" — The bill
- "Quant'è?" — How much is it?
