# Carnevale & Festivals — Venice

## Carnevale di Venezia

**The world's most famous masked carnival**

### When
- **Duration:** ~2-3 weeks, ending on Shrove Tuesday
- **2025:** February 14 - March 4
- **2026:** February 6 - February 24
- **Peak days:** Final weekend + Fat Tuesday

### What Carnevale Actually Is

**Historical context:**
- **Origin:** Medieval — last chance for excess before Lent fasting
- **Golden age:** 18th century — lasted 6 months, masks everywhere
- **Banned:** 1797 (Napoleon), revived 1979
- **Today:** Mix of tourism spectacle + authentic tradition

**The masks:**
- **Bauta** — white mask covering whole face, black cape, tricorn hat (traditional)
- **Moretta** — oval black velvet, held by biting a button (women's, silent)
- **Medico della Peste** — plague doctor, long beak (herbs inside)
- **Colombina** — half-mask, decorated (commedia dell'arte)
- **Volto** — simple white, covers face (most common)

### Carnevale Program

| Event | What | Where |
|-------|------|-------|
| **Flight of the Angel** | Zipline from Campanile | St. Mark's Square |
| **Flight of the Eagle** | Final Sunday flight | St. Mark's Square |
| **Best Mask Competition** | Elaborate costume judging | St. Mark's Square |
| **Grand Masked Ball** | Formal ball in palazzo | Various venues (€200-1000+) |
| **Street Performances** | Commedia dell'arte, music | Throughout city |
| **Parade of Masks** | Photo opportunities | San Marco, Rialto |

### Practical Carnevale

**Costs:**
- **Entry:** Free (it's public)
- **Masks:** €15-50 tourist, €100-500 artisan, €1000+ commissioned
- **Costume rental:** €150-500/day
- **Masked balls:** €200-1000+ (includes dinner, entertainment)
- **Accommodation:** 2-3x normal prices

**Best experience strategies:**
1. **Budget:** Walk around in a simple mask, people-watch
2. **Mid-range:** Attend a smaller ball, rent costume for one day
3. **Splurge:** Commission mask, attend Ballo del Doge or similar

**Challenges:**
- **Crowds:** Overwhelming at St. Mark's
- **Prices:** Everything inflated
- **Accommodation:** Book 3-6 months ahead
- **Authenticity:** Much is tourist spectacle, real traditions harder to find

**Where locals actually go:**
- **Campo Santa Margherita** — student/local parties
- **Neighborhood events** — less advertised, more authentic
- **Private balls** — through connections or hotel concierge

### Making Your Own Mask

**Artisan mask shops (real Venetian craft):**
- **Ca' Macana** — famous, Kubrick's *Eyes Wide Shut* masks
- **Tragicomica** — high-end, traditional techniques
- **Papier Mâché** — workshops available

**Workshop experience:**
- 2-3 hours to make and paint your mask
- €40-100 depending on complexity
- Reservations needed, especially during Carnevale

## Regata Storica

**The other great Venetian spectacle**

### When
- **First Sunday of September**
- Less touristy than Carnevale, more authentically Venetian

### What Happens

**Historical Parade:**
- 16th-century boats, period costumes
- Doge's ceremonial barge (Bucintoro replica)
- Hundreds of historic vessels
- Down Grand Canal

**Races:**
- Gondolini (two oarsmen) — main event
- Caorline (6 oarsmen women)
- Caorline (6 oarsmen men)
- Pupparini (2 oarsmen)

### Watching

**Best spots:**
- **Ca' Foscari curve** — where races are won/lost
- **Rialto Bridge** — iconic but crowded
- **Rent a boat** — join the floating spectators (book ahead)
- **Palazzo balconies** — if you know someone

**Practical:**
- Arrive early (parade starts ~4pm, races ~4:30pm)
- Free to watch from banks
- Restaurants along canal book out months ahead

## Other Festivals

### Festa del Redentore (July)

**Venice's most beloved local festival**

**When:** Third weekend of July (Saturday night fireworks)

**Origin:** 1576 plague ended, church built in thanksgiving

**What happens:**
- **Floating bridge** — temporary pontoon to Redentore church (Giudecca)
- **Boat picnic** — Venetians anchor boats in Giudecca canal
- **Fireworks** — spectacular 45-minute show over lagoon
- **All-night celebration** — parties until sunrise

**Best experience:**
- **Rent a boat** — join locals on the water (book months ahead)
- **Rooftop party** — hotels/venues sell access
- **Lido beach** — watch from sand, then swim at midnight
- **Walk the bridge** — crosses at midnight for mass at Redentore

**Local tradition:** Families anchor boats, elaborate dinners, decorations. The most "Venetian" festival.

### Festa della Salute (November 21)

**Local religious observance**

**Origin:** 1631 plague ended

**What happens:**
- **Pontoon bridge** — temporary crossing to Salute church
- **Pilgrimage** — Venetians walk across to light candle
- **Traditional food** — castradina (smoked mutton) stew

**For visitors:**
- Atmospheric, local, uncrowded
- Experience authentic Venetian devotion
- The walk across temporary bridge is memorable

### Vogalonga (May/June)

**Non-competitive rowing "marathon"**

**When:** Sunday, late May or early June

**What:**
- 30+ km row around lagoon islands
- 1,500+ boats, any human-powered vessel
- Started 1975 as protest against motorboat damage

**Experience:**
- Spectacular to watch from lagoon edges
- Anyone can participate (register, bring boat or rent)
- Very Venetian spirit — community, not competition

### Festa di San Marco (April 25)

**Venice's patron saint day**

**Traditions:**
- Men give women red rose (bocolo)
- Special mass at St. Mark's
- Relatively low-key but romantic

### Venice Film Festival (September)

**Oldest film festival in the world (since 1932)**

**When:** Late August - early September

**Where:** Lido island

**Practicalities:**
- Public screenings available (book online)
- Celebrity-spotting at Excelsior Hotel
- Red carpet at Palazzo del Cinema
- Lido more accessible than Cannes

## Calendar Overview

| Month | Event |
|-------|-------|
| February/March | Carnevale (dates vary) |
| April 25 | Festa di San Marco |
| May/June | Vogalonga |
| May-November (odd years) | Art Biennale |
| May-November (even years) | Architecture Biennale |
| July (3rd weekend) | Festa del Redentore |
| August-September | Film Festival (Lido) |
| September (1st Sunday) | Regata Storica |
| November 21 | Festa della Salute |

## Booking & Planning

### Carnevale
- **Accommodation:** 3-6 months ahead
- **Masked balls:** 1-3 months ahead
- **Flight tickets:** Check parade schedules

### Regata Storica
- **Restaurants on Grand Canal:** 2-3 months ahead
- **Boat rental:** 1-2 months ahead

### Redentore
- **Boat rental:** 3-6 months ahead (most popular)
- **Rooftop parties:** 1-2 months ahead

### Film Festival
- **Lido hotels:** 2-3 months ahead
- **Screening tickets:** Released ~2 weeks before

## Festival Photography

**Best opportunities:**
- **Carnevale:** Early morning St. Mark's (masked figures, empty square)
- **Regata:** Rialto Bridge or Ca' Foscari curve
- **Redentore:** Fireworks from Giudecca or Lido
- **Vogalonga:** Burano or San Giorgio for colorful boats

**Tips:**
- Carnevale costumes = people want to be photographed
- Ask permission, show the photo after, offer to send
- Golden hour + masks = magical
