---
name: vehicle-tracker
description: Track vehicle expenses (gas, maintenance, parts) in Google Sheets and save related photos. Handles mileage, cost, category, and photo organization.
---

# Vehicle Expense Tracker

A multi-language vehicle expense tracking tool that supports Google Sheets and local Excel files.

## Features

- **i18n Support**: Multiple languages via locale files (`locales/*.json`)
- **Google Sheets Integration**: Write directly to Google Sheets via API
- **Local Excel Fallback**: Saves to local `.xlsx` files if no Spreadsheet ID configured
- **Metric/Imperial Units**: Configurable unit system (km/L vs mi/gal)
- **Photo Management**: Auto-saves and renames photos with timestamps
- **Aliases**: Support vehicle aliases (e.g., "my car" → "Toyota Camry 2020")
- **Defaults**: Auto-fill quantity and unit based on category

---

## 🚀 Initialization (First-Time Setup)

### Step 1: Choose Your Locale

Available locales:
- `zh-TW` - 繁體中文 (Taiwan)
- `en-US` - English (US)
- `ja-JP` - 日本語

### Step 2: Create config.json

Copy the template below and save as `skills/vehicle-tracker/config.json`:

```json
{
  "locale": "en-US",
  "unit_system": "metric",
  "vehicles": {},
  "aliases": {},
  "default_vehicle": null,
  "category_defaults": {}
}
```

### Step 3: Copy Category Defaults from Locale

Based on your chosen locale and unit system, copy the appropriate category defaults.

**For English (metric):**
```json
{
  "category_defaults": {
    "Gas": { "unit": "liter" },
    "Accessory": { "unit": "pc", "quantity": 1 },
    "Repair": { "unit": "job", "quantity": 1 },
    "Maintenance": { "unit": "service", "quantity": 1 },
    "Purchase": { "unit": "unit", "quantity": 1 }
  }
}
```

**For English (imperial):**
```json
{
  "category_defaults": {
    "Gas": { "unit": "gallon" },
    "Accessory": { "unit": "pc", "quantity": 1 },
    "Repair": { "unit": "job", "quantity": 1 },
    "Maintenance": { "unit": "service", "quantity": 1 },
    "Purchase": { "unit": "unit", "quantity": 1 }
  }
}
```

**For 繁體中文 (metric):**
```json
{
  "category_defaults": {
    "加油": { "unit": "公升" },
    "周邊": { "unit": "個", "quantity": 1 },
    "維修": { "unit": "件", "quantity": 1 },
    "保養": { "unit": "次", "quantity": 1 },
    "買車": { "unit": "輛", "quantity": 1 }
  }
}
```

**For 日本語 (metric):**
```json
{
  "category_defaults": {
    "給油": { "unit": "リットル" },
    "アクセサリー": { "unit": "個", "quantity": 1 },
    "修理": { "unit": "件", "quantity": 1 },
    "メンテナンス": { "unit": "回", "quantity": 1 },
    "購入": { "unit": "台", "quantity": 1 }
  }
}
```

### Step 4: Add Your Vehicle

**Option A: Google Sheets (recommended for cloud sync)**

1. Create a Google Spreadsheet
2. Share it with a Google Service Account (see `google-workspace` skill)
3. Add the Spreadsheet ID to config:

```json
{
  "vehicles": {
    "My Car 2020": "1ABC123...xyz"
  },
  "default_vehicle": "My Car 2020"
}
```

**Option B: Local Excel (no setup required)**

Just add the vehicle name without an ID:

```json
{
  "vehicles": {
    "My Car 2020": null
  },
  "default_vehicle": "My Car 2020"
}
```

Files will be saved to `~/vehicle_tracker/My_Car_2020.xlsx`.

### Step 5: Add Aliases (Optional)

```json
{
  "aliases": {
    "car": "My Car 2020",
    "toyota": "My Car 2020"
  }
}
```

### Step 6: Custom Paths (Optional)

Override default directories:

```json
{
  "photo_base_dir": "/path/to/photos",
  "local_excel_dir": "/path/to/excel/files",
  "sheet_name": "Expenses"
}
```

Default paths: `~/vehicle_tracker`

---

## Complete config.json Example

```json
{
  "locale": "en-US",
  "unit_system": "imperial",
  "vehicles": {
    "Toyota Camry 2020": "1ABC123...spreadsheet_id",
    "Honda Civic 2018": null
  },
  "aliases": {
    "camry": "Toyota Camry 2020",
    "civic": "Honda Civic 2018",
    "car": "Toyota Camry 2020"
  },
  "default_vehicle": "Toyota Camry 2020",
  "category_defaults": {
    "Gas": { "unit": "gallon" },
    "Accessory": { "unit": "pc", "quantity": 1 },
    "Repair": { "unit": "job", "quantity": 1 },
    "Maintenance": { "unit": "service", "quantity": 1 },
    "Purchase": { "unit": "unit", "quantity": 1 }
  },
  "photo_base_dir": "~/vehicle_tracker",
  "local_excel_dir": "~/vehicle_tracker"
}
```

---

## Usage

### Preview (Dry Run) - Always do this first!

```bash
python3 skills/vehicle-tracker/tracker.py \
  --vehicle "camry" \
  --mileage 15000 \
  --category "Gas" \
  --cost 45.50 \
  --quantity 12.5 \
  --dry-run
```

### Execute (After user confirms)

```bash
python3 skills/vehicle-tracker/tracker.py \
  --vehicle "camry" \
  --mileage 15000 \
  --category "Gas" \
  --cost 45.50 \
  --quantity 12.5
```

### With Photos

```bash
python3 skills/vehicle-tracker/tracker.py \
  --vehicle "camry" \
  --mileage 15200 \
  --category "Maintenance" \
  --cost 89.99 \
  --description "Oil change" \
  --photos "/path/to/receipt.jpg" \
  --dry-run
```

---

## Arguments

| Argument | Required | Description |
|----------|----------|-------------|
| `--vehicle` | Optional | Vehicle name or alias. Uses default if omitted. |
| `--mileage` | Required | Current odometer reading |
| `--category` | Required | Expense category |
| `--cost` | Required | Expense amount (currency symbols auto-removed) |
| `--quantity` | Optional | Quantity (uses default if available) |
| `--unit` | Optional | Unit (uses category mapping if available) |
| `--date` | Optional | Date YYYY-MM-DD (defaults to today) |
| `--description` | Optional | Additional notes |
| `--photos` | Optional | Photo file paths to save |
| `--dry-run` | Flag | Preview only, no write |

---

## Adding a New Locale

Create `locales/{code}.json` based on existing locale files. Required fields:

- `language_name`
- `sheet_name`
- `columns_metric` / `columns_imperial`
- `photo_prefix`
- `messages`
- `units_metric` / `units_imperial`
- `default_units_metric` / `default_units_imperial`

---

## Supported Locales

| Code | Language | Unit Systems |
|------|----------|--------------|
| `zh-TW` | 繁體中文 | metric, imperial |
| `en-US` | English (US) | metric, imperial |
| `ja-JP` | 日本語 | metric, imperial |
