#!/bin/bash
# Capture a snapshot from Vector's camera
# Usage: ./vector-see.sh [output_path]

SERIAL="${VECTOR_SERIAL:-00501a68}"
WIREPOD="${WIREPOD_URL:-http://127.0.0.1:8080}"
OUTPUT="${1:-/tmp/vector_snapshot.jpg}"

# Assume control
curl -s -X POST "$WIREPOD/api-sdk/assume_behavior_control?priority=high&serial=$SERIAL" > /dev/null

# Capture stream briefly
timeout 2 curl -s "$WIREPOD/cam-stream?serial=$SERIAL" > /tmp/vector_stream.mjpeg 2>/dev/null

# Extract first JPEG frame
python3 << EOF
with open('/tmp/vector_stream.mjpeg', 'rb') as f:
    data = f.read()
start = data.find(b'\xff\xd8')
end = data.find(b'\xff\xd9', start)
if start != -1 and end != -1:
    with open('$OUTPUT', 'wb') as out:
        out.write(data[start:end+2])
    print("$OUTPUT")
else:
    print("ERROR: No frame captured")
    exit(1)
EOF

# Release control
curl -s -X POST "$WIREPOD/api-sdk/release_behavior_control?serial=$SERIAL" > /dev/null
