#!/bin/bash
# Make Vector speak
# Usage: ./vector-say.sh "Hello world"

SERIAL="${VECTOR_SERIAL:-00501a68}"
WIREPOD="${WIREPOD_URL:-http://127.0.0.1:8080}"
TEXT="${1:-Hello}"

# URL encode the text
ENCODED=$(python3 -c "import urllib.parse; print(urllib.parse.quote('''$TEXT'''))")

# Assume control, speak, release
curl -s -X POST "$WIREPOD/api-sdk/assume_behavior_control?priority=high&serial=$SERIAL" > /dev/null
curl -s -X POST "$WIREPOD/api-sdk/say_text?text=$ENCODED&serial=$SERIAL" > /dev/null
sleep 2
curl -s -X POST "$WIREPOD/api-sdk/release_behavior_control?serial=$SERIAL" > /dev/null

echo "Vector said: $TEXT"
