#!/bin/bash
# Install LaunchAgent for auto-starting the Vector proxy on macOS
# Usage: ./install-launchagent.sh

SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"
NODE_PATH=$(which node)
PLIST_PATH="$HOME/Library/LaunchAgents/com.openclaw.vector-proxy.plist"

cat > "$PLIST_PATH" << EOF
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE plist PUBLIC "-//Apple//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">
<plist version="1.0">
<dict>
    <key>Label</key>
    <string>com.openclaw.vector-proxy</string>
    <key>ProgramArguments</key>
    <array>
        <string>$NODE_PATH</string>
        <string>$SCRIPT_DIR/proxy-server.js</string>
    </array>
    <key>RunAtLoad</key>
    <true/>
    <key>KeepAlive</key>
    <true/>
    <key>WorkingDirectory</key>
    <string>$SCRIPT_DIR</string>
    <key>StandardOutPath</key>
    <string>$SCRIPT_DIR/proxy.log</string>
    <key>StandardErrorPath</key>
    <string>$SCRIPT_DIR/proxy-error.log</string>
</dict>
</plist>
EOF

launchctl load "$PLIST_PATH"
echo "LaunchAgent installed and started"
echo "Proxy will auto-start on boot"
