# wire-pod SDK API Reference

Base URL: `http://127.0.0.1:8080`
All endpoints require `&serial=SERIAL` parameter.

## Behavior Control

| Endpoint | Method | Description |
|----------|--------|-------------|
| `/api-sdk/assume_behavior_control?priority=high` | POST | Take control of Vector |
| `/api-sdk/release_behavior_control` | POST | Release control |

**Note:** Cliff sensors are DISABLED during behavior control!

## Speech

| Endpoint | Method | Description |
|----------|--------|-------------|
| `/api-sdk/say_text?text=URL_ENCODED_TEXT` | POST | Make Vector speak |

## Movement

| Endpoint | Method | Parameters | Description |
|----------|--------|------------|-------------|
| `/api-sdk/move_head?speed=N` | POST | -2 to 2 | Tilt head (+ up, - down) |
| `/api-sdk/move_lift?speed=N` | POST | -2 to 2 | Move lift arm |
| `/api-sdk/move_wheels?lw=N&rw=N` | POST | -200 to 200 | Drive wheels |

## Settings

| Endpoint | Method | Parameters | Description |
|----------|--------|------------|-------------|
| `/api-sdk/volume?volume=N` | POST | 0-5 | Set volume |
| `/api-sdk/eye_color?color=N` | POST | 0-6 | Set eye color |
| `/api-sdk/locale?locale=X` | POST | en-US, en-GB, etc | Set locale |

### Eye Colors
- 0: Default (teal)
- 1: Orange
- 2: Yellow
- 3: Lime
- 4: Purple
- 5: Blue
- 6: White/Gray

## Status

| Endpoint | Method | Description |
|----------|--------|-------------|
| `/api-sdk/get_battery` | GET | Battery level and voltage |
| `/api-sdk/get_sdk_info` | GET | List connected robots |

## Actions/Intents

| Endpoint | Method | Description |
|----------|--------|-------------|
| `/api-sdk/cloud_intent?intent=X` | POST | Trigger built-in behavior |

### Available Intents
- `intent_imperative_dance` - Dance animation
- `intent_system_sleep` - Go to sleep
- `intent_system_charger` - Return to charger
- `intent_imperative_fetchcube` - Fetch cube
- `explore_start` - Start exploring

## Camera

| Endpoint | Method | Description |
|----------|--------|-------------|
| `/cam-stream?serial=X` | GET | MJPEG camera stream |

Extract frames from MJPEG by finding JPEG markers (FFD8...FFD9).

## wire-pod Config

| Endpoint | Method | Description |
|----------|--------|-------------|
| `/api/get_config` | GET | Current configuration |
| `/api/get_logs` | GET | Recent voice command logs |

## Knowledge Graph Setup

Configure at `http://127.0.0.1:8080` → Server Settings → Knowledge Graph:

For OpenClaw integration:
- Provider: Custom
- API Key: `openclaw`
- Endpoint: `http://localhost:11435/v1`
- Model: `openclaw`
- Enable intent-graph for all unmatched commands
