# Wirepod HTTP API (Vector control)

## Base
- Default: `http://localhost:8080`
- Use `serial=<ESN>` on all endpoints

## Core control
- `POST /api-sdk/assume_behavior_control?priority=high&serial=ESN`
- `POST /api-sdk/release_behavior_control?serial=ESN`
- `POST /api-sdk/move_wheels?lw=INT&rw=INT&serial=ESN`
- `POST /api-sdk/move_head?speed=INT&serial=ESN`
- `POST /api-sdk/move_lift?speed=INT&serial=ESN`
- `POST /api-sdk/say_text?text=URLENCODED&serial=ESN`
- `POST /api-sdk/volume?volume=0-5&serial=ESN`

## Camera
- MJPG stream: `GET /cam-stream?serial=ESN`
- Stop stream: `POST /api-sdk/stop_cam_stream?serial=ESN`

## Notes
- `lw`/`rw` values ~0–200 typical; higher = faster.
- When mixing speech + motion, add a pause after `say_text` to avoid interruption.
