---
name: ve-exchange-rates
description: Get Venezuelan exchange rates - BCV official rate, Binance P2P USDT average, and the gap between them. Use when user asks for Venezuelan dollar rates, brecha cambiaria, dolar BCV, USDT P2P, or exchange rates in Venezuela.
---

# ve-exchange-rates: Venezuelan Exchange Rates

Get current exchange rates for Venezuela:
1. **Tasa BCV** - Official Central Bank rate
2. **Tasa USDT Binance P2P** - Average from P2P market
3. **Brecha cambiaria** - Gap between official and parallel rates

## Usage

Run the script to get current rates:

```bash
~/clawd/skills/ve-exchange-rates/scripts/get-rates.sh
```

## Output

The script returns:
- BCV official rate (Bs/USD)
- Binance P2P USDT rates (buy/sell/average)
- Gap percentage between BCV and P2P

## Data Sources

- **BCV rate**: tcambio.app or finanzasdigital.com
- **USDT P2P**: Binance P2P API (p2p.binance.com)

## Notes

- Rates are fetched in real-time from APIs
- BCV rate updates daily
- P2P rates fluctuate constantly based on market
- Script uses jq for JSON parsing
