# Skill: VAST.ai GPU Rental

## Overview
This skill allows you to provision on-demand GPU infrastructure. You must have a user-provided API Key before performing write actions.

## Capabilities
1. **Search**: Find machines by GPU model (e.g., "RTX 4090") and max hourly price.
2. **Rent**: Instantiate a container (default: PyTorch) on a specific Offer ID.
3. **Connect**: Retrieve the SSH connection string for an active instance.
4. **Balance**: Check available credit and current hourly burn rate across all active machines.

## Usage Protocol
- **Step 1**: Ask the user for their VAST API Key if not already in context.
- **Pre-flight Check**: Before renting, call `balance` to ensure the user has sufficient funds.
- **Step 2**: Search for offers and present the top 3 cheapest options to the user.
- **Step 3**: Upon confirmation, call `rent`.
- **Reporting**: If credit is below $5.00, warn the user after every successful rental.
- **Step 4**: Wait 30-60 seconds, then call `connect` to provide the SSH string.

## Tool Definitions
- `search(gpu: string, price: number)`
- `rent(id: number, image: string)`
- `connect(id: number)`
- `balance()`

## Execution
Run the CLI wrapper for these tools.
Command: `node /Users/sschepis/Development/vast-ai/dist/cli.js <action> [params]`
Env: `VAST_API_KEY` must be set.

### Examples
- Search: `node dist/cli.js search --gpu "RTX 4090" --price 0.5`
- Rent: `node dist/cli.js rent --id 12345 --image "pytorch/pytorch"`
- Connect: `node dist/cli.js connect --id 12345`
- Balance: `node dist/cli.js balance`
