# Vapi (vapi.ai) — OpenClaw Skill

Use this skill when you need to manage **Vapi voice agents** (assistants), calls, phone numbers, tools, and webhooks from an OpenClaw agent.

This skill is **API-first** (Vapi REST) and optionally integrates with the **Vapi CLI** for MCP docs / local workflows.

## What you can do

- Create/update/list **assistants**
- Start/inspect/end **calls**
- Manage **phone numbers**
- Create/manage **tools** (function calling)
- Configure **webhooks** and inspect events

## Required secrets

Set one of:

- `VAPI_API_KEY` (recommended) — Vapi dashboard API key.

### How to provide the key (recommended)

- Store as a Gateway secret/env var (preferred), or
- Export in your shell before running helper scripts.

Never paste the key into public logs.

## Endpoints

Base URL:

- `https://api.vapi.ai`

Auth:

- `Authorization: Bearer $VAPI_API_KEY`

API reference:

- https://api.vapi.ai/api (Swagger)

## Tooling options

This skill supports **both** approaches; you can decide later per deployment.

- Set `VAPI_MODE=api` to prefer REST (default)
- Set `VAPI_MODE=cli` to prefer the Vapi CLI (interactive)

### Option A — REST via helper script (works everywhere)

This repo includes a tiny Node helper:

- `skills/vapi/bin/vapi-api.mjs`

Examples:

```bash
# list assistants
VAPI_API_KEY=... node skills/vapi/bin/vapi-api.mjs assistants:list

# create assistant
VAPI_API_KEY=... node skills/vapi/bin/vapi-api.mjs assistants:create \
  --name "Claw Con Concierge" \
  --modelProvider openai --model gpt-4o-mini \
  --voiceProvider 11labs --voiceId rachel

# start an outbound call (example shape; see swagger for required fields)
VAPI_API_KEY=... node skills/vapi/bin/vapi-api.mjs calls:create \
  --assistantId asst_xxx \
  --to "+14155551234" \
  --from "+14155559876"
```

### Option B — Vapi CLI (good for interactive ops)

If `VAPI_MODE=cli`, prefer using the CLI for management tasks and fall back to REST if the CLI isn’t installed.

Docs:
- https://docs.vapi.ai/cli
- https://github.com/VapiAI/cli

Install:

```bash
curl -sSL https://vapi.ai/install.sh | bash
vapi login
```

### Option C — MCP docs server for your IDE

This improves IDE assistance (Cursor/Windsurf/VSCode):
- https://docs.vapi.ai/cli/mcp

```bash
vapi mcp setup
```

## Agent usage guidance

When the user asks for Vapi changes:

1. Clarify **scope**: assistants vs phone numbers vs webhooks vs tool calls.
2. Prefer **read-only** queries first (list/get) before destructive changes.
3. When creating an assistant, ask for:
   - assistant name
   - model provider/model
   - voice provider/voice id
   - tools/function calling needs
   - webhook URL (if using server events)
4. When initiating calls, confirm:
   - to/from numbers
   - assistantId
   - compliance constraints (recording, consent)

## Files in this skill

- `skills/vapi/SKILL.md` — this file
- `skills/vapi/bin/vapi-api.mjs` — minimal REST helper

## Sources

- Vapi docs intro: https://docs.vapi.ai/quickstart/introduction
- Vapi CLI: https://github.com/VapiAI/cli
- Vapi MCP: https://docs.vapi.ai/cli/mcp
- Vapi API (Swagger): https://api.vapi.ai/api
- Example server (Node): https://github.com/VapiAI/example-server-javascript-node
- OpenClaw: https://github.com/openclaw/openclaw
