# Vancouver Visitor Tips

## Essential First-Day Setup

### Transit
- **Compass Card**: Buy at SkyTrain stations, load stored value or day pass
- **Day pass**: $11.25 (all zones after 6:30pm and weekends)
- **Stored value**: Tap in/out, charged by zone (1-3 zones, $3.15-4.55)
- **Google Maps**: Real-time transit works perfectly

### Mobile/Connectivity
- **WiFi**: Widespread free WiFi (Starbucks, libraries, hotels)
- **SIM options**: Freedom Mobile (cheapest), Koodo, Fido
- **eSIM**: Most carriers support, activate before arrival
- **US phones**: Check roaming. T-Mobile usually includes Canada.

### Money
- **Currency**: Canadian Dollar (CAD). $1 CAD ≈ $0.74 USD
- **Cards**: Tap/contactless universal. Visa/MC everywhere, Amex less so.
- **Cash**: Rarely needed except some food trucks
- **Tipping**: 18-20% expected everywhere (restaurants, bars, taxis, hair)

## Weather Preparation

### The Rain Reality
Vancouver averages 170 rainy days/year, mostly October-April.

**Essential gear:**
- Waterproof jacket with hood (not umbrella — wind destroys them)
- Water-resistant shoes or boots
- Layers (it's rarely cold, just wet)

**Rainy day options:**
- Science World
- Vancouver Art Gallery
- Museum of Anthropology
- Shopping (Gastown, Main St)
- Craft brewery hopping

### Summer Preparation
June-September is spectacular but requires:
- Sunscreen (UV intense near water/mountains)
- Reservations for popular restaurants
- Accommodation booked months ahead
- Prepared for crowds at attractions

## Day Trips from Vancouver

### Whistler (2 hours)
**Best for:** Skiing, village wandering, summer hiking

**Route:** Sea to Sky Highway — one of the world's most scenic drives

**En route stops:**
- Shannon Falls (quick, easy waterfall)
- Sea to Sky Gondola (alternative to Grouse)
- Brandywine Falls (short hike)

**Summer activities:** Peak 2 Peak Gondola, hiking, mountain biking, zip-lining
**Winter activities:** Skiing/snowboarding (Whistler Blackcomb is world-class)

**Tips:**
- Start early on winter weekends (ski traffic brutal)
- Stay overnight if possible — village has great restaurants
- Joffre Lakes detour is spectacular (30 min past Whistler)

### Victoria (4 hours including ferry)
**Best for:** British Columbia's capital, Butchart Gardens, English tea culture

**Getting there:**
- Drive to Tsawwassen Ferry Terminal (45 min)
- BC Ferries to Swartz Bay (1hr 35min)
- Drive to Victoria (30 min)

**Must-do:**
- Inner Harbour walk
- Butchart Gardens (book timed entry)
- Fisherman's Wharf
- Parliament Buildings
- Afternoon tea at Empress Hotel (book ahead)

**Tips:**
- Book ferry reservations in summer (essential)
- Leave early (first ferry is less crowded)
- Can also take Harbour Air seaplane (30 min, expensive but scenic)

### Squamish (1 hour)
**Best for:** Rock climbing, hiking, more accessible nature

**Activities:**
- Sea to Sky Gondola
- Stawamus Chief hike (serious climb, incredible views)
- Shannon Falls
- Britannia Mine Museum

**Tips:**
- Better weather than Vancouver (rain shadow)
- Good pit stop en route to Whistler
- Rock climbing capital of BC

### Bowen Island (20 min ferry)
**Best for:** Quick island escape, hiking, relaxed pace

**Getting there:** BC Ferries from Horseshoe Bay (20 min crossing)

**Activities:**
- Killarney Lake loop hike
- Artisan shops in Snug Cove
- Kayaking and beaches
- Excellent farm-to-table restaurants

**Tips:**
- Walk-on passengers only (no car needed)
- Takes full day to appreciate
- Much quieter than Victoria

### Deep Cove (30 min)
**Best for:** Easy half-day trip, kayaking, village charm

**Activities:**
- Quarry Rock hike (easy, 1.5 hours round trip)
- Kayak/paddleboard rentals
- Honey Donuts (legendary)
- Cute village browsing

**Tips:**
- Go on weekday to avoid crowds
- Arrive early for Honey Donuts (sells out)
- Combine with Capilano or Lynn Canyon

### Gulf Islands (half to full day)
**Best for:** Island hopping, artisan communities, nature

**Accessible islands:**
- Salt Spring Island (market Saturdays, artists)
- Galiano Island (hiking, quiet)
- Mayne Island (historic, smallest population)

**Tips:**
- Salt Spring Saturday Market is excellent
- Book ferry ahead in summer
- Consider overnight for full experience

## Local Etiquette

### Tipping Standards
| Service | Expected Tip |
|---------|--------------|
| Restaurant | 18-20% (pre-tax) |
| Bar | $1-2/drink or 18-20% |
| Coffee shop | $1 or round up (not mandatory) |
| Taxi/Uber | 15-18% |
| Hair/spa | 18-20% |
| Hotel housekeeping | $2-5/night |

**Important:** Tip is often auto-suggested at 18/20/22% on card machines. Pre-tax is technically correct but post-tax is increasingly common.

### Social Norms
- **Punctuality**: Canadians are generally on time
- **Personal space**: Respect it; don't stand too close
- **Queuing**: Lines are sacred. Don't cut.
- **Apologies**: Canadians say "sorry" reflexively. Join in.
- **Small talk**: Weather is always safe. Politics can be touchy.
- **Shoes in homes**: Usually remove at the door (Asian influence + rain)

### Cannabis
- **Legal for 19+** (matching alcohol age in BC)
- **Where to buy**: BC Cannabis stores or licensed private retailers
- **Where to consume**: Private property only. No public smoking in parks or near schools.
- **Don't**: Drive high (DUI applies), cross border with it, give to minors

### Alcohol
- **Legal age**: 19 in BC
- **Where to buy**: BC Liquor Stores (government) or licensed private stores
- **No corner store beer**: Unlike some provinces
- **Bars close**: 1am-3am depending on venue
- **Don't**: Open container in public, drink on beaches (technically illegal, sometimes tolerated)

## Safety Notes

### Generally Very Safe
Vancouver consistently ranks among the world's safest cities.

### Areas of Caution
**Downtown Eastside (DTES):**
- Roughly east of Carrall St, around Hastings St
- Visible homelessness, drug use, mental health crisis
- Safe to walk through during day, avoid alone at night
- Not dangerous to tourists typically, just uncomfortable

**Late Night Granville:**
- Nightclub area gets rowdy after 1am
- Some aggressive behavior on weekends
- Stay aware, travel in groups

### Common Concerns
- **Theft**: Bike theft is epidemic. Never leave bike unlocked.
- **Car break-ins**: Don't leave valuables visible, especially Downtown
- **Wildlife**: Bears in North Shore suburbs (rare in city). Keep distance.
- **Earthquakes**: Vancouver is earthquake zone. Know basics.

### Emergency Numbers
- **911**: Police, fire, ambulance
- **811**: Health information line (non-emergency)
- **BC Crisis Line**: 1-800-SUICIDE (1-800-784-2433)

## Money-Saving Tips

### Free Activities
- Stanley Park seawall walk
- Granville Island (browsing free, food costs)
- Queen Elizabeth Park
- Lynn Canyon (free suspension bridge)
- Beach time (Spanish Banks, Kits, Jericho)
- Cherry blossoms (spring)
- First Thursday: Vancouver Art Gallery by donation
- Various free museum days (check websites)

### Transit Savings
- Day pass ($11.25) worth it after 3+ trips
- All zones free after 6:30pm with stored value
- Walk if within Downtown core (15 min covers most)

### Food Savings
- Supermarket sushi is excellent and cheap ($5-10)
- Food courts in Richmond (authentic, affordable)
- Lunch specials better value than dinner
- Grocery stores: Save-On-Foods, No Frills, Superstore

### Accommodation Savings
- Book early (prices rise closer to date)
- HI Hostels are clean and well-located
- Jericho Beach HI is cheapest with great location
- Weekends often cheaper than weekdays
- Consider North Van or Burnaby (cheaper, good transit)

## Packing Essentials

### Always Pack
- Rain jacket with hood
- Layers (mornings cool, afternoons warm)
- Comfortable walking shoes
- Water bottle (tap water excellent)
- Reusable shopping bag (bag charge everywhere)

### Summer Additions
- Sunscreen
- Sunglasses
- Light hiking shoes (for trails)
- Swimsuit

### Winter Additions
- Warm waterproof jacket
- Warm layers underneath
- Umbrella (compact, wind-resistant)
- Ski gear if planning mountains
