# Vancouver Lodging Guide

## Best Areas to Stay

### Downtown — Best for First-Timers
**Pros:** Walking distance to everything, transit hub, restaurants
**Cons:** Most expensive, noisy, less character

**Best for:** Business travelers, first-time visitors, cruise access

**Price range:** $150-400/night (mid-range to luxury)

**Top picks:**
- **Luxury:** Fairmont Pacific Rim ($600+), Rosewood Hotel Georgia ($500+)
- **Upscale:** JW Marriott Parq ($300+), Hyatt Regency ($250+)
- **Mid-range:** Victorian Hotel ($150+), Moda Hotel ($180+)
- **Budget:** YWCA Hotel ($100+), HI Vancouver Downtown ($40+ dorm)

### Yaletown — Stylish & Central
**Pros:** Restaurants, seawall access, trendy vibe
**Cons:** Limited hotel options, less transit

**Best for:** Food lovers, young professionals, couples

**Price range:** $200-400/night

**Top picks:**
- OPUS Vancouver ($300+) — boutique, excellent service
- Hotel BLU ($200+) — modern, good value
- Airbnbs prevalent here

### West End / English Bay — Beach Access
**Pros:** Stanley Park adjacent, beaches, residential feel
**Cons:** Fewer hotels, need to walk/transit to Downtown

**Best for:** Beach lovers, Stanley Park focus, longer stays

**Price range:** $150-350/night

**Top picks:**
- Sylvia Hotel ($180+) — historic, beachfront, book ahead
- Coast Plaza ($200+) — apartment-style, Denman St location
- English Bay Inn B&B ($200+) — Victorian charm

### Gastown — Historic Character
**Pros:** Architecture, restaurants, walkable to Downtown
**Cons:** Edges into DTES (see safety notes), loud nightlife

**Best for:** Architecture fans, foodies, nightlife seekers

**Price range:** $150-300/night

**Top picks:**
- Skwachàys Lodge ($200+) — Indigenous art hotel, unique
- Hotel & Suites by Pacific Gateway ($180+)
- St. Regis Hotel ($150+) — basic but well-located

**Safety note:** Stay west of Carrall St. East side transitions to Downtown Eastside (DTES) — Canada's most concentrated area of poverty and drug use. Safe to walk through during day, avoid at night.

### Kitsilano — Local Lifestyle
**Pros:** Beach, laid-back vibe, restaurants, UBC access
**Cons:** 20 min to Downtown, fewer hotel options

**Best for:** Beach lovers, longer stays, families, UBC visitors

**Price range:** $150-250/night (mostly Airbnb/vacation rentals)

**Top picks:**
- Corkscrew Inn ($180+) — B&B, excellent hosts
- Airbnb dominates this area

### North Vancouver — Nature Focus
**Pros:** Mountains, trails, Grouse/Capilano access
**Cons:** 30 min to Downtown, need transit/car

**Best for:** Outdoor enthusiasts, mountain activities, quiet escape

**Price range:** $150-300/night

**Top picks:**
- Lonsdale Quay Hotel ($200+) — SeaBus terminal, water views
- Pinnacle Hotel at the Pier ($250+) — waterfront
- Holiday Inn Express ($150+) — practical, free breakfast

## Budget Options (<$100/night)

### Hostels
| Name | Location | Dorm Rate | Private Room |
|------|----------|-----------|--------------|
| HI Vancouver Downtown | Downtown | $40-60 | $100-140 |
| HI Vancouver Jericho Beach | Kits | $35-50 | $90-120 |
| Samesun Vancouver | Granville | $35-55 | $100-130 |
| Cambie Hostel Gastown | Gastown | $35-50 | $90-120 |

**Best value:** HI Jericho Beach — beachfront location, huge grounds, kitchen facilities. Worth the commute.

### Budget Hotels
- **YWCA Hotel** ($100-150): Downtown, clean, basic, great location
- **Burrard Hotel** ($140-180): Motor lodge aesthetic, central, popular
- **Victorian Hotel** ($150-200): Historic, quirky, Gastown-adjacent

### Airbnb Reality
- **Legal:** Only owner's primary residence, max 30 days/year if not present
- **Availability:** Limited legal supply, prices often match hotels
- **Best value:** Longer stays (weekly discounts), suburbs

## Luxury Options ($400+/night)

### Top Tier
| Hotel | Style | Starting Price | Best For |
|-------|-------|----------------|----------|
| Fairmont Pacific Rim | Modern luxury | $600+ | Business, views, spa |
| Rosewood Hotel Georgia | Heritage glamour | $500+ | Historic elegance |
| Shangri-La | Contemporary Asian | $400+ | Long stays, residences |
| Loden Hotel | Boutique luxury | $350+ | Intimate, personalized |

### Worth the Splurge
- **Fairmont Pacific Rim**: Best spa in city (Willow Stream), harbour views, rooftop restaurant (Botanist)
- **Rosewood Georgia**: 1920s heritage building, impeccable service, Hawksworth restaurant
- **Wedgewood Hotel**: Family-owned boutique, European elegance, Bacchus restaurant/bar

## Booking Strategy

### When to Book
- **Summer (Jun-Aug):** 2-3 months ahead minimum
- **Cherry blossom (late Mar-early Apr):** 1-2 months ahead
- **Shoulder (Sep-Nov, Apr-May):** 2-4 weeks ahead
- **Winter (Dec-Mar):** 1-2 weeks ahead (except holidays)

### Best Rates
- Direct booking often matches OTAs with better cancellation
- Hotwire/Priceline blind booking works well (predictable city)
- Join loyalty programs for free upgrades
- Weekend rates often cheaper than weekdays (business city)

### What to Avoid
- Hotels on Granville St south of Drake (noisy nightclub strip)
- Anything east of Gastown (DTES proximity)
- Airport hotels unless you have early flight (45 min from city)

## Neighborhood Proximity Chart

| From \ To | Downtown | Stanley Park | Granville Island | Capilano | Whistler |
|-----------|----------|--------------|------------------|----------|----------|
| Downtown | — | 15 min walk | 15 min ferry | 30 min bus | 2 hours |
| Yaletown | 10 min | 20 min walk | 10 min ferry | 35 min | 2 hours |
| West End | 10 min | 5 min walk | 20 min | 30 min | 2 hours |
| Gastown | 5 min | 20 min walk | 20 min | 30 min | 2 hours |
| Kits | 15 min bus | 20 min | 10 min | 40 min | 2 hours |
| North Van | 20 min SeaBus | 30 min | 35 min | 10 min | 1.5 hours |

## For Specific Travelers

### Business Travelers
**Stay:** Downtown core near Canada Place
**Picks:** Fairmont Waterfront, Pan Pacific, Hyatt Regency
**Why:** Convention center proximity, business services, airport access

### Families
**Stay:** West End or North Vancouver
**Picks:** Coast Plaza (kitchen), Pinnacle North Van, Airbnb houses
**Why:** Space, parks nearby, quieter evenings

### Couples/Romance
**Stay:** Yaletown or West End
**Picks:** OPUS, Loden, Sylvia Hotel
**Why:** Restaurants, walkable evenings, seawall sunsets

### Solo Budget Travelers
**Stay:** Downtown or Jericho hostels
**Picks:** HI Vancouver hostels, Samesun
**Why:** Social atmosphere, free activities, transit access

### Outdoor Enthusiasts
**Stay:** North Vancouver or Squamish
**Picks:** Lonsdale Quay, Squamish hotels/Airbnbs
**Why:** Trail access, skip the commute, mountain proximity
