# Vancouver Attractions Guide

## Must-See (Worth Every Minute)

### Stanley Park
**The crown jewel of Vancouver.** 405-hectare urban park surrounded by ocean.

**What makes it special:**
- Seawall: 10km paved path around the entire park (walk, bike, rollerblade)
- Old-growth forest with 500,000+ trees
- Totem poles at Brockton Point — Indigenous art in stunning setting
- Third Beach for sunset watching
- Lost Lagoon for bird watching

**Practical tips:**
- Rent bikes at Denman St (~$10/hour, $30-40/day)
- Go counterclockwise for ocean views on your right
- 2-3 hours minimum, full day ideal
- Bring layers — park is cooler than city

**Skip:** Stanley Park Train (kids only), Miniature Railway (underwhelming)

### Granville Island
**Former industrial site turned artisan paradise.** Under the Granville Bridge.

**What makes it special:**
- Public Market: Local produce, prepared foods, artisan goods
- Craft breweries: Granville Island Brewing pioneer
- Artist studios and galleries
- Kids Market for families
- Kayak/paddleboard rentals

**Practical tips:**
- Go weekday morning to avoid crowds
- Ferry from Downtown ($3.50) is part of the experience
- Lunch at market, wander afternoon
- 3-4 hours ideal

**Skip:** Most tourist shops (overpriced). Focus on food and studios.

### Capilano Suspension Bridge Park
**Dramatic suspension bridge 70m above canyon.** North Vancouver.

**What makes it special:**
- Main bridge: 137m long, genuinely thrilling
- Treetops Adventure: Boardwalks through old-growth canopy
- Cliffwalk: Glass-bottomed walkway on granite cliff face

**Practical tips:**
- **Expensive**: $60+ adults. Buy online for small discount.
- **Free alternative**: Lynn Canyon Suspension Bridge (smaller but free, genuine nature)
- Go early morning or late afternoon (10am-2pm is sardine time)
- Free shuttle from Downtown (Canada Place)
- 2-3 hours minimum

### Grouse Mountain
**"Peak of Vancouver."** Ski resort and year-round attraction.

**Summer attractions:**
- Skyride (gondola) with stunning views
- Grouse Grind: Infamous 2.9km stair-climb (853m elevation gain)
- Wildlife refuge (bears, wolves)
- Ziplining, ropes courses

**Winter attractions:**
- Night skiing with city lights below
- Snowshoeing, skating

**Practical tips:**
- Grouse Grind is **brutal** — 1.5-2.5 hours up, only for fit hikers
- Skyride down is mandatory ($15) — no walking down Grind
- Full Skyride ticket ~$70 includes attractions
- Free shuttle from Canada Place

### Gastown
**Vancouver's oldest neighborhood.** Cobblestones and Victorian architecture.

**What makes it special:**
- Steam Clock (every 15 min, tourist trap but iconic)
- Excellent restaurants and bars
- Boutique shopping
- Architecture and history
- Gateway to Chinatown

**Practical tips:**
- Best for dinner and evening drinks
- Walk east of Water St with caution (transitions to DTES)
- Combine with Chinatown visit
- 2-3 hours for exploration

### Canada Place
**Iconic sail-shaped waterfront complex.** Downtown on water.

**What makes it special:**
- FlyOver Canada: 4D flight simulation across Canada (genuinely good)
- Cruise ship terminal (watch massive ships)
- Convention center with public spaces
- Olympic Cauldron from 2010
- Start point for seawall walks

**Practical tips:**
- FlyOver Canada: $30+, book time slot, 30-45 min
- Good starting point for Downtown exploration
- Sunset views of mountains and Lions Gate Bridge

## Excellent (Time Permitting)

### Museum of Anthropology (UBC)
**World-class Indigenous art collection.** Arthur Erickson building.

Worth it for:
- Bill Reid's sculptures (The Raven and the First Men)
- Massive totem poles and longhouse
- Global cultural collections
- Building itself is architectural masterpiece

**Practical:** $18 adults, 2-3 hours, Tues 5-9pm discounted

### VanDusen Botanical Garden
**55 acres of curated gardens.** Queen Elizabeth Park area.

Worth it for:
- Different garden styles (Korean, Mediterranean, etc.)
- Festival of Lights in December (spectacular)
- Peaceful escape from city

**Practical:** $12 adults, 2 hours minimum

### Dr. Sun Yat-Sen Classical Chinese Garden
**First authentic Chinese garden outside China.** Chinatown.

Worth it for:
- Traditional Ming Dynasty design
- Peaceful oasis in busy Chinatown
- Architecture imported from Suzhou
- Cultural context and guided tours

**Practical:** $14 adults, 1-1.5 hours

### Lighthouse Park
**Old-growth forest meets ocean.** West Vancouver.

Worth it for:
- Genuine old-growth trees (some 500+ years)
- Point Atkinson Lighthouse
- Rocky shores for tide pooling
- No crowds (locals' secret)

**Practical:** Free, 2-3 hours hiking, bring good shoes

### Queen Elizabeth Park
**Highest point in Vancouver.** Cambie at 33rd.

Worth it for:
- 360° city and mountain views
- Bloedel Conservatory (tropical dome)
- Free outdoor sculptures and gardens
- Cherry blossoms in spring

**Practical:** Park free, Conservatory $7, 1-2 hours

## Skip These (Tourist Traps)

### Vancouver Lookout
**Problem:** $18 for views you get free from many spots.
**Alternative:** Free views from Harbour Centre food court, or hike to better viewpoints.

### Vancouver Aquarium (in Stanley Park)
**Problem:** Expensive ($42+), small, controversial on ethics.
**Alternative:** See marine life at Ucluelet/Tofino whale watching instead.

### Robson Street Shopping
**Problem:** Generic chain stores, crowded.
**Alternative:** Gastown and Main St have unique local shops.

### Capilano (if budget-conscious)
**Problem:** $60+ for touristy experience.
**Alternative:** Lynn Canyon (free, authentic forest, smaller bridge).

### English Bay Beach (for beach time)
**Problem:** Crowded, small, basic.
**Alternative:** Spanish Banks, Third Beach, or Jericho for better beaches.

## Seasonal Considerations

### Spring (Apr-May)
- **Cherry blossoms**: Stunning throughout city (free!). Peak early April.
- **Key spots**: Queen Elizabeth Park, VanDusen, many residential streets
- Weather improving, prices lower than summer

### Summer (Jun-Aug)
- **Best time to visit.** Warm, dry, long days.
- Everything open, outdoor festivals
- Book accommodation far in advance
- Beach season

### Fall (Sep-Oct)
- Excellent shoulder season
- Fall colors in Stanley Park
- Fewer crowds, lower prices
- Weather still decent (some rain)

### Winter (Nov-Mar)
- Rain and grey dominate
- Indoor activities focus
- Ski season (Grouse, Whistler)
- Festival of Lights at VanDusen
- Cheapest accommodation

## Day Trip Additions

If you have time beyond city attractions:

| Destination | Distance | Worth For |
|-------------|----------|-----------|
| Whistler | 2 hours | Skiing, village, summer hiking |
| Victoria | 3.5 hours (incl ferry) | Parliament, Butchart Gardens, British feel |
| Squamish | 1 hour | Climbing, Sea to Sky Gondola, Chief hike |
| Bowen Island | 20 min ferry | Easy island escape, hiking, cafes |
| Fort Langley | 1 hour | Historic fur trade town, antiques |
| Deep Cove | 30 min | Kayaking, Quarry Rock hike, cute village |

See `visitor-tips.md` for detailed day trip planning.
