# Vancouver Transportation Guide

## Transit Overview

Vancouver has excellent public transit by North American standards, operated by TransLink.

### The Network

**SkyTrain (Metro):**
- 3 lines: Expo, Millennium, Canada
- Automated, driverless
- Frequent (2-5 min peak, 5-10 min off-peak)
- Clean, safe, reliable

**Buses:**
- Extensive network
- Real-time tracking
- B-Line: Express routes
- Night Owl: Late night (limited routes)

**SeaBus:**
- Ferry to North Vancouver
- 12 minutes crossing
- Every 10-15 minutes
- Scenic commute option

**West Coast Express:**
- Commuter rail to Mission
- Weekday rush hours only
- For far-east commuters

---

## SkyTrain Lines

### Expo Line (1986)
**Route**: Waterfront ↔ King George (Surrey)
**Key stations:**
- Waterfront (SeaBus, Canada Place)
- Burrard (Downtown business)
- Stadium-Chinatown (events, Chinatown)
- Main Street-Science World (Mount Pleasant)
- Commercial-Broadway (transfer hub)
- Metrotown (Burnaby malls)
- New Westminster (historic)
- Surrey Central (Surrey hub)

### Millennium Line (2002)
**Route**: VCC-Clark ↔ Lafarge Lake (Coquitlam)
**Key stations:**
- VCC-Clark (community college)
- Commercial-Broadway (transfer to Expo)
- Renfrew, Rupert (East Van)
- Lougheed (Burnaby)
- Burquitlam, Coquitlam Central, Lafarge Lake (Tri-Cities)

### Canada Line (2009)
**Route**: Waterfront ↔ Richmond (and YVR airport)
**Key stations:**
- Waterfront (downtown hub)
- Vancouver City Centre (underground mall)
- Yaletown-Roundhouse (Yaletown)
- Olympic Village (False Creek)
- Broadway-City Hall (medical, South Granville)
- Oakridge (mall, development)
- YVR-Airport (direct to terminal)
- Richmond-Brighouse (Richmond centre)

---

## Compass Card System

### Card Types
| Type | Cost | Best For |
|------|------|----------|
| **Compass Card** | $6 (refundable) | Regular users |
| **Day Pass** | $11.25 | Tourists, day trips |
| **Monthly Pass** | $102.55-177.75 | Daily commuters |

### Zones (Stored Value)
| Zones | Peak | Off-Peak |
|-------|------|----------|
| 1 Zone | $3.15 | $2.55 |
| 2 Zones | $4.55 | $2.55 |
| 3 Zones | $6.05 | $2.55 |

**Off-peak**: Weekends + after 6:30pm weekdays = 1-zone fare anywhere

### How It Works
1. Tap in at start of journey
2. Tap out at end (SkyTrain) or as exiting (bus, back door)
3. System charges based on zones crossed
4. Transfer within 90 minutes included

### Getting a Compass Card
- SkyTrain stations (machines)
- London Drugs, 7-Eleven
- Online (shipped)
- Load value at stations, online, or stores

### Tap vs Credit Card
Credit card tap works (contactless) but:
- Charged per tap (no transfer)
- More expensive
- Compass Card recommended for regular use

---

## Bus System

### Bus Types
| Type | Description | Example |
|------|-------------|---------|
| **Regular** | Standard routes | 4 (4th Ave) |
| **B-Line** | Express, frequent | 99 (Broadway) |
| **RapidBus** | Limited stops | R4 (41st Ave) |
| **Night Owl** | Late night | N9, N24 |
| **Community Shuttle** | Small, residential | C-routes |

### Key Routes

**High frequency (5-8 min):**
- **99 B-Line**: Broadway (UBC to Commercial)
- **9**: Broadway/Boundary
- **4/44**: 4th Ave (UBC to Downtown)
- **R4**: 41st Ave express

**Useful routes:**
- **10**: Granville (downtown to Marpole)
- **20**: Commercial Drive
- **25**: Brentwood to UBC
- **33**: Stanley Park

### Real-Time Tracking
- TransLink app
- Google Maps (integrated)
- Bus stop digital signs
- Text: Send stop number to 33333

---

## SeaBus

### Route
Waterfront Station ↔ Lonsdale Quay (North Van)

### Schedule
- Every 10-15 minutes
- 12-minute crossing
- 6am-1am (varies by day)

### The Experience
- Scenic views of harbour, mountains
- Part of regular Compass fare
- Bikes allowed
- Connects to North Van buses

### Why Use It
- Most pleasant commute in city
- Better than Lions Gate Bridge traffic
- Access to North Shore

---

## Cycling

### Infrastructure
Vancouver has extensive cycling infrastructure:
- Protected bike lanes downtown
- Seawall (around False Creek, Stanley Park)
- Greenways (residential routes)
- Bike-friendly transit (buses have racks, SkyTrain allows bikes)

### Bike Share (Mobi)
**How it works:**
- Stations throughout city
- Unlock with app or membership
- Return to any station

**Pricing:**
- Day pass: $12
- Monthly: $15
- Annual: $129

**Coverage**: Downtown, East Van, Kitsilano (expanding)

### Cycling Tips
- Helmets required by law (any age)
- Bike theft is epidemic—use good lock
- Rain gear essential
- Watch for streetcar tracks

### Bike Routes
**Recommended:**
- Seawall (scenic, flat)
- Adanac Greenway (east-west, calm)
- Ontario Street (north-south)
- Point Grey Road (west-side, views)

---

## Ride-Hailing & Taxis

### Uber/Lyft
- Available throughout Metro Vancouver
- Comparable pricing to taxis
- Surge pricing during busy times

### Taxis
- Yellow Cab, Black Top, Maclure's
- Can hail on street downtown
- Call/app for suburbs
- Similar cost to Uber/Lyft

### Typical Costs
| Route | Taxi/Uber |
|-------|-----------|
| Downtown to Airport | $35-45 |
| Downtown to Kitsilano | $15-25 |
| Downtown to North Van | $30-40 |

---

## Car Sharing

### Evo (Free-floating)
- **How it works**: Find car anywhere, park anywhere (within zone)
- **Cost**: $0.45/min, $17.99/hr, $104.99/day
- **Includes**: Gas, insurance, parking
- **Best for**: One-way trips

### Modo (Co-op)
- **How it works**: Book car at designated spots, return to same spot
- **Cost**: Membership + hourly/distance
- **Best for**: Planned trips, longer rentals

### Car Rental
Major companies at airport and downtown:
- Book ahead for weekends
- Expensive compared to many cities
- Consider for Whistler/day trips

---

## Driving

### Traffic Reality
- Rush hour congestion significant
- Lions Gate Bridge bottleneck (North Shore)
- Tunnel (to Richmond) slow
- Downtown parking expensive and scarce

### Parking
**Downtown:**
- Street meters: $4-6/hour
- Lots: $10-30/day
- Residential areas: Permit required

**Elsewhere:**
- Generally easier
- Free street parking in residential areas
- Mall parking usually free

### ICBC Insurance
- Government monopoly on basic insurance
- Expensive ($2,000-4,000/year typical)
- Required to drive
- Can add optional coverage from private insurers

---

## Airport (YVR) Transportation

### Canada Line (SkyTrain)
- **To Downtown**: 25 minutes
- **Cost**: $5 extra surcharge + fare ($9-10 total)
- **Frequency**: Every 6-8 minutes
- **Hours**: 5am-1am (approximately)

### Taxi/Uber
- **To Downtown**: 25-40 minutes (traffic dependent)
- **Cost**: $35-50
- **Flat rate zones available

### Car Rental
- All major companies at airport
- Pre-book recommended

**Recommendation**: Canada Line is best value for solo travelers. Taxi/Uber better for groups with luggage.

---

## Getting to Whistler

### Drive
- 2 hours via Sea to Sky Highway
- Stunning scenery
- Winter: Check conditions, chains sometimes required
- Rental car or car-share (Evo to Squamish, not Whistler)

### Bus
**YVR Skylynx:**
- Direct from airport
- $30-45 each way
- Multiple daily departures

**Whistler Shuttle:**
- From Downtown
- Similar pricing

### Ride Share
- Poparide app (Canadian ride share)
- Facebook groups

### Helicopter
- Harbour Air (splurge option)
- 30 minutes
- $200-400/person
- Scenic but expensive
