# Vancouver Tech Industry

## Overview

Vancouver is Canada's third-largest tech hub (after Toronto and Montreal) with unique strengths in gaming, VFX, and proximity to Seattle.

### Key Stats (2026)
- **Tech workers**: ~120,000 in Metro Vancouver
- **Tech companies**: 10,000+
- **Average tech salary**: $95,000-130,000 CAD
- **Growth**: Steady expansion, especially AI/ML

---

## Major Employers

### Big Tech (Vancouver Offices)
| Company | Employees | Focus |
|---------|-----------|-------|
| Amazon | 5,000+ | AWS, Alexa, various |
| Microsoft | 1,500+ | LinkedIn, cloud, gaming |
| Apple | 500+ | Engineering, services |
| Meta | 200+ | AR/VR (reduced from peak) |
| Google | 300+ | Cloud, engineering |
| SAP | 1,500+ | Enterprise software |
| Salesforce | 500+ | Cloud CRM |

### Gaming Giants
| Company | Focus |
|---------|-------|
| EA (Electronic Arts) | Sports games (FIFA, NHL) |
| Activision Blizzard | Call of Duty, WoW |
| Capcom | Resident Evil, etc. |
| Nintendo | Software development |
| Sony | PlayStation development |

### VFX/Animation
| Company | Known For |
|---------|-----------|
| Industrial Light & Magic | Star Wars, Marvel |
| DNEG | Dune, Inception |
| Sony Pictures Imageworks | Spider-Verse |
| MPC | Lion King |
| Animal Logic | LEGO Movies |

### Canadian Success Stories
| Company | What They Do |
|---------|--------------|
| Hootsuite | Social media management |
| Slack (now Salesforce) | Founded here |
| BuildDirect | E-commerce |
| Clio | Legal tech |
| Trulioo | Identity verification |
| Dapper Labs | NBA Top Shot, Flow |
| Later | Social scheduling |
| Unbounce | Landing pages |

---

## Salary Ranges (CAD, 2026)

### Software Engineering
| Level | Range | Notes |
|-------|-------|-------|
| Junior (0-2 yrs) | $70,000-95,000 | New grads |
| Mid (2-5 yrs) | $95,000-130,000 | Typical |
| Senior (5-8 yrs) | $130,000-180,000 | Lead roles |
| Staff/Principal | $180,000-250,000 | Rare, big tech |

### By Company Type
| Type | Range | Notes |
|------|-------|-------|
| Big Tech (FAANG) | $150,000-300,000+ | Total comp with stock |
| US Remote | $120,000-250,000 USD | Paid in USD |
| Scale-up | $100,000-170,000 | Series B+ |
| Startup | $80,000-130,000 | Equity variable |
| Agency | $70,000-120,000 | Lower ceiling |

### Other Tech Roles
| Role | Range |
|------|-------|
| Product Manager | $100,000-180,000 |
| UX Designer | $80,000-140,000 |
| Data Scientist | $90,000-160,000 |
| DevOps/SRE | $100,000-170,000 |
| QA Engineer | $70,000-110,000 |

### Vancouver vs Seattle/SF
| | Vancouver | Seattle | SF |
|--|-----------|---------|-----|
| Senior SWE | $150K CAD | $200K USD | $250K USD |
| After tax + health | ~$105K | ~$140K | ~$160K |
| Rent (1BR) | $2,400 | $2,200 | $3,500 |

**Trade-off**: Lower salary but healthcare included, better work-life balance, PR pathway.

---

## Tech Neighborhoods

### Downtown
- Salesforce, SAP offices
- WeWork, coworking spaces
- Central, good for meetings

### Yaletown
- Startup scene
- Hootsuite HQ
- Trendy, good restaurants

### Mount Pleasant
- Tech startup density
- Breweries after work
- Creative agencies

### Gastown
- Digital agencies
- Smaller startups
- Historic character

### Burnaby/Metrotown
- EA headquarters
- Microsoft nearby
- Cheaper rent, good transit

---

## Finding Tech Jobs

### Job Boards
- **LinkedIn**: Primary source
- **Indeed**: Broad listings
- **Glassdoor**: Reviews + jobs
- **AngelList**: Startups
- **BetaKit Jobs**: Canadian tech specific
- **Vancouver Tech Jobs** (Facebook group)

### Recruiters
- Robert Half Technology
- Hays
- Randstad
- Many boutique tech recruiters

### Networking
- **Vancouver Startup Week**: Annual event
- **Tech Vancouver**: Meetup groups
- **Ladies Learning Code**: Women in tech
- **DevHub**: Coworking + events

---

## BC Tech Pilot (Immigration)

Fast-track PR pathway for tech workers.

### Eligibility
- Job offer from BC employer in eligible occupation
- Occupation on BC PNP tech list (29 occupations)
- Meet other PNP requirements

### Processing
- Weekly draws (vs monthly for regular PNP)
- ~2-3 months for nomination
- Then Express Entry or regular PR

### Eligible Occupations Include
- Software developers/engineers
- Web developers
- Database analysts
- Information systems analysts
- Computer engineers
- Interactive media developers

See `immigration.md` for full details.

---

## Remote Work Reality

### US Remote Jobs
Many Vancouver tech workers have US remote jobs:
- Paid in USD (exchange rate benefit)
- Higher salaries
- Work for US companies without visa

**Considerations:**
- Tax complexity (file both countries)
- May need to incorporate
- Time zone alignment (PST = same as West Coast US)
- Legal employment status varies

### Canadian Remote
- Growing acceptance
- Shopify, Automattic fully remote
- Many startups now remote-first

---

## Gaming Industry Deep Dive

Vancouver is a global gaming hub.

### Why Here
- Tax credits (BC Interactive Digital Media Tax Credit: 17.5%)
- Talent pool from VFS, VanArts
- Quality of life attracts talent
- Time zone works for global

### Major Studios
| Studio | Games |
|--------|-------|
| EA Vancouver | FIFA, NHL, Need for Speed |
| Activision/Toys for Bob | Call of Duty support |
| Capcom Vancouver | Dead Rising (was) |
| Blackbird Interactive | Homeworld |
| Klei Entertainment | Don't Starve |
| Phoenix Labs | Dauntless |

### Roles in Gaming
- **Programmers**: Engine, gameplay, tools
- **Artists**: 3D, concept, VFX
- **Designers**: Game, level, systems
- **Producers**: Project management
- **QA**: Testing (entry point)

---

## VFX/Animation Industry

### Tax Credit Appeal
- 17.5% Provincial + 16% Federal = significant savings
- Hollywood productions do post-production here

### Major Projects Done Here
- Avengers films
- Star Wars
- Dune
- Spider-Man: Into the Spider-Verse

### Schools Feeding Pipeline
- Vancouver Film School (VFS)
- Lost Boys School of VFX
- Think Tank Training Centre
- Emily Carr University

---

## Startups & VC

### Funding Landscape
- Growing but smaller than Toronto/SF
- Notable VCs: Version One, Yaletown Partners, BDC
- Angel networks active

### Incubators/Accelerators
- **Launch Academy**: Prominent accelerator
- **Spring**: Health/social impact
- **Foresight**: Clean tech
- **Creative Destruction Lab**: Academic-linked

### Co-working Spaces
- WeWork (multiple locations)
- Spaces (Regus)
- The Profile (boutique)
- The Hive
- Launch Academy space

See `startup.md` for detailed startup guide.

---

## Education & Upskilling

### Universities
| School | Strengths |
|--------|-----------|
| UBC | CS, engineering |
| SFU | CS, interactive arts |
| BCIT | Applied tech, practical |
| Emily Carr | Design, digital media |

### Bootcamps
- Lighthouse Labs (web dev)
- BrainStation (various)
- RED Academy (closed, was popular)

### Certifications
- AWS, Azure, GCP (cloud)
- Google Analytics
- Scrum/Agile

---

## Work Culture

### Vancouver Tech Culture
- Generally better work-life balance than SF
- Less hustle culture
- Outdoor-focused (ski Fridays, etc.)
- More Canadian (less aggressive)

### What to Expect
- 40-hour weeks typical (less crunch than US)
- Flexible work arrangements common
- 2-4 weeks vacation standard
- Benefits usually include extended health

### Downsides
- Salaries lower than US
- Career ceiling can be lower (fewer executive roles)
- Smaller market than Toronto
- Some companies treat Vancouver as "cost center"
