# Vancouver Startup Ecosystem

## Ecosystem Overview

Vancouver has a growing startup scene, smaller than Toronto but with unique strengths.

### Strengths
- **Gaming/VFX talent pool**: World-class
- **US proximity**: Same timezone as Seattle/SF
- **Quality of life**: Attracts talent
- **Clean tech focus**: BC hydroelectric advantage
- **Cost arbitrage**: Cheaper than SF (still expensive)

### Weaknesses
- **Smaller VC pool**: Less late-stage capital
- **Brain drain**: Some talent goes to US
- **Housing costs**: Hard to recruit on startup salary
- **Scale challenge**: Market size limitations

---

## Funding Landscape

### Seed ($500K-2M)
- Angel investors active
- Some local VCs do seed
- Programs: Techstars, Y Combinator (apply remotely)

### Series A ($3-10M)
- Version One Ventures
- Yaletown Partners
- Vanedge Capital
- Round13 Capital

### Series B+ ($10M+)
- Often need US investors
- BDC Capital
- Some Toronto/US funds

### Alternative Funding
| Source | Amount | Best For |
|--------|--------|----------|
| IRAP | $50K-500K | R&D tech |
| SR&ED | 35%+ refund | R&D spending |
| Futurpreneur | $60K | Young founders |
| BDC | Variable | Loans |
| Revenue-based | Variable | Recurring revenue |

---

## Accelerators & Incubators

### Accelerators
| Program | Focus | Investment |
|---------|-------|------------|
| Creative Destruction Lab | Deep tech | Mentorship |
| Foresight | Clean tech | $100K+ |
| Spring | Health/social | Varies |
| AccelerateOkanagan | General | Limited |

### Incubators
| Program | Focus |
|---------|-------|
| Launch Academy | General tech |
| SFU VentureLabs | University spinouts |
| BCIC | Innovation programs |
| New Ventures BC | Competition + support |

### Global Programs
- Y Combinator (many BC alumni)
- Techstars (Seattle close)
- 500 Startups

---

## Co-Working & Community

### Startup-Focused Spaces
| Space | Notes |
|-------|-------|
| Launch Academy | Events, community |
| WeWork | Multiple locations |
| The Hive | Local, multiple |
| Innovation Hub (SFU) | Academic connection |

### Community Events
- **Startup Week Vancouver**: Annual festival
- **Demo days**: Various programs
- **Tech Vancouver meetups**: Multiple
- **BetaKit events**: Canadian tech news

### Online Communities
- Vancouver Startup Slack
- BC Tech Association
- LinkedIn groups
- Reddit r/vancouver tech threads

---

## Legal & Corporate

### Incorporation
- BC or Federal incorporation
- Most startups incorporate provincially first
- Delaware C-Corp for US VC (sometimes needed)

### Lawyer Needs
- Incorporation documents
- Founder agreements
- Employment agreements
- IP assignment
- Term sheets

### Startup-Friendly Lawyers
- Many firms have startup practices
- Fixed-fee packages common
- Defer payment programs exist

---

## Hiring for Startups

### Talent Pool
- Strong: Engineering, design, gaming
- Growing: Data science, ML
- Challenge: Compete with big tech salaries

### Compensation
| Stage | Typical Cash | Equity |
|-------|--------------|--------|
| Pre-seed | Below market | 0.5-2% |
| Seed | Near market | 0.1-0.5% |
| Series A | Market | 0.05-0.25% |

### Where to Find Talent
- LinkedIn
- AngelList
- Tech Vancouver jobs
- University recruiting (UBC, SFU, BCIT)
- Referrals (most effective)

### Immigration
- BC Tech Pilot helps hire internationally
- Work permit process takes months
- Plan ahead for key hires

---

## Tax Credits

### SR&ED (Scientific Research & Experimental Development)
- 35% refundable credit (small business)
- Covers salaries, materials, contractors
- Complex application process
- Use SR&ED consultants

### BC Interactive Digital Media Tax Credit
- 17.5% of BC labor
- For games, VFX, digital media
- Significant for gaming startups

### Other Credits
- BC Training Tax Credit
- Clean Tech incentives
- Various federal programs

---

## Notable Vancouver Startups

### Exits
| Company | Exit | Year |
|---------|------|------|
| Slack | $27.7B (Salesforce) | 2020 |
| Avigilon | $1B (Motorola) | 2018 |
| Hootsuite | $1B+ (private) | Ongoing |
| BuildDirect | IPO/various | Ongoing |

### Unicorns/Near-Unicorns
- Dapper Labs (Flow, NBA Top Shot)
- Clio (legal tech)
- Trulioo (identity)

### Growing
- Later (social media)
- Unbounce (landing pages)
- Article (furniture)
- Thinkific (online courses)

---

## Startup-Friendly Resources

### Free/Subsidized
| Resource | What |
|----------|------|
| Small Business BC | Free advice, resources |
| Futurpreneur | Mentoring + loans |
| IRAP | Funding advisors |
| BCIC | Programs, connections |
| Community Futures | Loans, advice |

### Competitions
- New Ventures BC ($250K+ prizes)
- BC Tech Pitch Nights
- Various university competitions

---

## Common Paths

### Local Focus
1. Bootstrap or angel funding
2. Build in Vancouver
3. BC PNP for hiring
4. Local customers first
5. Expand nationally

### US Market Focus
1. Incorporate Delaware C-Corp
2. Apply to US accelerators
3. Raise US VC
4. Keep engineering in Vancouver (cost)
5. Sales/HQ in US

### Remote-First
1. Hire anywhere
2. Vancouver as base
3. Global customers
4. Avoid location constraints

---

## Getting Started Checklist

### Week 1
- [ ] Register business
- [ ] Set up banking
- [ ] Basic legal (founder agreements)

### Month 1
- [ ] Build MVP
- [ ] Talk to customers
- [ ] Apply to programs

### Month 3
- [ ] Validate problem-solution fit
- [ ] First revenue or strong traction
- [ ] Start fundraising if needed

### Resources
- **Startup Grind Vancouver**: Community
- **BC Tech**: Association
- **VEC**: Vancouver Economic Commission
- **Small Business BC**: Practical help
