# Vancouver Safety Guide

## Overall Safety

Vancouver is one of the world's safest major cities. Violent crime is rare, especially against tourists and newcomers.

### Safety Rankings
- Consistently ranked in top 10 safest cities globally
- Low violent crime rates
- Strong police presence
- Active communities

---

## Areas of Concern

### Downtown Eastside (DTES)

**What it is**: Canada's most concentrated area of poverty, homelessness, mental health crisis, and opioid epidemic.

**Boundaries (roughly)**:
- Carrall St to Main St
- Hastings to the waterfront
- Epicenter: Main & Hastings intersection

**Reality for visitors/residents**:
- **Not typically dangerous** to passersby
- **Uncomfortable**: Visible drug use, suffering, unpredictable behavior
- **Day vs Night**: Daytime generally fine to walk through; avoid alone at night
- Residents of nearby areas (Gastown, Chinatown, Strathcona) navigate this regularly

**Practical advice**:
- Walk with purpose, don't engage
- Don't leave valuables visible in car
- Keep phone/wallet secure
- It's safe to make eye contact and say "no thanks"
- If someone is in distress, call 911 or 311

**Context**: This is a humanitarian crisis, not a crime problem. The people there are largely victims of addiction, mental illness, and poverty. Vancouver is actively working on solutions but progress is slow.

### Granville Street (Late Night)

**Area**: Granville St between Robson and Drake

**Issue**: Nightclub district gets rowdy after 1am
- Drunk crowds
- Occasional fights
- Some aggressive behavior

**Advice**: Travel in groups, avoid confrontations, use ride-hailing

### SkyTrain Late Night

**Generally safe** but:
- Some late-night trains see more problems
- Expo Line through DTES area occasionally has issues
- Stay aware, travel with others if possible

---

## Property Crime

### Bike Theft
Vancouver has an **epidemic of bike theft**:
- Don't leave bike unlocked even for 30 seconds
- Use high-quality U-lock (Kryptonite, Abus)
- Lock frame AND wheels
- Register bike with 529 Garage (free app)
- Indoor storage whenever possible

### Car Break-ins
- Don't leave anything visible (even empty bags)
- Downtown and some East Van areas higher risk
- Underground parking safer than street

### Package Theft
- Common from doorsteps
- Use delivery lockers, workplace delivery, or pickup points

---

## Natural Hazards

### Earthquakes

**Reality**: Vancouver is in a seismically active zone. "The Big One" is statistically overdue.

**Preparation**:
- Keep grab bag ready (water, food, flashlight, documents)
- Know building's earthquake protocol
- Identify safe spots (under sturdy table, doorway)
- Have family meeting point

**In an earthquake**:
1. DROP, COVER, HOLD ON
2. Stay away from windows
3. If outside, move away from buildings
4. After shaking stops, assess and evacuate if needed

**Resources**: PreparedBC website has full guidance

### Forest Fires (Wildfire Smoke)

**When**: July-September

**Impact**: Smoke from BC interior fires can blanket Vancouver
- Air quality can be hazardous
- Visibility reduced
- Health impacts for vulnerable people

**During smoke events**:
- Check air quality (AQI) before outdoor activities
- N95 masks help
- Run air purifiers indoors
- Limit strenuous outdoor exercise

### Flooding/Heavy Rain

- Storm drains can overflow in extreme rain
- Some areas (particularly Richmond, low-lying) at flood risk
- Generally manageable with good infrastructure

---

## Wildlife

### Bears

**Where**: North Shore, some East Van neighborhoods near forest

**Reality**:
- Black bears enter residential areas for garbage
- Usually avoid humans
- Fatal attacks extremely rare

**What to do**:
- Don't leave garbage out
- If you see bear: Make noise, back away slowly
- Don't run, don't approach
- Bears with cubs = extra caution

### Coyotes

**Where**: Throughout city, especially near parks

**Reality**:
- Urban coyotes are common
- Generally avoid humans
- Small pets at risk

**What to do**:
- Keep small dogs/cats supervised
- Don't feed coyotes
- Make noise if approached

### Cougars

**Where**: Very rare in city; North Shore/trail areas occasionally

**What to do**: Make yourself large, don't run, fight back if attacked

### Sea Life

- Jellyfish occasionally at beaches (usually harmless)
- No sharks to worry about at beaches
- Seals and sea lions visible (keep distance)

---

## Health Safety

### Drug Crisis

**Opioid epidemic context**:
- Fentanyl contamination widespread in street drugs
- Over 2,000 overdose deaths/year in BC
- Any street drug potentially contaminated
- Naloxone kits available free

**If you or someone is using**:
- Never use alone
- Free naloxone kits from pharmacies
- Supervised consumption sites exist
- 911 = Good Samaritan protection (won't be arrested for calling)

### COVID/Respiratory

- BC has good vaccination rates
- Masks optional (individual choice)
- Healthcare system accessible

### Water Quality

- Tap water is excellent (mountain reservoirs)
- No need for bottled water
- Safe to drink from public fountains

---

## Emergency Contacts

| Service | Number |
|---------|--------|
| Police/Fire/Ambulance | 911 |
| Non-emergency police | 604-717-3321 |
| City services | 311 |
| Health info line | 811 |
| Poison Control | 1-800-567-8911 |
| BC Crisis Line | 1-800-784-2433 |

### Emergency Apps
- **AlertReady**: National emergency alerts
- **PreparedBC**: Emergency information
- **PulsePoint**: Nearby emergencies

---

## Neighborhood Safety Guide

### Very Safe (Minimal Concerns)
- West Vancouver
- North Vancouver (residential)
- Kerrisdale
- Kitsilano
- Point Grey
- Dunbar

### Safe (Normal Urban Awareness)
- Downtown (most areas)
- Yaletown
- West End
- Mount Pleasant
- Commercial Drive
- Burnaby, Richmond, New Westminster

### Exercise Caution
- Gastown (east edges, late night)
- Chinatown (DTES-adjacent)
- Strathcona (DTES-adjacent)
- Granville Street (late night)
- Some East Van pockets

### Avoid at Night
- Downtown Eastside (DTES)

---

## Personal Safety Tips

### General
- Trust your instincts
- Stay aware of surroundings
- Avoid confrontation
- Use well-lit routes at night
- Tell someone where you're going (hiking, etc.)

### Transit
- Sit near driver on buses
- Use well-populated train cars
- Most stations have emergency intercom

### Going Out
- Watch your drink
- Travel in groups
- Share ride info with friend
- Have phone charged

### Hiking
- Tell someone your plan
- Check trail conditions
- Bring: Water, layers, flashlight, phone
- North Shore mountains claim lives yearly—respect them

---

## Reporting Issues

### To Police
- **Emergency**: 911
- **Non-emergency**: 604-717-3321
- **Online**: vpd.ca for non-urgent reports

### To City
- **311**: General city issues
- **VanConnect app**: Report issues with photos

### Specific Issues
- Suspicious activity → Non-emergency police
- Drug use/mental health crisis → 311 or VPD mental health team
- Traffic issues → 311
- Building safety → City building inspections
