# Moving to Vancouver — Resident Guide

## First Week Checklist

### Before Arrival
- [ ] Arrange temporary accommodation (1-2 weeks minimum)
- [ ] Research neighborhoods
- [ ] Line up job/income if not transferring
- [ ] Gather rental documents (see Housing section)

### Day 1-3
- [ ] Get phone/SIM card
- [ ] Apply for SIN (Social Insurance Number) if new to Canada
- [ ] Open bank account
- [ ] Get transit Compass Card

### Week 1
- [ ] Start housing search
- [ ] Apply for BC Services Card (provincial ID)
- [ ] Apply for MSP (healthcare) if eligible
- [ ] Set up utilities knowledge (see Local Services)

---

## Getting Your SIN (Social Insurance Number)

**Required for**: Working, banking, tax, benefits

**How to apply:**
- **In person**: Service Canada office (bring passport, work permit/PR card)
- **Online**: If you have a valid GCKey account
- **Processing**: Same day in person, 5-10 days online

**Bring:**
- Primary ID (passport)
- Immigration document (work permit, PR card, study permit)
- Canadian address (even temporary)

**Note**: Apply immediately on arrival. Needed for employment, banking.

---

## Banking

### Big 5 Banks
All are similar. Choose based on branch convenience:
| Bank | Strengths |
|------|-----------|
| TD | Most branches, longest hours |
| RBC | Largest overall |
| BMO | Good small business |
| Scotiabank | International presence |
| CIBC | Digital features |

### Account Types
- **Chequing**: Day-to-day transactions
- **Savings**: Higher interest, transfer for bills
- **Credit card**: Build Canadian credit history

### To Open Account
Bring:
- Passport
- Work permit/PR card/visa
- SIN (or receipt)
- Canadian address
- Some cash to deposit

**Newcomer packages**: Most banks offer fee-free period for newcomers. Ask specifically.

### Credit Building
- Canadian credit history starts at zero
- Get secured credit card if needed
- Pay full balance monthly
- Takes 6-12 months to build
- Landlords will check (see Housing)

### Digital Banks
- **Tangerine**: No-fee, online
- **EQ Bank**: High interest savings
- **Wealthsimple Cash**: Modern, no fees

---

## Housing

### Rental Market Reality
- **Vacancy rate**: ~1% (extremely tight)
- **Speed**: Good units go within hours
- **Competition**: Multiple applications common
- **Scams**: Unfortunately common

### Documents Needed (Have Ready)
- [ ] Employment letter (recent, stating salary)
- [ ] Pay stubs (2-3 months)
- [ ] Bank statements (showing rent funds)
- [ ] References (landlords, employer)
- [ ] Government ID
- [ ] Credit check (Equifax Canada)

### Where to Search
**Primary:**
- Craigslist (still dominant)
- Facebook groups (Vancouver Rentals, etc.)
- Liv.rent (newer, verified)
- Padmapper (aggregates)

**Building-specific:**
- Property management company websites
- Hollyburn Properties
- Concert Properties
- Wall Financial

### Typical Costs
| Area | 1BR Range | 2BR Range |
|------|-----------|-----------|
| Downtown | $2,400-3,200 | $3,200-4,500 |
| East Van | $1,800-2,400 | $2,300-3,200 |
| Burnaby | $1,800-2,400 | $2,400-3,200 |
| New Westminster | $1,600-2,100 | $2,100-2,800 |

### Move-in Costs
- **Security deposit**: Maximum half month rent
- **Pet deposit**: Maximum half month rent
- **First month**: Due at signing
- **Total upfront**: 1-2 months rent

### Tenant Rights
BC has strong tenant protections:
- Rent increases: Once per year, capped (2024: 3.5%)
- Evictions: Difficult for landlords, many restrictions
- Repairs: Landlord must maintain habitability
- Resources: Tenant Resource & Advisory Centre (TRAC)

### Common Scams
- Never pay before seeing unit in person
- "Landlord overseas" = scam
- Too-good-to-be-true pricing = scam
- Verify ownership (land title search possible)

---

## Provincial ID & Healthcare

### BC Services Card
**What it is**: Provincial ID + healthcare card combined

**How to get:**
1. Book appointment at ICBC (Insurance Corporation of BC)
2. Bring: Passport, immigration docs, address proof
3. Photo taken
4. Card mailed (2-3 weeks)

### MSP (Medical Services Plan)
**BC's universal healthcare coverage**

**Eligibility:**
- Citizens/PRs: Eligible immediately
- Work permit holders: Usually eligible (check specifics)
- Students: Variable (check permit conditions)
- Visitors: NOT eligible

**Cost**: Free as of 2020 (previously ~$75/month)

**What's covered:**
- Doctor visits
- Hospital care
- Diagnostic tests
- Some specialists

**What's NOT covered:**
- Dental
- Vision (basic)
- Prescription drugs (PharmaCare for some)
- Physiotherapy
- Mental health (some)

**Supplemental insurance:**
- Through employer (common for FT jobs)
- Pacific Blue Cross
- Manulife
- Sun Life

**Wait period**: 3 months for new residents (get private travel insurance for gap)

---

## Utilities Setup

### What's Usually Included in Rent
- Water
- Garbage
- Often: Heat (in older buildings)

### What You'll Pay
| Utility | Provider | Monthly Cost |
|---------|----------|--------------|
| Electricity | BC Hydro | $30-80 |
| Natural Gas | FortisBC | $30-60 (heating dependent) |
| Internet | Various | $50-100 |
| Phone | Various | $50-100 |
| Contents Insurance | Various | $20-40 |

### BC Hydro (Electricity)
- Account setup online or phone
- Service address needed
- Budget billing available (average monthly)

### FortisBC (Gas)
- If your building uses gas heat/stove
- Similar setup to BC Hydro

### Internet Providers
| Provider | Speed | Monthly | Notes |
|----------|-------|---------|-------|
| Telus | Various | $70-120 | Fibre available |
| Shaw | Various | $70-110 | Cable |
| Novus | Fast | $50-80 | Select buildings only |
| Teksavvy | Various | $50-90 | Reseller, good value |

### Phone Plans
| Provider | Type | Monthly | Notes |
|----------|------|---------|-------|
| Rogers | Big 3 | $70-100 | Coverage |
| Telus | Big 3 | $70-100 | Coverage |
| Bell | Big 3 | $70-100 | Coverage |
| Freedom | Budget | $35-60 | Limited coverage |
| Koodo | Mid-tier | $45-75 | Telus network |
| Fido | Mid-tier | $45-75 | Rogers network |
| Public Mobile | Budget | $25-50 | Prepaid, basic |

**Reality**: Canadian phone plans are expensive by global standards.

---

## Driver's License

### Transferring License
BC has reciprocal agreements with many jurisdictions:
- **Full exchange**: US (most states), UK, Australia, Japan, Switzerland, Germany, etc.
- **Partial exchange**: Testing may be required
- **No exchange**: Many countries require full testing

### Getting BC License
1. Book appointment at ICBC
2. Bring: Current license, passport, address proof
3. Pass knowledge test (if required)
4. Pass road test (if required)
5. Pay fees ($15-80 depending on requirements)

### ICBC Insurance
BC has government monopoly on basic auto insurance:
- **Expensive**: $2,000-4,000/year typical
- **Required**: Can't drive without it
- **Optional add-ons**: From private insurers

### If You Don't Drive
Most people in central Vancouver don't need cars:
- SkyTrain + buses cover core areas
- Car-share (Evo, Modo) for occasional needs
- Cycling infrastructure good

---

## Essential Apps

| App | Purpose |
|-----|---------|
| **Compass** | Transit (tap card management) |
| **Google Maps** | Transit directions |
| **Evo** | Car sharing |
| **Modo** | Car sharing (co-op) |
| **Mobi** | Bike share |
| **Uber/Lyft** | Ride-hailing |
| **DoorDash** | Food delivery |
| **liv.rent** | Apartment hunting |
| **Craigslist** | Housing, used goods |
| **Vancouver Coastal Health** | Healthcare services |
| **PreparedBC** | Emergency alerts |

---

## Settling In Timeline

### Month 1
- Secure housing
- Set up banking, phone, utilities
- Get SIN, start MSP application
- Explore neighborhoods
- Establish routines (grocery, transit)

### Month 2-3
- BC Services Card appointment
- Driver's license (if needed)
- Build local network
- Find family doctor (can take months)
- MSP coverage kicks in

### Month 6+
- Credit history building
- Consider buying vs renting long-term
- Tax season prep (first year)
- Permanent address established
