# Metro Vancouver Suburbs: Burnaby, Richmond, Surrey & Beyond

## Burnaby

### The Feel
Satellite city with excellent SkyTrain access. More affordable than Vancouver, diverse population, good parks. Third-largest city in BC.

### Areas

**Metrotown:**
- **Feel**: Urban density, Asian influence, mall-centric
- **1BR rent**: $1,900-2,500
- **Transit**: Excellent (Expo Line, buses)
- **Best for**: Mall lovers, transit users, budget-conscious urbanites
- **Highlights**: Metropolis at Metrotown (largest mall in BC), diverse food

**Brentwood:**
- **Feel**: Redeveloping rapidly, new towers, "the new Metrotown"
- **1BR rent**: $2,000-2,600
- **Transit**: Good (Millennium Line)
- **Best for**: New condo seekers, tech workers, professionals
- **Highlights**: Brentwood Town Centre, new development

**Burnaby Mountain/SFU:**
- **Feel**: Academic, forested, isolated
- **1BR rent**: $1,600-2,100 (near SFU)
- **Transit**: Bus from SkyTrain stations
- **Best for**: SFU students/faculty
- **Highlights**: Simon Fraser University, mountain trails, views

**Lougheed:**
- **Feel**: Suburban mall area, practical
- **1BR rent**: $1,800-2,300
- **Transit**: Good (Millennium Line)
- **Best for**: Families, commuters

### Burnaby Summary
| Aspect | Rating | Notes |
|--------|--------|-------|
| Transit | ★★★★☆ | Excellent SkyTrain coverage |
| Affordability | ★★★★☆ | Better than Vancouver |
| Dining | ★★★☆☆ | Mall food courts, Crystal Mall |
| Nature | ★★★★☆ | Burnaby Lake, Central Park |
| Nightlife | ★★☆☆☆ | Minimal |

---

## Richmond

### The Feel
Asian food capital of North America (arguably). Flat, suburban, excellent dim sum. Canada Line makes Downtown accessible.

### Areas

**City Centre/Richmond Centre:**
- **Feel**: High-rises, malls, condos
- **1BR rent**: $1,900-2,500
- **Transit**: Excellent (Canada Line)
- **Best for**: Those wanting Asian food scene + transit

**Steveston:**
- **Feel**: Historic fishing village, charming
- **1BR rent**: $1,800-2,400
- **Transit**: Bus from Canada Line
- **Best for**: Families, those wanting village feel, seafood lovers
- **Highlights**: Fisherman's Wharf, fish & chips, boardwalk

**East Richmond:**
- **Feel**: Suburban, agricultural edges
- **1BR rent**: $1,600-2,200
- **Transit**: Limited
- **Best for**: Families with cars, value seekers

### Food Scene
Richmond has:
- **Best dim sum** in Metro Vancouver (arguably Canada)
- **Authentic Chinese regional cuisines**: Cantonese, Sichuan, Northern, HK
- **Japanese**: Excellent sushi, ramen
- **Korean**: BBQ, fried chicken
- **Night markets**: Summer weekend institutions

**Food courts** in Richmond malls are legitimate dining destinations.

### Richmond Summary
| Aspect | Rating | Notes |
|--------|--------|-------|
| Transit | ★★★★☆ | Canada Line is great |
| Affordability | ★★★☆☆ | Moderate |
| Dining | ★★★★★ | Asian food paradise |
| Nature | ★★☆☆☆ | Flat, no mountains |
| Nightlife | ★★☆☆☆ | Limited |

### Airport Note
Richmond is where YVR airport is. Good for frequent travelers but don't live near airport unless you like plane noise.

---

## New Westminster

### The Feel
Historic city, excellent SkyTrain hub, most affordable transit-accessible option. Working-class roots, diverse, unpretentious.

### Rent Reality (Feb 2026)
| Type | Range | Notes |
|------|-------|-------|
| 1BR | $1,600-2,100 | Best SkyTrain value |
| 2BR | $2,100-2,700 | Family-friendly |

### Transit
- **Expo Line + Millennium Line**: Major hub
- **Walk score**: 80+ near SkyTrain
- **Best value transit-accessibility in region**

### Best For
- Budget-conscious with transit needs
- Those priced out of Vancouver
- Families wanting space
- Hospital workers (Royal Columbian)

### Areas

**Downtown New West:**
- Historic buildings
- Columbia Street revival
- Restaurants improving
- River boardwalk

**Sapperton:**
- Hospital area
- More residential
- Good value

**Queensborough:**
- On island in Fraser River
- Cheapest (but isolated)
- Car-dependent

### New Westminster Summary
| Aspect | Rating | Notes |
|--------|--------|-------|
| Transit | ★★★★★ | Exceptional hub |
| Affordability | ★★★★★ | Best value |
| Dining | ★★★☆☆ | Improving |
| Nature | ★★★☆☆ | River access |
| Nightlife | ★★☆☆☆ | Very limited |

---

## Surrey

### The Feel
BC's second-largest city. Huge, sprawling, diverse. Reputation worse than reality. Some excellent areas, some rough ones.

### Areas

**Surrey Central/Whalley:**
- **Feel**: Urban center, developing rapidly
- **1BR rent**: $1,500-2,000
- **Transit**: Good (Expo Line terminus)
- **Reality**: Some rough edges, improving fast
- **Coming**: Surrey Langley SkyTrain extension

**Guildford:**
- **Feel**: Established suburban
- **1BR rent**: $1,500-1,900
- **Transit**: Bus to SkyTrain
- **Best for**: Families wanting value

**South Surrey/White Rock:**
- **Feel**: Beach town, older demographic
- **1BR rent**: $1,700-2,200
- **Transit**: Poor (bus only)
- **Best for**: Retirees, beach lovers with cars

**Newton/Fleetwood:**
- **Feel**: Diverse, South Asian influence
- **1BR rent**: $1,400-1,800
- **Transit**: Limited
- **Best for**: Budget families

### Surrey Reality Check
**The stigma:**
- Historical crime reputation
- Media focus on negatives
- Vancouver snobbishness

**The reality:**
- Fastest-growing city in BC
- Many areas are fine
- Good value for money
- Major development happening
- Transit improving

### Surrey Summary
| Aspect | Rating | Notes |
|--------|--------|-------|
| Transit | ★★★☆☆ | Good near SkyTrain only |
| Affordability | ★★★★★ | Most affordable |
| Dining | ★★★☆☆ | Indian food excellent |
| Nature | ★★★☆☆ | Some parks |
| Nightlife | ★★☆☆☆ | Very limited |

---

## Coquitlam & Port Moody

### Coquitlam
- **Feel**: Suburban, family-oriented
- **1BR rent**: $1,700-2,200
- **Transit**: Evergreen Extension (Millennium Line)
- **Best for**: Families, nature access (Coquitlam trails)
- **Highlights**: Coquitlam Centre, Lafarge Lake

### Port Moody
- **Feel**: "City of the Arts," waterfront revival
- **1BR rent**: $1,800-2,400
- **Transit**: Evergreen Extension
- **Best for**: Outdoorsy families, craft beer lovers
- **Highlights**: Brewers Row (Murray Street Brewing District), Rocky Point Park
- **Note**: Vancouver's best suburban craft beer scene

---

## Commute Reality

| From | To Downtown | By SkyTrain | By Car (Rush Hour) |
|------|-------------|-------------|-------------------|
| Metrotown | 20 min | ★★★★★ | 35-50 min |
| Richmond Centre | 20 min | ★★★★★ | 40-60 min |
| New Westminster | 30 min | ★★★★☆ | 45-60 min |
| Surrey Central | 40 min | ★★★★☆ | 60-90 min |
| Coquitlam | 45 min | ★★★☆☆ | 60-90 min |
| Langley | N/A | Bus only | 60-90 min |

---

## Making the Suburbs Decision

### Choose Suburbs If:
- Budget is primary constraint
- You need more space (kids, home office)
- You have a car
- You work flexible hours (avoid rush hour)
- You value newer construction
- You don't need walkable nightlife

### Suburb Ranking (Transit + Value)
1. **New Westminster**: Best balance
2. **Burnaby (Metrotown)**: Urban feel, good transit
3. **Richmond**: If you love Asian food
4. **Surrey Central**: If budget is priority
5. **Coquitlam**: If you have car + like nature
