# Vancouver Neighborhoods — Quick Comparison

## At a Glance

| Area | Vibe | 1BR Rent | Transit | Best For |
|------|------|----------|---------|----------|
| **Downtown** | Urban, busy | $2,400-3,200 | Excellent | Work, nightlife, convenience |
| **Yaletown** | Trendy, young pros | $2,500-3,300 | Good | Dining, seawall, style |
| **Coal Harbour** | Luxury, quiet | $2,800-4,000 | Good | Views, professionals |
| **West End** | Diverse, walkable | $2,000-2,600 | Excellent | Beach, Stanley Park |
| **Gastown** | Historic, hip | $2,200-2,800 | Good | Restaurants, nightlife |
| **Kitsilano** | Beach, lifestyle | $2,200-2,800 | Medium | Outdoor lovers, yoga |
| **Mount Pleasant** | Creative, Main St | $2,000-2,500 | Good | Breweries, arts, young |
| **East Van** | Affordable, diverse | $1,800-2,300 | Medium | Value, character |
| **Commercial Drive** | Bohemian, multicultural | $1,900-2,400 | Good | Community, coffee |
| **North Vancouver** | Nature, families | $2,000-2,600 | Medium | Mountains, trails |
| **West Vancouver** | Wealthy, exclusive | $3,000-5,000 | Poor | Luxury, privacy |
| **Burnaby** | Suburban, diverse | $1,800-2,400 | Good (Metrotown) | Value, SFU |
| **Richmond** | Asian hub, airport | $1,800-2,400 | Good (Canada Line) | Food, Asian culture |
| **New Westminster** | Historic, affordable | $1,600-2,100 | Excellent | Budget, SkyTrain |
| **Surrey** | Suburban sprawl | $1,400-1,900 | Improving | Families, affordability |

## By Lifestyle

### Young Professionals (No Kids)
1. **Yaletown** — Dining, seawall, rooftop bars
2. **Mount Pleasant** — Breweries, Main St, creative
3. **Gastown** — Historic, nightlife, restaurants
4. **West End** — Beach access, diverse, walkable

### Families
1. **North Vancouver** — Nature, good schools, safe
2. **Burnaby** — Parks, transit, more space
3. **Coquitlam** — Affordable houses, nature
4. **Kitsilano** — Beach lifestyle, but expensive

### Tech Workers
1. **Mount Pleasant** — Central, craft coffee, bikes
2. **Downtown/Yaletown** — Walk to most offices
3. **Burnaby (Metrotown)** — Near tech parks, cheaper
4. **East Van** — Value + character

### Students
1. **UBC Area** — On campus or Point Grey
2. **Commercial Drive** — Affordable, social
3. **Burnaby (SFU area)** — Near Simon Fraser
4. **New Westminster** — Cheapest with good transit

### Outdoor Enthusiasts
1. **North Vancouver** — Trails from doorstep
2. **Squamish** — Serious climbers/skiers (45 min commute)
3. **Kitsilano** — Beach + bike paths
4. **West End** — Stanley Park adjacent

### Budget Priority
1. **New Westminster** — Best transit-to-price ratio
2. **East Van** — Character + value
3. **Surrey (central)** — Most affordable
4. **Burnaby (non-Metrotown)** — Cheaper than Vancouver

## Transit Reality

### Excellent (Car-Free Viable)
- **Downtown core** — Walk + SkyTrain everywhere
- **West End** — Walk to Downtown, buses
- **Yaletown** — Canada Line station
- **New Westminster** — SkyTrain hub
- **Burnaby (Metrotown)** — SkyTrain + malls

### Good (Usually Fine)
- **Kitsilano** — Buses frequent, bike-friendly
- **Commercial Drive** — SkyTrain + buses
- **Mount Pleasant** — Buses, bike lanes
- **North Van (Lower)** — SeaBus + buses
- **Richmond (near Canada Line)** — SkyTrain access

### Medium (Doable but Slower)
- **East Van (further)** — Bus-dependent
- **Burnaby (not Metrotown)** — Need bus transfers
- **Surrey (central)** — Improving with SkyTrain extension

### Poor (Car Recommended)
- **West Vancouver** — Minimal service
- **North Van (Upper)** — Buses infrequent
- **Surrey (south)** — Spread out, limited transit
- **Langley** — Car-dependent
- **Coquitlam** — Evergreen Line helps but limited

## Noise Levels

### Quietest
- West Vancouver (sleepy suburban)
- North Vancouver (residential)
- Upper Kitsilano (away from beach)
- Burnaby suburbs

### Moderate
- West End (city living but not crazy)
- Mount Pleasant (normal urban)
- Commercial Drive (daytime buzz)
- Yaletown (restaurants, not clubs)

### Loudest
- Downtown Granville Street (nightclubs)
- Gastown (bars, tourists)
- Yaletown bars area
- Stadium area (events)

## Neighborhood Boundaries

**Note:** Vancouver neighborhoods blend into each other. Boundaries are fuzzy and locals debate them constantly.

### Core Vancouver (Vancouver proper)
All within City of Vancouver limits:
- Downtown, Yaletown, Coal Harbour, West End, Gastown
- Kitsilano, Point Grey, West Side
- Mount Pleasant, Fairview
- East Van, Commercial Drive, Hastings-Sunrise
- Marpole, Kerrisdale, Dunbar

### Metro Vancouver (Greater Vancouver)
Separate municipalities with own governments:
- North Vancouver (City and District)
- West Vancouver
- Burnaby
- Richmond
- New Westminster
- Surrey, Langley, Coquitlam, etc.

## Quick Decision Tree

```
Need to be car-free?
├─ Yes
│  ├─ Budget matters → New Westminster, East Van
│  ├─ Want trendy → Mount Pleasant, Commercial
│  └─ Want central → Downtown, West End, Yaletown
│
└─ No
   ├─ Outdoor focus → North Vancouver, Squamish
   ├─ Family space → Burnaby, Coquitlam, North Van
   └─ Luxury → West Vancouver, Coal Harbour
```

See individual neighborhood files for detailed breakdowns.
