# Downtown Vancouver, Yaletown & Coal Harbour

## Downtown Core

### The Feel
Urban heart of Vancouver. Glass towers, shopping, offices, transit hub. More functional than charming, but convenient.

### Boundaries
Roughly: Burrard to Carrall, Waterfront to False Creek

### Rent Reality (Feb 2026)
| Type | Range | Notes |
|------|-------|-------|
| Studio | $1,800-2,300 | Rare, usually older buildings |
| 1BR | $2,400-3,200 | Newer buildings higher |
| 2BR | $3,200-4,500 | Family-sized scarce |

### Transit
- **SkyTrain**: Multiple stations (Waterfront, Burrard, Granville, Stadium)
- **Buses**: Every major route passes through
- **Walk score**: 98

### Best For
- Corporate workers (walk to office)
- People who want everything walkable
- Nightlife/entertainment access
- Transit-dependent households

### Drawbacks
- Expensive for what you get
- Noisy (especially Granville corridor)
- Generic glass tower architecture
- Less community feel

### Specific Areas

**Granville Strip:**
- Nightclub row, entertainment district
- Loud on weekends
- Budget hotels, hostels
- Avoid if you value sleep

**Business District:**
- Office towers, quiet at night
- Near Canada Place, Convention Centre
- Older condo stock

**Stadium District:**
- Near BC Place, Rogers Arena
- Event-night crowds
- Good restaurants emerging

---

## Yaletown

### The Feel
Former warehouse district turned trendy. Exposed brick, designer boutiques, excellent restaurants. Young professionals and small dogs.

### Boundaries
Drake to Smithe, Hamilton to Homer (roughly)

### Rent Reality (Feb 2026)
| Type | Range | Notes |
|------|-------|-------|
| 1BR | $2,500-3,300 | Renovated lofts higher |
| 2BR | $3,500-4,800 | Limited availability |
| Loft/unique | $3,000-5,000 | Heritage conversion premium |

### Transit
- **Canada Line**: Yaletown-Roundhouse station
- **Walk**: 15 min to Downtown core
- **Seawall**: Direct access to False Creek

### Best For
- Young professionals
- Couples without kids
- Restaurant lovers
- Seawall runners/cyclists

### Restaurant Highlights
- **Blue Water Cafe**: Best seafood in city
- **Minami**: Premium Japanese
- **Cactus Club**: Upscale casual
- **Rodney's Oyster House**: Institution
- **Brix & Mortar**: Date night

### Nightlife
- **Bar None**: Club scene
- **Long Table Distillery**: Cocktails + tours
- **Local**: Sports bar/lounge

### Drawbacks
- Expensive (you pay for the name)
- Small units in converted warehouses
- Limited grocery options (need to walk out)
- Stroller-unfriendly (tiny sidewalks)

---

## Coal Harbour

### The Feel
Vancouver's most upscale residential area. Waterfront high-rises, marina views, quiet luxury. Older professionals and wealthy retirees.

### Boundaries
Waterfront from Canada Place to Stanley Park

### Rent Reality (Feb 2026)
| Type | Range | Notes |
|------|-------|-------|
| 1BR | $2,800-4,000 | Views command premium |
| 2BR | $4,000-6,000 | Luxury finishes |
| Penthouse | $8,000+ | Trophy properties |

### Transit
- **Walk**: 10-15 min to SkyTrain (Waterfront/Burrard)
- **Seawall**: Direct Stanley Park access
- **Float planes**: Harbour Air terminal nearby

### Best For
- High earners wanting quiet luxury
- Stanley Park daily walkers
- People who work from home
- Retirees with budget

### Lifestyle
- Morning seawall runs
- Yacht club membership
- Quiet evenings at home
- Stanley Park as backyard

### Drawbacks
- Very expensive
- Quiet to the point of boring
- Far from nightlife (which is the point)
- "International investor" reputation (many empty units)

### Notable
**Vancouver Convention Centre** expansions have made this area busier during conference season.

---

## Gastown (Downtown-Adjacent)

### The Feel
Vancouver's oldest neighborhood (1867). Cobblestones, heritage buildings, Steam Clock. Instagram-worthy but edges into rough area.

### Boundaries
Roughly: Carrall to Main, Waterfront to Hastings

### Rent Reality (Feb 2026)
| Type | Range | Notes |
|------|-------|-------|
| 1BR | $2,200-2,800 | Heritage character |
| 2BR | $3,000-3,800 | Limited stock |

### Transit
- **SkyTrain**: Waterfront station (10 min walk)
- **Walk**: Easy access to Downtown, Stadium

### Best For
- Architecture lovers
- Restaurant industry workers
- Photography enthusiasts
- History buffs

### Restaurant Scene
- **L'Abattoir**: French-Canadian fine dining
- **Tacofino**: Vancouver taco legend
- **Bao Bei**: Chinese brasserie
- **Pourhouse**: Classic cocktails
- **Alibi Room**: 50+ craft beers

### Critical Safety Note
**Gastown's east side transitions into Downtown Eastside (DTES)** — Canada's most concentrated poverty and opioid crisis area.

**Boundaries to know:**
- West of Carrall St = safe Gastown
- East of Carrall, around Hastings = DTES begins
- Main & Hastings = epicenter of crisis

**Reality:**
- Daytime: Can walk through, just uncomfortable
- Night: Avoid DTES entirely
- Actual danger to tourists: Low (they're not targeting you)
- But: Visible suffering, drug use, unpredictable behavior

**If you live in Gastown:**
- You'll walk through DTES for some services
- You'll get used to it, but it's confronting
- Political issue: don't expect it to resolve soon

### Drawbacks
- DTES proximity (above)
- Loud on weekends (bar district)
- Tourist-heavy daytime
- Parking nightmare
- Some buildings have maintenance issues

---

## West End

### The Feel
Dense but liveable. Diverse, LGBTQ+ friendly, walkable. Stanley Park on one side, English Bay on the other. Vancouver's most "neighborhood" Downtown area.

### Boundaries
Burrard to Stanley Park, Georgia to English Bay

### Rent Reality (Feb 2026)
| Type | Range | Notes |
|------|-------|-------|
| Studio | $1,600-2,000 | Older buildings |
| 1BR | $2,000-2,600 | Good value for location |
| 2BR | $2,800-3,500 | Larger units exist |

### Transit
- **Walk**: 15-20 min to Downtown SkyTrain
- **Buses**: Frequent on Robson, Davie, Denman
- **Walk score**: 96

### Best For
- Beach lovers (English Bay, Second Beach)
- Stanley Park enthusiasts
- LGBTQ+ community
- People wanting density without Downtown sterility

### Lifestyle
- Morning swims at English Bay
- Coffee shops on Denman
- Stanley Park seawall steps away
- Davie Street pride village
- Robson Street shopping

### Restaurant Scene
- Less fine dining than Yaletown
- More diverse casual options
- Excellent Japanese on Robson
- Good ramen, sushi

### Drawbacks
- Older building stock (character but less modern)
- Parking nearly impossible
- Can feel crowded in summer (beach tourists)
- Limited SkyTrain (bus-dependent)

### Specific Streets

**Denman Street:**
- Stanley Park gateway
- Bike rentals, ice cream, casual dining
- Local shops and services

**Davie Village:**
- LGBTQ+ hub
- Rainbow crosswalks
- Bars, restaurants, community

**Robson Street:**
- Shopping (chains mostly)
- Japanese restaurants
- Tourist-heavy
