# Choosing a Vancouver Neighborhood

## Decision Framework

### 1. Define Your Non-Negotiables

**Pick your top 2-3 from this list:**
- [ ] Transit-dependent (no car)
- [ ] Budget under $2,000/month
- [ ] Beach/water access
- [ ] Mountain/trail access
- [ ] Good schools
- [ ] Nightlife/restaurants nearby
- [ ] Space (2BR+ or yard)
- [ ] Quiet/residential
- [ ] Walkable neighborhood feel
- [ ] Near specific workplace

### 2. Match to Neighborhood Type

| If Your Priority Is... | Best Fits |
|------------------------|-----------|
| **Transit + Budget** | New Westminster, East Van |
| **Transit + Urban** | Downtown, Yaletown, Mount Pleasant |
| **Beach + Urban** | West End, Kitsilano |
| **Nature + Family** | North Vancouver, Coquitlam |
| **Restaurants + Culture** | Mount Pleasant, Commercial Drive |
| **Schools + Space** | North Van, Burnaby, Point Grey |
| **Absolute Budget** | Surrey, Langley, East Van edges |
| **Luxury + Privacy** | West Vancouver, Coal Harbour |

---

## Budget-Based Guide

### Under $1,800/month (1BR)
**Options are limited. Be flexible on location.**

| Area | What to Expect |
|------|----------------|
| East Van (outer) | Older buildings, bus-dependent |
| New Westminster | Best transit value, older stock |
| Surrey Central | Good SkyTrain, developing area |
| Burnaby (outer) | May need bus transfers |

**Strategy:**
- Look at basement suites
- Consider roommates in 2BR
- Expand search radius
- Act fast (competitive)

### $1,800-2,400/month (1BR)
**Sweet spot for value + location balance.**

| Area | What You Get |
|------|--------------|
| Mount Pleasant | Character, breweries, some commute |
| Commercial Drive | Community, cafes, SkyTrain access |
| East Van | Diversity, value, improving transit |
| Burnaby (Metrotown) | Urban, transit, Asian food |
| Richmond | Transit, incredible food |
| North Van (Lynn Valley) | Nature, space, SeaBus commute |

**Strategy:**
- Balance commute time vs rent savings
- Newer buildings cost more but have amenities
- Basement suites in good areas can be great value

### $2,400-3,200/month (1BR)
**Central locations, newer buildings possible.**

| Area | What You Get |
|------|--------------|
| Downtown | Walk to everything, convenience |
| Yaletown | Style, restaurants, seawall |
| West End | Beach, Stanley Park, walkable |
| Kitsilano | Beach lifestyle, character |
| Lower Lonsdale | Mountains, SeaBus, waterfront |

**Strategy:**
- Negotiate on longer leases
- Check for move-in incentives
- Newer buildings may include utilities

### $3,200+/month (1BR or Luxury)
**Premium locations, best stock.**

| Area | What You Get |
|------|--------------|
| Coal Harbour | Waterfront luxury, quiet |
| West Vancouver | Views, space, exclusivity |
| Yaletown penthouses | Design, rooftops |
| Fairview/South Granville | Central, galleries, restaurants |

---

## Lifestyle-Based Guide

### Young Professional (Single, 25-35)
**Priorities:** Social scene, dating, restaurants, minimal commute

**Best:** Yaletown, Mount Pleasant, Gastown
**Why:** Walkable to bars/restaurants, other young people, interesting
**Budget play:** Commercial Drive, East Van

### Couple (No Kids, Dual Income)
**Priorities:** Balance of space and convenience, starting to nest

**Best:** Kitsilano, Mount Pleasant, West End
**Why:** Good quality of life, restaurants, outdoor access
**Budget play:** East Van, Burnaby

### Young Family
**Priorities:** Space, schools, parks, safety

**Best:** North Vancouver, Burnaby, Kitsilano
**Why:** Good schools, family-friendly, nature
**Budget play:** New Westminster, Surrey (White Rock)

### Remote Worker
**Priorities:** Home office space, good wifi, walkable for sanity

**Best:** North Vancouver, Commercial Drive, Mount Pleasant
**Why:** Space for office, coffee shops, can escape house
**Budget play:** New Westminster, Burnaby

### Outdoor Enthusiast
**Priorities:** Trail access, ski proximity, outdoor community

**Best:** North Vancouver, Squamish (commutable), East Van
**Why:** Mountains accessible, outdoor culture
**Budget play:** Lynn Valley, Coquitlam

### Student
**Priorities:** Near school, affordable, social

**UBC:** Point Grey, Kitsilano, West Side
**SFU:** Burnaby Mountain, nearby Metrotown
**Other:** Commercial Drive, East Van

---

## Commute Reality Check

### Your Commute Tolerance

| Tolerance | Max One-Way | Best Areas |
|-----------|-------------|------------|
| Minimal (<15 min) | Walk/short transit | Live near work |
| Reasonable (15-30 min) | Standard for central | Downtown, West End, Yaletown, Mount Pleasant |
| Acceptable (30-45 min) | SkyTrain time | Burnaby, Richmond, New West, Kitsilano |
| Long (45-60 min) | Reading time | Surrey, Coquitlam, North Van (some) |
| Remote/Flexible | Any | Anywhere with good WFH setup |

### Transit vs Car Calculation

**Transit math:**
- Monthly pass: $102-178 (zones)
- No parking costs
- Time: Variable, often predictable

**Car math:**
- Insurance (ICBC): $150-300/month
- Gas: $150-300/month
- Parking (if Downtown): $200-400/month
- **Total: $500-1,000/month**

**Implication:** Living further out but needing a car may not save money.

---

## Housing Search Strategy

### Timeline
- **1-2 months out**: Start watching listings, learn market
- **3-4 weeks out**: Intensify search, schedule viewings
- **2-3 weeks out**: Submit applications
- **1-2 weeks out**: Finalize, sign lease

### Documents to Prepare
Have ready before searching:
- [ ] Employment letter (recent, confirms salary)
- [ ] Recent pay stubs (2-3 months)
- [ ] Bank statements (showing savings/rent funds)
- [ ] References (previous landlords, employer)
- [ ] Credit check (Equifax or TransUnion)
- [ ] Government ID copies

### Where to Search

**Primary:**
- Craigslist (still dominant in Vancouver)
- Facebook Marketplace + groups (Vancouver Rentals, etc.)
- Kijiji
- liv.rent (newer, verified listings)
- PadMapper (aggregates)

**For buildings:**
- Property management company websites directly
- Building-specific postings

**Avoid:**
- Scams (never send money before seeing unit)
- "Too good to be true" pricing
- Anyone refusing to show in person

### Viewing Checklist
- [ ] Water pressure (check taps, shower)
- [ ] Cell signal
- [ ] Natural light at different times
- [ ] Noise (traffic, neighbors)
- [ ] Laundry situation
- [ ] Storage
- [ ] Parking (if needed)
- [ ] Building security
- [ ] Ask about actual utilities cost
- [ ] Check for mold/damage

---

## Red Flags

### Listings
- Price significantly below market (likely scam)
- No photos or suspicious photos
- Landlord "out of country" (common scam)
- Requesting money before viewing
- Pressure to decide immediately

### Buildings
- Visible maintenance issues
- Unresponsive management
- Many vacancies (why?)
- No smoke/carbon monoxide detectors
- Pest signs

### Landlords
- No written lease
- Cash-only requests
- Entering without notice
- Excessive rules
- Bad online reviews

---

## Final Decision Matrix

Score each option 1-5:

| Factor | Weight | Option A | Option B | Option C |
|--------|--------|----------|----------|----------|
| Budget fit | x3 | | | |
| Commute time | x2 | | | |
| Neighborhood vibe | x2 | | | |
| Unit quality | x2 | | | |
| Amenities | x1 | | | |
| Future flexibility | x1 | | | |

**Total: _____ | _____ | _____**

The highest score wins, but trust your gut after viewings.
