# Vancouver Local Services Guide

## Banking

### Big 5 Banks
| Bank | Branches | Strengths |
|------|----------|-----------|
| TD | Many | Longest hours (some 8pm) |
| RBC | Many | Largest, good digital |
| BMO | Many | Small business |
| Scotiabank | Many | International transfers |
| CIBC | Many | Digital features |

### Opening Account
**Bring:**
- Passport
- Immigration document (work permit, PR, study permit)
- Canadian address
- SIN (or receipt of application)

**Newcomer packages**: All big banks offer fee-free periods (1-2 years) for newcomers. Ask specifically.

### Digital Banks
- **Tangerine**: No-fee, online-only
- **EQ Bank**: High interest savings
- **Wealthsimple Cash**: Modern interface

### Credit Union Alternative
- **Vancity**: BC's largest credit union
- Community-focused
- Sometimes better rates
- Shared ATM network

### ATM Fees
- Own bank: Free
- Other bank: $3-5
- Avoid convenience store ATMs (high fees)

---

## Phone & Internet

### Mobile Providers

**Big 3 (Best Coverage, Higher Price):**
| Provider | Plan Range | Notes |
|----------|------------|-------|
| Rogers | $70-100/mo | Best coverage |
| Telus | $70-100/mo | BC-based, good coverage |
| Bell | $70-100/mo | Good coverage |

**Mid-Tier (Same Networks, Better Value):**
| Provider | Plan Range | Notes |
|----------|------------|-------|
| Koodo | $45-75/mo | Telus network |
| Fido | $45-75/mo | Rogers network |
| Virgin | $45-75/mo | Bell network |

**Budget:**
| Provider | Plan Range | Notes |
|----------|------------|-------|
| Freedom | $35-60/mo | Limited coverage outside urban |
| Public Mobile | $25-50/mo | Prepaid, basic |
| Lucky Mobile | $25-45/mo | Prepaid |

**eSIM Options:**
- Most carriers support eSIM
- Can activate before arrival
- Useful for dual-SIM setups

### Internet Providers

| Provider | Type | Speed Range | Monthly |
|----------|------|-------------|---------|
| Telus | Fibre | 75-940 Mbps | $85-130 |
| Shaw | Cable | 75-1000 Mbps | $80-120 |
| Novus | Fibre | 100-1000 Mbps | $50-80 |
| Teksavvy | Reseller | 75-300 Mbps | $50-90 |

**Novus note**: Best value but only available in select buildings. Check before signing lease if internet matters.

**Bundle deals**: Telus and Shaw offer phone + internet bundles with savings.

---

## Mail & Packages

### Canada Post
- National postal service
- Post offices in Shoppers Drug Mart
- Mailbox delivery or PO Box

### Package Delivery
- **FedEx, UPS, DHL**: Standard carriers
- **Purolator**: Canadian-owned, good for local
- **Amazon lockers**: Throughout city
- **Penguin Pickup**: Pickup points for Amazon

### Package Theft
Common problem. Solutions:
- Delivery lockers (Amazon, Penguin)
- Ship to workplace
- FlexDelivery (Canada Post pickup)
- Building concierge if available

---

## Government Services

### Service BC
- Provincial services in one place
- BC Services Card, MSP enrollment
- Driver's license services
- Business registration

**Locations**: Downtown, Burnaby, Richmond, Surrey

### Service Canada
- Federal services
- SIN application
- Passport services
- Employment Insurance

### ICBC (Insurance Corporation of BC)
- Driver's licenses
- Vehicle registration
- Mandatory auto insurance
- **Notoriously slow**: Book appointments

### City of Vancouver
- Property taxes
- Business licenses
- Permits
- Contact: 311 or vancouver.ca

---

## Healthcare Services

### MSP (Medical Services Plan)
- BC's universal healthcare
- Free for residents
- Apply on arrival (3-month wait period)
- Get private insurance for gap

### Finding a Doctor
**Family doctor**:
- Shortage in BC
- May take months to find one accepting patients
- Register with pathwaysmedicalcare.ca
- Health Connect Registry

**Walk-in clinics**:
- Available throughout city
- Long waits (1-3 hours common)
- Good for minor issues
- Find: medimap.ca

### Pharmacies
| Chain | Hours | Notes |
|-------|-------|-------|
| Shoppers Drug Mart | Many 24hr | Canada Post inside |
| London Drugs | Standard | Electronics too |
| Rexall | Standard | Common |
| Costco Pharmacy | Membership | Cheap prescriptions |

### Emergency
- **911**: Life-threatening
- **ER**: Vancouver General, St. Paul's, BC Children's
- **Urgent Care**: For serious but not emergency

---

## Legal Services

### Immigration
- Immigration lawyers throughout city
- IRCC offices for federal services
- DIY resources: canada.ca/immigration

### General Legal
- **Lawyer Referral Service**: 604-687-3221
- **Legal Aid BC**: For low income
- **Small Claims Court**: Under $35,000

### Notary
- Notaries common for real estate
- Can find at many locations
- Cheaper than lawyer for simple documents

---

## Transportation Services

### TransLink
- Transit authority for Metro Vancouver
- translink.ca for planning
- Compass Card for payment

### ICBC
- Vehicle registration
- Driver's license
- Auto insurance (mandatory)
- Book appointments online (long waits)

### Car Share
- **Evo**: Free-floating
- **Modo**: Station-based, co-op

---

## Home Services

### Utilities Setup
| Utility | Provider | Contact |
|---------|----------|---------|
| Electricity | BC Hydro | bchydro.com |
| Gas | FortisBC | fortisbc.com |
| Water | City of Vancouver | Included in rent usually |

### Internet Installation
- Book 1-2 weeks ahead
- Self-install often available
- Technician visit: $0-100

### Moving Services
- Numerous local companies
- Get multiple quotes
- Book early for month-end
- Tip movers (standard)

### Repairs & Maintenance
- **Handyman**: TaskRabbit, Jiffy
- **Plumber/Electrician**: Licensed required, call around
- **Locksmith**: 24hr services available

---

## Pet Services

### Veterinary
- Many clinics throughout city
- Emergency 24hr: VCA Emergency
- Pet insurance recommended

### Dog Registration
- Required in Vancouver
- $35/year (neutered), $69 (intact)
- Online at vancouver.ca

### Dog Parks
- Off-leash parks throughout city
- Some beaches allow dogs seasonally

### Pet Stores
- PetSmart, Pet Valu
- Tisol (local, premium)
- Many independent shops

---

## Community Resources

### Libraries
- Vancouver Public Library (VPL)
- Free card with address proof
- Books, e-books, movies, museum passes
- Maker spaces, recording studios
- Digital resources (Lynda, etc.)

### Community Centers
- 24 locations across Vancouver
- Pools, gyms, programs
- Affordable recreation
- Community events

### Recreation
- Parks Board operates facilities
- OneCard for registration
- vancouver.ca/parks-recreation

---

## Immigrant/Newcomer Services

### Settlement Agencies
| Organization | Services |
|--------------|----------|
| ISSofBC | Settlement, employment, language |
| MOSAIC | Settlement, interpretation |
| SUCCESS | Chinese-focus services |
| DIVERSEcity | South Asian focus, Surrey |

### Language
- Free English classes (LINC program)
- Through settlement agencies
- Community center programs

### Credential Recognition
- BC has processes for foreign credentials
- Varies by profession
- Start early (can take months/years)

---

## Emergency Preparedness

### Earthquake Kit
Every household should have:
- Water (4L/person/day for 7 days)
- Non-perishable food (7 days)
- Flashlight and batteries
- Radio (battery or crank)
- First aid kit
- Important documents
- Cash
- Medications (7 days supply)

### Resources
- PreparedBC.ca
- Vancouver Emergency Management
- Great ShakeOut (annual drill)
