# Vancouver Outdoor & Lifestyle Guide

## The Outdoor Culture

Vancouver's defining characteristic is access to nature. Mountains, ocean, and forest are minutes away.

### The Reality
- People actually do ski on lunch breaks
- Hiking is a normal weekend activity
- Outdoor gear is everyday fashion
- "I went for a run" means trail run
- Wellness culture is strong

---

## Hiking

### Local Mountains (North Shore)

**Grouse Grind**
- **Difficulty**: Hard (853m elevation in 2.9km)
- **Time**: 1.5-2.5 hours up
- **Note**: Must take gondola down ($15)
- **Season**: May-October

**BCMC Trail**
- Alternative to Grind
- Less crowded
- Similar difficulty
- Same finish point

**Lynn Canyon Loop**
- **Difficulty**: Easy-moderate
- **Time**: 1-2 hours
- **Free suspension bridge**
- Great for beginners

**Quarry Rock (Deep Cove)**
- **Difficulty**: Easy
- **Time**: 1.5 hours round trip
- Crowded but worth it
- Rewards: Views, Honey Donuts after

**Lighthouse Park**
- **Difficulty**: Easy
- Old-growth forest
- Rocky shore
- Good for families

### Further Afield

**Joffre Lakes**
- 2.5 hours from city
- Turquoise glacier lakes
- Instagram famous (crowded)
- Day use pass required

**Garibaldi Lake**
- 3-4 hour hike
- Stunning alpine lake
- Camping available
- Permit required

**The Chief (Squamish)**
- Challenging
- Iconic granite peaks
- Multiple peaks
- 1 hour from city

### Hiking Safety
- Tell someone where you're going
- Check trail conditions
- Bring: Water, layers, headlamp
- Weather changes fast
- North Shore Search & Rescue is busy—respect the mountains

---

## Skiing & Snowboarding

### Local Mountains
| Mountain | Drive | Day Pass | Vibe |
|----------|-------|----------|------|
| Grouse | 20 min | $80 | Small, night skiing |
| Cypress | 30 min | $90 | Most terrain |
| Seymour | 30 min | $70 | Family-friendly |

### Whistler
- 2 hours drive
- World-class
- Day pass: $200+
- Season pass: $1,000-1,500
- Worth it for serious skiers

### Season
- November-April (local)
- November-May (Whistler)
- Best snow: January-February

### Getting Started
- Lessons available at all mountains
- Rentals on-mountain or in city
- Cheaper to buy used gear

---

## Water Activities

### Swimming
| Beach | Vibe |
|-------|------|
| English Bay | Central, social |
| Kitsilano | Pool + beach |
| Spanish Banks | Spacious, shallow |
| Third Beach | Quiet, Stanley Park |
| Jericho | Family-friendly |
| Wreck Beach | Clothing optional |

**Water temperature**: 12-18°C (cold but swimmable July-August)

### Kayaking/Paddleboarding
- Deep Cove rentals
- Granville Island rentals
- False Creek paddling
- Indian Arm exploration

### Sailing
- Royal Vancouver Yacht Club
- Jericho Sailing Centre (lessons)
- False Creek sailing

### Surfing
- Tofino (4 hours away): Best BC surfing
- Not in Vancouver proper

---

## Cycling

### Infrastructure
Vancouver has excellent cycling infrastructure:
- Protected lanes downtown
- Seawall (30+ km)
- Greenways throughout
- Bike-share (Mobi)

### Popular Routes
| Route | Distance | Vibe |
|-------|----------|------|
| Seawall loop | 28 km | Flat, scenic |
| Stanley Park | 10 km | Classic, must-do |
| Adanac Greenway | 10 km | East-west, calm |
| Central Valley Greenway | 25 km | Vancouver to Burnaby |

### Mountain Biking
North Shore is legendary for mountain biking:
- Fromme Mountain
- Mount Seymour
- Cypress
- World-class trails

### Bike Share (Mobi)
- Stations throughout city
- $15/month membership
- Great for getting around
- Electric bikes available

---

## Running

### Popular Routes
| Route | Distance | Notes |
|-------|----------|-------|
| Seawall (full) | 28 km | Flat, beautiful |
| Stanley Park | 10 km | Classic loop |
| False Creek | 8 km | Urban, accessible |
| Pacific Spirit | Varies | Trail running |

### Running Groups
- Vancouver Running Co
- Mile2Marathon
- Lululemon run clubs
- Many neighborhood groups

### Events
| Event | Month | Distance |
|-------|-------|----------|
| Vancouver Sun Run | April | 10K |
| BMO Vancouver Marathon | May | Marathon/half |
| Scotiabank Half | June | Half |
| Vancouver 5K | Various | 5K |

---

## Fitness

### Gyms
| Type | Examples | Monthly |
|------|----------|---------|
| Budget | Fit4Less, Planet Fitness | $10-20 |
| Mid-range | Steve Nash, Anytime | $40-60 |
| Premium | Equinox, YWCA | $100-200 |
| Boutique | CrossFit boxes, studios | $150-250 |

### Yoga
Vancouver is a yoga city:
- Yoga studios everywhere
- YYoga (local chain, good)
- Lululemon's home (started here)
- Hot yoga popular

### Specialty Fitness
- CrossFit (many boxes)
- Climbing (Hive, Cliffhanger)
- Spin (SoulCycle, Ride Cycle)
- Barre, Pilates
- Boxing (Eastside Boxing, etc.)

---

## Recreation Programs

### City of Vancouver
- Community centers (24 locations)
- Pools, ice rinks, gyms
- Affordable programs
- vancouver.ca/parks-recreation

### OneCard Registration
- Register for city programs
- Online booking
- Drop-in and registered programs

---

## Wellness Culture

### What's Big Here
- Yoga (obviously)
- Meditation/mindfulness
- Organic/local food
- Supplements/natural health
- Massage and bodywork
- Float tanks
- Saunas and bathhouses

### Wellness Services
- Massage therapy (RMTs)
- Naturopathic doctors
- Acupuncture
- Chiropractic
- Traditional Chinese Medicine

---

## Arts & Culture

### Museums
- Museum of Anthropology (UBC)
- Vancouver Art Gallery
- Science World
- Museum of Vancouver
- HR MacMillan Space Centre

### Theatre
- Arts Club Theatre
- Vancouver Playhouse
- Various independent
- Fringe Festival (September)

### Music
- Commodore Ballroom
- Rogers Arena (big acts)
- Vancouver Symphony
- Vancouver Opera
- Many small venues

### Festivals
| Festival | Month | Type |
|----------|-------|------|
| Vancouver Folk Fest | July | Music |
| Jazz Festival | June | Music |
| Fringe | September | Theatre |
| VIFF | September | Film |
| Celebration of Light | July/Aug | Fireworks |
| Pride | July/Aug | LGBTQ+ |

---

## Social Life

### Making Friends
- Activity-based groups work best
- Consistency key (same gym class, same bar)
- Meetup.com groups
- Sports leagues
- Volunteer organizations

### Sports Leagues
- Urban Rec (various sports)
- Vancouver Sport & Social Club
- Beach volleyball
- Soccer leagues
- Hockey leagues

### Dating Scene
- Apps dominant
- Outdoor dates popular
- Coffee culture
- "Vancouver freeze" is real

---

## Weekend Getaways

### Within 2 Hours
| Destination | Why Go |
|-------------|--------|
| Whistler | Skiing, village |
| Squamish | Climbing, hiking |
| Bowen Island | Easy island escape |
| Harrison Hot Springs | Hot springs |
| Gulf Islands | Islands, ferries |

### Longer Trips
| Destination | Distance | Why Go |
|-------------|----------|--------|
| Victoria | 4 hours | Capital, gardens |
| Tofino | 5 hours | Surfing, beaches |
| Kelowna | 4 hours | Wine country |
| Sunshine Coast | 2+ hours | Quieter coast |
