# Canadian Immigration from Vancouver

## Overview

Canada has one of the world's most transparent and skilled-worker-friendly immigration systems.

### Main Pathways
1. **Express Entry**: Points-based skilled worker
2. **Provincial Nominee Program (PNP)**: BC nominates you
3. **Work Permits**: Temporary, can lead to PR
4. **Study Permits**: Students → PGWP → PR
5. **Family Sponsorship**: Spouse/family already in Canada

---

## Express Entry

### What It Is
Federal points-based system for skilled workers. Three programs:
- Federal Skilled Worker (FSW)
- Canadian Experience Class (CEC)
- Federal Skilled Trades (FST)

### CRS Points (Comprehensive Ranking System)
| Factor | Max Points |
|--------|------------|
| Age | 110 |
| Education | 150 |
| Language (English/French) | 160 |
| Canadian work experience | 80 |
| Spouse factors | 40 |
| Skill transferability | 100 |
| **Subtotal** | **600** |
| Provincial Nomination | +600 |
| Job offer | +50-200 |
| Canadian education | +15-30 |
| French ability | +25-50 |
| Sibling in Canada | +15 |

### Current Cutoffs
- **General draws**: ~480-520 points (varies)
- **Category-based draws**: Lower for tech, healthcare, French

### Processing Time
- ~6 months once invited
- Create profile → receive ITA → submit full application → decision

---

## BC Provincial Nominee Program (BC PNP)

### BC Tech Pilot (Fast Track)

**What it is**: Accelerated stream for tech workers

**Eligible occupations** (29 total, including):
- Software developers
- Web developers/designers
- Database analysts
- Information systems analysts
- Computer engineers
- Graphic designers (digital)
- Technical writers

**Processing**:
- Weekly draws (vs monthly)
- ~2-3 months for nomination
- Nomination adds 600 CRS points

**Requirements**:
- Job offer from BC employer
- In eligible occupation
- Meet basic PNP requirements
- Job offer 1+ year

### Skills Immigration Stream

For workers not in tech pilot:
- Skilled Worker
- International Graduate
- Entry Level and Semi-Skilled

**Points-based** with factors like:
- Job offer details
- Work experience
- Education
- Language

---

## Work Permits

### LMIA-Based
- Employer proves no Canadian available
- Expensive and slow for employer
- Tied to specific employer

### LMIA-Exempt
| Type | Duration | For Who |
|------|----------|---------|
| IEC (Working Holiday) | 1-2 years | Young adults from treaty countries |
| Intra-Company Transfer | 1-3 years | Existing employees of global companies |
| CUSMA (formerly NAFTA) | 1-3 years | US/Mexico professionals |
| PGWP | 1-3 years | Graduates of Canadian institutions |

### International Experience Canada (IEC)
Popular for under-35s from eligible countries:
- Working Holiday: Open work permit
- Young Professionals: Job-specific
- International Co-op: Student internships

**Eligible countries**: UK, Ireland, Australia, France, Germany, Japan, Korea, many others

### Spouse/Partner Open Work Permit
If your partner has qualifying work permit or study permit, you may get open work permit.

---

## Study Permits → PR Pathway

### The Path
1. Accept at Canadian DLI (Designated Learning Institution)
2. Apply for study permit
3. Complete studies (2+ years ideal)
4. Apply for PGWP (Post-Graduation Work Permit)
5. Work in Canada (gain Canadian experience)
6. Apply for PR via Express Entry or PNP

### PGWP Duration
| Study Duration | PGWP Length |
|----------------|-------------|
| 8 months - 2 years | Length of study |
| 2+ years | 3 years |

### Why This Works
- Canadian education = CRS points
- Canadian work experience = CRS points
- PGWP gives time to find work
- BC PNP International Graduate stream

---

## PR Requirements

### General Requirements
- Pass medical exam
- Police certificates
- Meet financial requirements (proof of funds)
- Language test (IELTS, CELPIP, or TEF)
- Education credential assessment (WES, IQAS)

### Language Tests
| Test | For |
|------|-----|
| IELTS General | English (most common) |
| CELPIP | English (Canadian, computer-based) |
| TEF | French |

**Target scores** for Express Entry:
- CLB 9+ for competitive profile
- CLB 7 minimum for many streams

### Education Assessment
- Required for foreign education
- WES (World Education Services) most common
- Takes 2-4 months
- Costs ~$200-300

---

## Processing Times (Current Estimates)

| Stream | Time |
|--------|------|
| Express Entry (after ITA) | 6 months |
| BC PNP (nomination) | 2-4 months |
| Work permit (LMIA) | 3-6 months |
| Work permit (IEC) | 2-8 weeks |
| Study permit | 2-4 months |
| PGWP | 1-3 months |

**Check current times**: canada.ca/immigration

---

## Costs

### Application Fees
| Item | Cost (CAD) |
|------|------------|
| Express Entry (PR application) | $1,365/person |
| BC PNP application | $1,475 |
| Work permit | $155 |
| Study permit | $150 |
| Biometrics | $85 |
| Medical exam | $200-400 |
| Language test | $300-350 |
| Education assessment | $200-300 |

### Settlement Funds (Single Applicant)
Must show ~$14,000 CAD (not required if working in Canada)

---

## After PR

### What PR Gets You
- Live and work anywhere in Canada
- Access to healthcare (MSP in BC)
- Most social benefits
- Path to citizenship

### What PR Doesn't Get
- Vote in elections
- Some government jobs
- Canadian passport

### Citizenship
- After 3 years as PR (1,095 days in 5 years)
- Language and knowledge test
- No residency requirement after citizenship
- Can hold dual citizenship

---

## Common Strategies

### Already in Canada on Work Permit
1. Apply to BC PNP while working
2. Get nomination → apply Express Entry
3. Continue working on permit while PR processes

### Outside Canada, Tech Background
1. Apply to BC Tech Pilot jobs
2. Get offer → employer supports work permit
3. Arrive on work permit
4. Apply BC PNP → PR

### Young Professional (Under 35)
1. IEC Working Holiday visa
2. Work in Canada, gain experience
3. Apply CEC or BC PNP

### International Student
1. Study 2+ years
2. PGWP
3. Work 1+ year
4. CEC or BC PNP

---

## Resources

### Official
- **IRCC**: canada.ca/immigration
- **BC PNP**: welcomebc.ca
- **Processing times**: canada.ca/immigration-processing-times

### Tools
- **CRS Calculator**: ircc.canada.ca/english/immigrate/skilled/crs-tool.asp
- **Come to Canada**: Eligibility assessment tool

### Legal Help
- Use regulated consultants (RCIC) or lawyers
- Check registration: college-ic.ca
- Avoid scams and unregistered consultants

---

## Red Flags & Scams

### Avoid
- Anyone guaranteeing PR
- "Fast track" for money
- Unregistered consultants
- Job offers requiring large payments

### Verify
- Check RCIC registration
- Use official IRCC website only
- Real employers don't ask for money
