# Vancouver Healthcare Guide

## MSP (Medical Services Plan)

### What It Is
BC's universal healthcare coverage, funded by taxes.

### Who's Eligible
- Canadian citizens/PRs resident in BC
- Most work permit holders
- Study permit holders (varies)
- Visitors: NOT eligible

### What's Covered
- Doctor visits (family physician, walk-in)
- Hospital care (emergency, surgery, stays)
- Diagnostic tests (blood work, X-rays, MRI)
- Specialist referrals
- Maternity care

### What's NOT Covered
- Dental care
- Vision (beyond medical conditions)
- Prescription drugs (PharmaCare helps some)
- Physiotherapy
- Massage therapy
- Chiropractor
- Psychology/counseling (limited)
- Cosmetic procedures
- Ambulance ($80 fee)

### Cost
**Free** as of January 2020 (previously ~$75/month)

### Enrollment
1. Apply within 3 months of arriving
2. 3-month wait period for new residents
3. Apply at: gov.bc.ca/msp
4. Receive BC Services Card (ID + health card)

### Wait Period Coverage
Get private insurance for the 3-month wait period.

---

## Finding a Doctor

### Family Doctor (GP)

**The Challenge**: Major shortage in BC. Many doctors not accepting new patients.

**How to Find**:
1. **Health Connect Registry**: healthlinkbc.ca/health-connect-registry
2. **Walk-in clinic**: Ask if accepting patients
3. **Word of mouth**: Ask colleagues, friends
4. **Pathways Medical Care**: pathwaysmedicalcare.ca

**Reality**: May take months. Some areas worse than others.

### Walk-In Clinics

For immediate non-emergency needs:
- Available throughout city
- Long waits common (1-3 hours)
- Good for minor issues
- Find clinics: medimap.ca (shows wait times)

### Specialists

Accessed via referral from GP:
- Dermatology: Long waits (months)
- Psychiatry: Very long waits
- Orthopedics: Varies
- Depends on urgency

---

## Emergency Care

### When to Go to ER
- Life-threatening situations
- Severe injuries
- Chest pain, stroke symptoms
- Severe allergic reactions
- Mental health crisis

### Emergency Rooms
| Hospital | Location | Notes |
|----------|----------|-------|
| Vancouver General | Fairview | Largest, trauma center |
| St. Paul's | West End | Central |
| BC Children's | Fairview | Under 17 only |
| Lions Gate | North Van | North Shore |
| Royal Columbian | New West | Major hospital |

### ER Wait Times
- Life-threatening: Immediate
- Urgent: 1-2 hours
- Less urgent: 4-8+ hours
- Non-emergencies: May wait very long

**Tip**: Use Urgent Care for non-life-threatening urgent issues (faster).

### Urgent Care
- For urgent but not emergency issues
- Shorter waits than ER
- Some locations in metro area

---

## Mental Health

### Public System
- Covered by MSP (limited)
- Long waits for psychiatrists
- Crisis lines available
- Hospital psychiatric care

### Crisis Resources
| Service | Contact |
|---------|---------|
| BC Crisis Line | 1-800-784-2433 |
| Vancouver Crisis Line | 604-872-3311 |
| 911 | Emergency |
| Crisis Text Line | Text HOME to 686868 |

### Private Counseling
- Psychologists: $150-250/session
- Registered Clinical Counselors: $100-180/session
- Often covered by extended health benefits

### Finding Help
- Psychology Today directory
- BC Association of Clinical Counsellors
- Employee Assistance Programs (through work)

---

## Dental Care

### Not Covered by MSP

Must pay out of pocket or through insurance.

### Costs (Approximate)
| Service | Cost |
|---------|------|
| Exam + cleaning | $200-350 |
| Filling | $150-400 |
| Crown | $1,000-1,500 |
| Root canal | $800-1,500 |
| Extraction | $150-400 |

### Finding Dentists
- Many throughout city
- UBC dental school (cheaper, students supervised)
- Community health centers (low income)

---

## Vision Care

### Basic Not Covered

MSP covers:
- Medically necessary eye exams (conditions)
- Emergency eye care

Not covered:
- Routine eye exams
- Glasses
- Contact lenses

### Costs
- Eye exam: $100-150
- Glasses: $150-500+
- Contacts: Variable

### Options
- Optometrists throughout city
- Costco Optical (good value)
- Online glasses (Clearly, Warby Parker)

---

## Prescriptions & Pharmacy

### PharmaCare
BC's drug coverage program:
- Based on income (Fair PharmaCare)
- Register with PharmaCare to reduce costs
- Covers portion after deductible

### Pharmacies
| Chain | Notes |
|-------|-------|
| Shoppers Drug Mart | Most locations |
| London Drugs | BC chain |
| Save-On-Foods | Grocery + pharmacy |
| Costco | Cheapest, membership required |

### Saving Money
- Generic drugs (ask pharmacist)
- Compare pharmacy prices
- PharmaCare registration
- Extended health insurance

---

## Extended Health Insurance

### Through Employer
Most full-time jobs include:
- Dental coverage
- Vision coverage
- Prescription drug coverage
- Paramedical (massage, physio)
- Travel insurance

### Private Plans
If not through work:
- Pacific Blue Cross
- Manulife
- Sun Life
- Great-West Life

### Costs
- Individual: $100-300/month
- Family: $300-600/month
- Depends on coverage level

---

## Maternal/Newborn Care

### Pregnancy
- Covered by MSP
- Prenatal care through GP or midwife
- Hospital delivery covered
- Choose hospital or home birth

### Midwifery
- Growing option
- Covered by MSP
- More personal care
- Home birth support if wanted

### Pediatrics
- BC Children's Hospital (major)
- Pediatricians throughout city
- Well-baby checkups covered

---

## Health Resources

### Information
- **HealthLink BC (811)**: Nurse advice line, 24/7
- **healthlinkbc.ca**: Health information
- **MyHealthPortal**: Access health records

### Apps
- Medeo: Virtual care
- Babylon: Telehealth
- MyHealthPortal: Records

### Virtual Care
- Telehealth expanding
- Covered by MSP
- Good for minor issues
- Maple, Babylon, Telus Health

---

## For Newcomers

### First Steps
1. Apply for MSP immediately
2. Get travel/health insurance for 3-month wait
3. Register with BC Services
4. Start looking for family doctor
5. Locate nearby walk-in clinic

### What to Bring
- Vaccination records
- Medical history
- Prescriptions (with generic names)
- Eye prescription
- Dental records

### Common Questions

**Can I use my home country insurance?**
Usually not directly. May reimburse later.

**What if I get sick during wait period?**
Private insurance or pay out of pocket.

**How long to find a family doctor?**
Weeks to months. Use walk-in clinics meanwhile.

---

## Emergency Preparedness

### What to Have Ready
- List of medications
- Allergies noted
- Emergency contact
- Health card (BC Services Card)
- Extended health info

### In Emergency
1. Call 911
2. Go to nearest ER if able
3. Bring health card and medication list
