# Practical Food Guide: Dietary, Alcohol, Cannabis

## Dietary Accommodations

### Vegetarian/Vegan
Vancouver is one of North America's most veg-friendly cities.

**Dedicated Vegetarian/Vegan:**
| Restaurant | Area | Style | Notes |
|------------|------|-------|-------|
| The Naam | Kitsilano | Casual, 24hr | Institution since 1968 |
| Heirloom | South Granville | Upscale | Elegant plant-based |
| MeeT | Multiple | Casual | Comfort food, burgers |
| Chickpea | Downtown | Mediterranean | Fast-casual |
| Virtuous Pie | Multiple | Pizza | Vegan pizza done right |
| Chau Veggie Express | East Van | Vietnamese | All vegan Vietnamese |

**Good Options at Regular Restaurants:**
- Most Vancouver restaurants have veg options
- Asian restaurants especially accommodating
- Ask about fish sauce/oyster sauce in Asian dishes
- "Plant-based" increasingly common on menus

**Grocery:**
- Whole Foods (3 locations)
- Choices Markets (local chain, health focus)
- Famous Foods (extensive vegan section)
- Donald's Market (natural foods)

### Gluten-Free
Generally well accommodated:
- Most restaurants aware and can modify
- Dedicated GF bakeries exist
- Asian rice-based dishes naturally GF
- Always confirm—cross-contamination varies

**Dedicated GF Options:**
- Edible Flours Bakery (dedicated GF)
- The Gluten Free Epicurean (bakery, café)
- Many bakeries offer GF items (not dedicated facility)

### Halal
Growing options, especially in Surrey and East Van:
- Afghan restaurants typically halal
- Middle Eastern restaurants often halal
- Some Indian restaurants halal (ask)
- Halal butchers in Surrey, East Van

**Finding Halal:**
- Zabihah.com for listings
- Ask specifically—"Muslim-friendly" doesn't always mean halal

### Kosher
Limited strict kosher:
- Omnitsky Kosher Deli (primary option)
- Some bakeries with kosher items
- Superstore/Save-On have kosher sections
- Chabad has resources for visitors

### Allergies
- Allergy awareness generally high
- Major allergens usually listed
- Staff typically knowledgeable
- Asian cuisines: watch for soy, sesame, peanut
- Always communicate severity

---

## Alcohol Guide

### Legal Framework
- **Legal age**: 19 in BC
- **Where to buy**: Government stores (BC Liquor) or licensed private stores
- **Hours**: Varies, typically 9am-11pm
- **No corner store beer**: Unlike some provinces
- **Bar closing**: 1am-3am depending on license

### Where to Buy

**BC Liquor Stores (Government):**
- Largest selection
- Consistent pricing
- Some cold beer
- Locations throughout city

**Private Liquor Stores:**
- More locations, convenient
- Slightly higher prices often
- More variable selection
- Cold beer more available

**Brewery Direct:**
- Growler fills
- Limited releases
- Often best value

### Craft Beer Scene

Vancouver is a craft beer city. Notable breweries:

**Mount Pleasant/Main Street:**
| Brewery | Style | Notes |
|---------|-------|-------|
| Brassneck | Varied, innovative | Best taproom atmosphere |
| 33 Acres | Minimal, clean | Design-forward, simple beers |
| Main Street Brewing | Accessible | Good starter |
| Faculty Brewing | Experimental | Wine-beer crossovers |
| R&B Brewing | Various | Solid, reliable |

**East Van:**
| Brewery | Style | Notes |
|---------|-------|-------|
| Strange Fellows | Belgian-inspired | Complex, interesting |
| Storm Brewing | Eccentric | Weird and wonderful |
| Parallel 49 | Various | Big, accessible |
| Dageraad | Belgian | Excellent Belgian styles |

**North Van:**
| Brewery | Style | Notes |
|---------|-------|-------|
| Deep Cove Brewers | Various | Nice location |
| Beere Brewing | Various | Small batch |

**Port Moody (Brewers Row):**
Four breweries within walking distance:
- Yellow Dog
- Twin Sails
- Parkside
- Moody Ales

**Craft Beer Bars:**
- Alibi Room (Gastown): 50+ taps, legendary
- St Augustine's (Commercial): 60+ taps
- Tap & Barrel (multiple): Views + taps

### Wine

**BC Wine:**
- Okanagan Valley: 4 hours east, excellent wines
- Vancouver Island: Small production
- Styles: Pinot Noir, Chardonnay, Riesling, ice wine

**Wine Bars:**
- Grapes & Soda (Commercial Drive): Natural wines
- Wildebeest (Gastown): BC-focused
- Les Faux Bourgeois (Main): French bistro
- Uva Wine & Cocktail Bar (Downtown)

**Buying BC Wine:**
- BC Liquor Stores: Full selection
- VQA stores: BC wines only
- Winery direct: Can ship

### Cocktails

Vancouver has a strong cocktail scene:

**Top Cocktail Bars:**
| Bar | Area | Vibe |
|-----|------|------|
| Keefer Bar | Chinatown | Apothecary, innovative |
| Pourhouse | Gastown | Classic, prohibition |
| The Diamond | Gastown | Upstairs hidden, elegant |
| Grapes & Soda | Commercial | Wine + cocktails |
| Long Table Distillery | Yaletown | Gin-focused |

---

## Cannabis Guide

### Legal Framework
- **Legal for**: 19+ (same as alcohol in BC)
- **Where to buy**: BC Cannabis stores (government) or licensed private
- **Where to consume**: Private property only
- **Carrying limit**: 30g in public

### Where to Buy

**BC Cannabis Stores (Government):**
- Regulated selection
- Consistent quality
- Staff trained
- Several locations

**Private Stores:**
- More locations
- Variable pricing
- Often more selection
- Look for licensed stores (illegal ones still exist)

### Consumption Rules
- **Can**: Private property, designated areas
- **Cannot**: Public spaces, parks, beaches, near schools
- **Cannot**: In cars (even as passenger)
- **Cannot**: Within 6m of doorways, windows, air intakes

### Edibles & Products
- Edibles limited to 10mg THC per package (regulated)
- Beverages, gummies, chocolates available
- Oils, capsules for non-smokers
- Vape products available

### Tourists
- Can purchase legally
- Cannot cross border (Canada-US) with any cannabis
- Hotels may prohibit in rooms (check policy)
- Airbnbs vary (check listing)

---

## Tipping & Payment

### Tipping Standards (Detailed)

| Service | Standard | Notes |
|---------|----------|-------|
| Restaurant (sit-down) | 18-20% | Pre-tax technically correct |
| Bar (drinks) | $1-2/drink or 18-20% | $1/beer, $2/cocktail common |
| Counter service | 10-15% optional | Coffee: $1 or skip |
| Takeout | 0-10% | Optional, appreciated |
| Delivery | 15-18% | Plus app fees |
| Buffet | 10-15% | Depends on service level |
| Food truck | Optional tip jar | $1-2 appreciated |

### Payment Realities
- **Cards**: Tap/contactless universal
- **Cash**: Rarely needed
- **Amex**: Less accepted than Visa/MC
- **Tip screens**: Often suggest 18/20/22%—don't feel pressured to highest

### Group Dining
- Many restaurants add 18% gratuity for 6+
- Check bill before adding more
- Splitting bills usually accommodated
- Apps like Splitwise help groups

---

## Food Delivery

### Apps
- **DoorDash**: Largest selection
- **Uber Eats**: Good coverage
- **Skip the Dishes**: Canadian alternative
- **Fantuan**: Chinese restaurants

### Reality Check
- Fees add up: Delivery + service fee + tip = 30-40% premium
- Quality degrades in transit
- Some restaurants do their own delivery
- Pickup often 30-50% cheaper than delivery

---

## Grocery Stores

### Major Chains
| Store | Vibe | Price | Notes |
|-------|------|-------|-------|
| Save-On-Foods | Standard | $$ | BC chain, good selection |
| Superstore | Big box | $ | Cheapest mainstream |
| Safeway | Standard | $$ | Decent, convenient |
| IGA | Neighborhood | $$ | Smaller, local |
| Whole Foods | Premium | $$$ | Organic, specialty |
| Choices | Health focus | $$$ | Local, natural |

### Asian Groceries
- **T&T Supermarket**: Large Asian chain, excellent
- **H-Mart**: Korean focus
- **Kim's Mart**: Japanese focus
- **Various in Richmond**: Specialized

### Budget Tips
- No Frills: Discount Superstore brand
- Costco: Bulk, membership required
- Walmart Supercentre: Lowest prices
- Farmers markets: Seasonal value
