# Vancouver Food Scene Overview

## What Makes Vancouver Special

### Asian Food Capital
Vancouver has arguably the best Asian food in North America outside Asia itself:
- **Chinese**: Cantonese (dim sum), Sichuan, Northern, Hong Kong-style
- **Japanese**: Sushi rivals coastal Japan cities, excellent ramen
- **Korean**: BBQ, fried chicken, budae jjigae
- **Vietnamese**: Pho, banh mi, rice plates
- **Indian**: Concentrated in Surrey, excellent everywhere

### Pacific Northwest Influence
- **Seafood**: Salmon, halibut, spot prawns, Dungeness crab
- **Farm-to-table**: Strong local sourcing culture
- **West Coast fusion**: Asian techniques + local ingredients
- **Sustainability focus**: Ocean Wise certification matters here

### Multi-Cultural Depth
Beyond Asian and local:
- Greek (particularly on Broadway)
- Middle Eastern (across East Van)
- Italian (Commercial Drive heritage)
- Mexican (growing scene)
- Ethiopian (Commercial Drive)

---

## Price Guide (Feb 2026)

### Budget ($)
| Meal Type | Range | Examples |
|-----------|-------|----------|
| Pho/noodles | $12-18 | Pho Goodness, Phnom Penh |
| Banh mi | $6-10 | Banh Mi Saigon, Tay Do |
| Dim sum (lunch) | $15-25/person | Many in Richmond |
| Food court | $10-18 | Crystal Mall, Aberdeen |
| Fast casual | $15-22 | Tacofino, Nook |

### Mid-Range ($$)
| Meal Type | Range | Examples |
|-----------|-------|----------|
| Casual dinner | $25-45/person | Savio Volpe, Kissa Tanto |
| Sushi dinner | $40-80/person | Miku, Minami |
| Brunch | $20-35/person | Medina, Jam Cafe |
| Pizza | $20-30/pizza | Via Tevere, Pizzeria Farina |

### Upscale ($$$)
| Meal Type | Range | Examples |
|-----------|-------|----------|
| Fine dining | $100-200/person | Hawksworth, Boulevard |
| Omakase | $150-300/person | Tojo's, Masayoshi |
| Tasting menu | $150-250/person | Burdock & Co, AnnaLena |

### Splurge ($$$$)
| Meal Type | Range | Examples |
|-----------|-------|----------|
| Special occasion | $200-400/person | St. Lawrence, Botanist |
| Top omakase | $300-500/person | Sushi Bar Maumi |

---

## Tipping Culture

**Standard expectations:**
- **Restaurants**: 18-20% (pre-tax technically, post-tax common)
- **Counter service**: Optional, $1-2 or 15%
- **Bars**: $1-2/drink or 18-20%
- **Takeout**: Not expected, 10% appreciated

**Payment reality:**
- Machines suggest 18/20/22%
- Staff see your selection
- Not tipping is noticed and remembered
- Service charge sometimes included for large groups (check bill)

---

## Reservation Strategy

### Always Book Ahead
- **Vij's**: No reservations, but line forms early
- **Miku/Minami**: Book 1-2 weeks ahead for weekend
- **Hawksworth/Boulevard**: Book 2-3 weeks for weekend
- **Tojo's**: Book 1-2 weeks minimum
- **Popular brunch spots**: Arrive early or book if possible

### Walk-In Friendly
- Most casual restaurants
- Early dinner (5-6pm)
- Bar seating often available
- Weeknights easier

### Platforms
- **OpenTable**: Most restaurants
- **Resy**: Some higher-end
- **Direct**: Many prefer calls/website

---

## By Neighborhood

### Downtown/Yaletown
**Vibe:** Upscale, business dining, date night
**Best for:** Fine dining, cocktails, impressing
- Blue Water Cafe (seafood)
- Miku (sushi)
- Glowbal (upscale casual)
- Chambar (Belgian-Moroccan)

### Gastown
**Vibe:** Trendy, cocktail bars, character buildings
**Best for:** Evening out, drinks + dinner
- L'Abattoir (French)
- Bao Bei (Chinese brasserie)
- Tacofino (tacos)
- Pourhouse (cocktails)
- Alibi Room (craft beer)

### Mount Pleasant/Main Street
**Vibe:** Creative, brewery scene, locals
**Best for:** Casual excellence, beer
- Savio Volpe (Italian)
- Anh and Chi (Vietnamese)
- Brassneck (brewery)
- 33 Acres (brewery)

### Commercial Drive
**Vibe:** Bohemian, multicultural, coffee
**Best for:** Coffee, casual, ethnic
- Via Tevere (pizza)
- Havana (Cuban)
- Ethiopian (multiple)
- Prado (coffee)

### Kitsilano
**Vibe:** Beach casual, healthy, brunch
**Best for:** Brunch, health-conscious
- AnnaLena (contemporary)
- Sophie's Cosmic Cafe (brunch)
- Maenam (Thai)
- Naam (vegetarian, 24hr)

### Chinatown
**Vibe:** Historic, evolving, authentic + new
**Best for:** Chinese, late night
- Bao Bei (modern Chinese)
- Kissa Tanto (Japanese-Italian)
- Phnom Penh (Cambodian-Vietnamese)

### Richmond
**Vibe:** Authentic Asian, food courts, dim sum
**Best for:** Chinese, Japanese, Korean, value
- Dynasty (dim sum)
- Guu Izakaya
- Crystal Mall food court
- Aberdeen Centre food court

---

## Vancouver Food Institutions

### Must-Try (Tourist + Local Approved)
| Restaurant | Why | Price |
|------------|-----|-------|
| **Vij's** | Indian fine dining, no reservations, line worth it | $$$ |
| **Tojo's** | Omakase pioneer, invented California roll | $$$$ |
| **Medina** | Brunch, Belgian waffles, legendary | $$ |
| **Miku** | Aburi (flame-seared) sushi | $$$ |
| **Japadog** | Japanese-fusion hot dogs, street food icon | $ |

### Local Favorites (Less Touristy)
| Restaurant | Why | Price |
|------------|-----|-------|
| **Savio Volpe** | Perfect Italian, neighborhood gem | $$ |
| **Burdock & Co** | Farm-to-table excellence | $$$ |
| **Sun Sui Wah** | Cantonese, locals' dim sum choice | $$ |
| **Phnom Penh** | Cambodian-Vietnamese, butter beef legend | $ |
| **Via Tevere** | Naples-certified pizza | $$ |

---

## Dietary Considerations

### Vegetarian/Vegan
Vancouver is very veg-friendly:
- **The Naam**: 24-hour vegetarian institution
- **Heirloom**: Upscale vegetarian
- **Meet/MeeT**: Casual plant-based, burgers
- **Virtuous Pie**: Vegan pizza
- Most restaurants have veg options

### Gluten-Free
- Generally well-accommodated
- Ask servers (awareness is high)
- Some dedicated GF bakeries
- Asian rice-based dishes naturally GF

### Halal
- Growing options
- Afghan, Middle Eastern restaurants typically halal
- Some Indian restaurants halal
- Ask specifically

### Kosher
- Limited strict kosher
- Omnitsky's (deli)
- Some bakeries

---

## Food Events & Markets

### Farmers Markets
- **Trout Lake**: Saturdays, largest
- **Kitsilano**: Sundays
- **Main Street Station**: Wednesdays
- **Winter markets**: Indoor locations

### Food Festivals
- **Eat Vancouver**: Restaurant promotions (various times)
- **Richmond Night Market**: Summer weekends
- **Spot Prawn Festival**: May
- **Greek Day**: June (on Broadway)
- **Italian Day**: June (Commercial Drive)

### Night Markets
- **Richmond Night Market**: Asia-style, summer weekends
- **Shipyards Night Market**: North Van, Fridays
