# Local & Farm-to-Table Vancouver

## Pacific Northwest Cuisine

### The Philosophy
Vancouver's local food scene emphasizes:
- **Seasonal**: Menus change with BC harvests
- **Ocean Wise**: Sustainable seafood certification
- **Farm partnerships**: Direct relationships with Fraser Valley farms
- **Foraging**: Wild ingredients (mushrooms, berries, plants)
- **Indigenous influence**: Growing presence of First Nations cuisine

### Defining Local Ingredients

**Seafood (by season):**
| Item | Peak Season | Notes |
|------|-------------|-------|
| Spot prawns | May-June | 6-week window, don't miss |
| Salmon (various) | July-October | Sockeye, coho, chinook |
| Dungeness crab | Year-round, peak winter | BC classic |
| Halibut | March-November | Local hero |
| Oysters | Year-round | BC coast varieties |
| Sablefish (black cod) | Year-round | Rich, buttery |

**Land (by season):**
| Item | Peak Season | Notes |
|------|-------------|-------|
| Morels | April-June | Foraged, expensive |
| Asparagus | April-June | Fraser Valley |
| Cherries | June-August | Okanagan |
| Berries | June-September | Blueberries, blackberries |
| Corn | August-September | Chilliwack |
| Squash | September-November | Fraser Valley |
| Root vegetables | Fall-Winter | Carrots, beets, parsnips |

---

## Top Farm-to-Table Restaurants

### Fine Dining ($$$-$$$$)

**Burdock & Co**
- **Location**: Main Street
- **Style**: Vegetable-forward, seasonal tasting menus
- **Known for**: Pickled everything, fermentation, local wine pairings
- **Book ahead**: 1-2 weeks

**AnnaLena**
- **Location**: Kitsilano
- **Style**: Contemporary Canadian, creative presentations
- **Known for**: Surprising flavor combinations, excellent desserts
- **Book ahead**: 1 week

**Farmer's Apprentice**
- **Location**: South Granville
- **Style**: Prix fixe only, no menu (trust the chef)
- **Known for**: No-choice tasting menu, wine pairings
- **Book ahead**: 1-2 weeks

**St. Lawrence**
- **Location**: Railtown (near Gastown)
- **Style**: Quebec-inspired, French-Canadian
- **Known for**: Tourtière, poutine, nose-to-tail
- **Book ahead**: 2 weeks

**Botanist**
- **Location**: Fairmont Pacific Rim
- **Style**: Pacific Northwest luxury
- **Known for**: Garden-inspired, cocktail program, views
- **Book ahead**: 1-2 weeks for weekend

### Upscale Casual ($$-$$$)

**Fable Kitchen**
- **Location**: Kitsilano
- **Style**: Farm-to-table, convivial
- **Known for**: Whole animal butchery, vegetable creativity
- **Book ahead**: Recommended weekend

**Published on Main**
- **Location**: Mount Pleasant
- **Style**: Seasonal, neighborhood
- **Known for**: Welcoming, consistent, local sourcing
- **Walk-in**: Usually possible weeknights

**Harvest Community Foods**
- **Location**: Hastings-Sunrise
- **Style**: Neighborhood, comfort
- **Known for**: Unpretentious, local focus, great value

**Forage**
- **Location**: Listel Hotel, West End
- **Style**: 100% BC ingredients
- **Known for**: Commitment to local, good brunch

---

## Seafood Specialists

### Raw Bars & Seafood Houses

**Blue Water Cafe**
- **Location**: Yaletown
- **Price**: $$$
- **Known for**: Raw bar, Ocean Wise commitment, sablefish
- **Book ahead**: 1-2 weeks weekend

**Boulevard Kitchen & Oyster Bar**
- **Location**: Sutton Place Hotel
- **Price**: $$$
- **Known for**: Oysters, seafood tower, elegant space
- **Book ahead**: 1 week

**Rodney's Oyster House**
- **Location**: Yaletown
- **Price**: $$
- **Known for**: East coast institution expanded west, casual vibe
- **Walk-in**: Usually possible at bar

**Joe Fortes**
- **Location**: Downtown
- **Price**: $$$
- **Known for**: Classic steakhouse vibe, rooftop patio, raw bar
- **Book ahead**: Recommended

### Casual Seafood

**Go Fish**
- **Location**: Fisherman's Wharf (Granville Island area)
- **Price**: $
- **Known for**: Fish & chips, fish tacos, outdoor seating
- **Note**: Cash only, outdoor only, weather dependent

**The Fish Counter**
- **Location**: Main Street
- **Price**: $
- **Known for**: Fish & chips, sustainable sourcing, casual

**The Lobster Man**
- **Location**: Granville Island
- **Price**: $$
- **Known for**: Fresh seafood market + prepared foods

---

## Spot Prawn Season (May-June)

The most anticipated 6 weeks in Vancouver food calendar.

### What Are Spot Prawns?
- BC's largest shrimp species
- Sweet, delicate, incomparable fresh
- Must be alive when purchased (or heads removed immediately)
- Traditional Indigenous harvest

### Where to Get Them

**Direct from boats:**
- **Fisherman's Wharf** (False Creek): Boats sell direct
- Arrive early (8-9am opening days)
- Bring cooler, cash
- Expect lines

**Markets:**
- Granville Island Market
- Various fish shops
- Whole Foods (less fresh, higher price)

**Restaurants (seasonal menus):**
- Blue Water Cafe
- Boulevard
- Many restaurants feature them

### How to Eat
- **Best**: Steamed or grilled simply, lemon, salt
- **Also good**: Sashimi (extremely fresh only)
- **Don't**: Overcook, over-sauce
- **Head butter**: Suck the heads for the good stuff

---

## Indigenous Cuisine

Growing presence of First Nations ingredients and techniques.

### Restaurants

**Salmon n' Bannock**
- **Location**: Broadway
- **Style**: Only Indigenous-owned restaurant in Vancouver
- **Known for**: Wild salmon, game meats, bannock, Indigenous ingredients
- **Must try**: Bannock, bison, wild rice

**Kekuli Cafe** (Indigenous-owned chain)
- **Location**: Multiple
- **Style**: Casual, bannock-focused
- **Known for**: Bannock burgers, breakfast

### Indigenous Ingredients
- **Salmon**: Smoked, candied, traditional preparations
- **Bannock**: Fried bread, Indigenous staple
- **Wild game**: Bison, venison, elk
- **Berries**: Saskatoon, huckleberry, salal
- **Sea vegetables**: Seaweed, kelp
- **Wild rice**: Traditional harvest

### Markets & Events
- **Squamish Lil'wat Cultural Centre** (Whistler): Restaurant
- **Museum of Anthropology**: Occasional food events
- **Farmers markets**: Some Indigenous vendors

---

## Craft Beverages

### Local Wine
BC wine is increasingly excellent:
- **Okanagan Valley**: 4 hours east, wine country
- **Gulf Islands**: Small production, unique
- **Styles**: Pinot Noir, Chardonnay, Riesling, ice wine

**Wine bars featuring BC:**
- **Grapes & Soda**: Commercial Drive
- **Wildebeest**: Gastown
- **Burdock & Co**: Excellent BC list

### Craft Beer
See `food-practical.md` for full brewery guide.

### Craft Spirits
- **Long Table Distillery**: Yaletown, gin focus
- **Odd Society**: East Van, creative
- **Sons of Vancouver**: North Van
- **Deep Cove Brewers & Distillers**: North Van

### Coffee
Vancouver's third-wave coffee scene:
- **49th Parallel**: Local roaster, multiple locations
- **Matchstick**: East Van, excellent
- **Revolver**: Gastown, rotating roasters
- **Pallet**: Downtown, high-end
- **Elysian**: Multiple, consistent
