# Vancouver Education Guide

## K-12 Education

### Public Schools
- Free for residents
- Operated by school districts
- Generally good quality
- French Immersion programs available

### School Districts
| District | Areas |
|----------|-------|
| Vancouver (39) | City of Vancouver |
| Burnaby (41) | Burnaby |
| North Vancouver (44) | North Van |
| West Vancouver (45) | West Van |
| Richmond (38) | Richmond |
| Surrey (36) | Surrey |

### Enrollment
- Register with local school district
- Based on catchment area (where you live)
- Proof of residence required
- Some schools have waitlists

### School Quality
- Generally good across Vancouver
- Some schools more sought-after
- West Vancouver consistently ranked high
- North Van strong
- Check Fraser Institute rankings (controversial but used)

---

## Private Schools

### Why Private
- Smaller classes
- Specific philosophy (religious, educational)
- More extracurriculars
- Perceived prestige

### Costs
- $5,000-40,000/year
- University prep schools highest
- Religious schools often lower

### Notable Private Schools
| School | Type | Fees |
|--------|------|------|
| St. George's | Boys, university prep | $30K+ |
| York House | Girls, university prep | $30K+ |
| Crofton House | Girls | $25K+ |
| West Point Grey | Co-ed | $20K+ |
| Collingwood | Co-ed | $25K+ |

---

## French Immersion

### What It Is
Public school program taught primarily in French.

### Benefits
- Bilingual education
- Free (public school)
- Strong academic outcomes
- Federal government jobs later

### Availability
- Most school districts offer
- Apply early (limited spots)
- Late French Immersion option (Grade 6 start)

### Considerations
- Homework harder to help with
- Limited spots in popular areas
- Transition can be challenging

---

## Post-Secondary

### Universities

**University of British Columbia (UBC)**
- Canada's #2-3 ranked university
- Beautiful campus (Point Grey)
- Strong in: Sciences, engineering, commerce, law
- Competitive admission
- Domestic tuition: ~$6,000/year
- International: ~$45,000/year

**Simon Fraser University (SFU)**
- Strong university
- Burnaby Mountain campus
- Tri-semester system
- Good for: Business, computing, communications
- More accessible admission than UBC

**Emily Carr University of Art + Design**
- Art and design focused
- Downtown + Great Northern Way
- Animation, design, fine arts

**BCIT (British Columbia Institute of Technology)**
- Polytechnic (applied education)
- Industry-connected
- Engineering technology, health, business
- High employment rates

**Capilano University**
- North Vancouver
- Smaller, more personal
- Film, education, tourism

### International Students
- Study permit required
- PGWP after graduation (PR pathway)
- Higher tuition (3-5x domestic)
- Can work 20 hours/week during school

---

## College & Vocational

### Community Colleges
| College | Strengths |
|---------|-----------|
| Langara | University transfer, general |
| Douglas | University transfer, nursing |
| Vancouver Community College | Trades, ESL, practical |
| Kwantlen Polytechnic | Practical degrees |

### Trades Training
- BCIT (best known)
- ITA BC (Industry Training Authority)
- Apprenticeship programs
- Trades in demand (electrician, plumber, etc.)

---

## Language Schools

### ESL Programs
- Extensive options in Vancouver
- International students from worldwide
- VCC, Langara have programs
- Many private language schools

### Quality Varies
- Languages Canada certified schools better
- Check reviews carefully
- Beware of diploma mills

### French
- Alliance Française
- SFU French programs
- Community center programs

---

## Continuing Education

### Professional Development
- BCIT continuing education
- SFU Beedie (business)
- UBC Extended Learning
- Various professional associations

### Bootcamps
| Program | Focus |
|---------|-------|
| Lighthouse Labs | Web development |
| BrainStation | Tech, design |
| General Assembly | Various tech |

### Online Learning
- Coursera, edX, Udemy
- LinkedIn Learning (free at library)
- University online programs

---

## Childcare

### Types
| Type | Ages | Cost/Month |
|------|------|------------|
| Infant care | 0-18mo | $1,500-2,200 |
| Toddler | 18mo-3yr | $1,200-1,800 |
| Preschool | 3-5yr | $1,000-1,500 |
| Before/after school | 5-12yr | $400-800 |

### BC Childcare Affordability
- $10/day childcare rolling out
- Check availability at participating centers
- Reducing costs significantly where available

### Finding Childcare
- Start looking early (waitlists)
- YMCA, YWCA programs
- Private daycares
- Licensed family daycares
- Nannies/nanny shares

---

## Resources for Families

### School Info
- **School District websites**: Enrollment info
- **Fraser Institute rankings**: Controversial but used
- **Ministry of Education**: curriculum.gov.bc.ca

### Childcare
- **CCRR (Child Care Resource & Referral)**: Local agencies
- **ChildCareBC**: Provincial info

### Support
- **Settlement agencies**: Help for newcomer families
- **StrongStart**: Free drop-in early learning
- **Libraries**: Free programs for children
