# Driving & Car Ownership in Vancouver

## Do You Need a Car?

### Car-Free Viable Areas
- Downtown
- West End
- Yaletown
- Mount Pleasant
- Commercial Drive
- Kitsilano (mostly)
- Near SkyTrain stations

### Car Helpful/Needed
- North Vancouver (upper areas)
- West Vancouver
- Surrey (most areas)
- Burnaby (away from SkyTrain)
- Langley, Coquitlam, Maple Ridge

### Decision Factors
| Factor | Car Helps If... |
|--------|-----------------|
| Work | Commute not transit-friendly |
| Kids | Activities, school runs |
| Outdoors | Frequent skiing, hiking |
| Location | Suburb, poor transit |
| Costco | Heavy grocery shopping |

---

## Getting Your License

### Transferring from Another Country
BC has reciprocal agreements with many jurisdictions.

**Full exchange** (no testing):
- US (most states)
- UK, Ireland
- Australia, New Zealand
- Japan, Korea
- Germany, Switzerland, Austria
- And others

**Some testing required**:
- Various countries
- Check ICBC website for your country

**Full testing required**:
- Countries without agreements
- Start from learner's

### The BC License System (Starting Fresh)

**Class 7L (Learner's)**:
- Pass knowledge test
- Must have supervisor (25+ with Class 5)
- No passengers (except supervisor)
- No driving midnight-5am
- 12 months minimum

**Class 7N (Novice)**:
- Pass road test
- 1 passenger max (some exceptions)
- Zero alcohol tolerance
- 24 months minimum

**Class 5 (Full)**:
- Pass second road test
- Full driving privileges

### ICBC Offices
- Book appointments online (often weeks wait)
- Bring: ID, residence proof, current license if exchanging
- Fees: $15-75 depending on process

---

## ICBC Insurance

### The Monopoly
ICBC (Insurance Corporation of BC) has monopoly on basic auto insurance.

### Basic Coverage (Required)
- $200,000 third-party liability
- Accident benefits
- Inverse liability coverage

### Enhanced Coverage (Optional)
- Collision (your car damage)
- Comprehensive (theft, vandalism, etc.)
- Extended liability
- Available from ICBC or private insurers

### Cost Factors
| Factor | Impact |
|--------|--------|
| Driving history | Major (claims-free discount) |
| Years licensed | Significant |
| Vehicle type | Moderate |
| Where you live | Some |
| How much you drive | Some |

### Typical Costs
| Profile | Annual Range |
|---------|--------------|
| New driver, no experience | $4,000-6,000 |
| Experienced, good record | $1,800-2,800 |
| Experienced, claims | $3,000-5,000 |
| High-value car | Add $500-2,000 |

### Saving on Insurance
- Build claims-free years
- Take ICBC discount courses
- Higher deductibles
- Shop optional coverage (private insurers)
- Drive less (low-km discount)

---

## Buying a Car

### New vs Used
| | New | Used |
|-|-----|------|
| Cost | Higher | Lower |
| Depreciation | Steep first 3 years | Already happened |
| Warranty | Full | May be limited |
| Financing | Often better rates | Variable |
| Selection | Order what you want | Take what's available |

### Where to Buy Used
- **Dealers**: Higher price, some protection
- **Private sale**: Lower price, as-is
- **Certified Pre-Owned**: Warranty, inspected
- **Auctions**: For experienced buyers

### Inspection
- Pre-purchase inspection highly recommended
- Any mechanic can do (~$150)
- Check CarFax/CarProof history

### Registration
1. Complete sale/transfer
2. ICBC office
3. Register + insure same visit
4. License plates provided

---

## Driving in Vancouver

### Traffic Reality
- Rush hour congestion significant
- Lions Gate Bridge: Notorious bottleneck
- Tunnel to Richmond: Slow
- Downtown parking: Expensive, scarce

### Peak Hours
- **Morning**: 7:30-9:30am
- **Evening**: 4:00-6:30pm
- **Avoid** bridges/tunnels these times if possible

### Key Routes

**Lions Gate Bridge**
- North Shore to Downtown
- 3 lanes (reversible middle)
- Very congested rush hour
- No real alternative

**Ironworkers Memorial (Second Narrows)**
- North Shore to Burnaby
- Less congested than Lions Gate
- Further east

**George Massey Tunnel**
- Richmond to Delta/Tsawwassen
- Bottleneck, replacement planned
- Ferries to Victoria affected

### Parking

**Downtown:**
| Type | Cost |
|------|------|
| Street meters | $4-6/hour |
| Lots (daily) | $15-30 |
| Monthly | $200-400 |

**Elsewhere:**
- Generally easier
- Free residential parking
- Mall parking usually free

**Apps**: PayByPhone for street parking

---

## Winter Driving

### Requirements
October 1 - March 31, certain highways require:
- M+S tires minimum
- Mountain/snowflake tires recommended
- Chains alternative

### Where Required
- Sea to Sky Highway (to Whistler)
- Coquihalla Highway
- Mountain passes
- Check DriveBC for conditions

### Reality in City
- Snow rare at sea level (5-10 days/year)
- City doesn't handle snow well
- All-seasons usually fine for city
- Winter tires recommended for mountains

---

## Electric Vehicles

### BC Advantage
- Electricity cheap (hydro)
- Gas expensive (~$1.80/L)
- Provincial rebates available
- HOV lane access
- Growing charging network

### Charging
- Home charging (if you have parking)
- Condo charging (increasingly common)
- Public chargers (ChargePoint, FLO, etc.)
- Free charging some locations

### Rebates
| Program | Amount |
|---------|--------|
| BC (CleanBC) | Up to $4,000 |
| Federal (iZEV) | Up to $5,000 |
| Charging rebates | Up to $700 |

### Popular EVs
- Tesla Model 3/Y
- Hyundai Ioniq
- Ford Mustang Mach-E
- VW ID.4
- Chevrolet Bolt

---

## Car Alternatives

### Car Share

**Evo (Free-floating)**
- Pick up anywhere, drop off anywhere (in zone)
- $0.45/min, $17.99/hr, $104.99/day
- Good for: One-way trips, errands

**Modo (Co-op)**
- Station-based (return to same spot)
- Hourly + km rates
- Good for: Planned trips, day use
- Membership + share purchase

### When Car Share Makes Sense
- Drive <10 times/month
- Don't need car daily
- Good transit for commute
- Evo/Modo in your area

### Ride-Hailing
- Uber, Lyft available
- Taxis also available
- Good for: Nights out, airport, occasional

### Bike + Transit
Many Vancouverites combine:
- Bike to SkyTrain
- Transit for distance
- Bike share for last mile
- Car share for special needs

---

## Day Trips by Car

### Popular Drives
| Destination | Time | Notes |
|-------------|------|-------|
| Whistler | 2 hrs | Sea to Sky scenic |
| Squamish | 1 hr | Climbing, hiking |
| Harrison Hot Springs | 1.5 hrs | Hot springs |
| Victoria | 4 hrs (incl ferry) | Capital city |
| Tofino | 5 hrs (incl ferry) | Pacific coast |
| Kelowna | 4 hrs | Wine country |

### Ferry Bookings
- BC Ferries for Victoria/Gulf Islands
- Reserve ahead (especially summer)
- bcferries.com

### Mountain Driving
- Check DriveBC conditions
- Winter tires Oct-Mar
- Be prepared for weather changes
- Gas up before mountain routes
