# Vancouver Culture & Customs

## Cultural Identity

### Multicultural Reality
Vancouver is one of the world's most diverse cities:
- ~50% visible minorities
- ~40% speak non-English language at home
- Largest Chinese population in North America (outside SF)
- Significant South Asian, Filipino, Korean, Japanese communities

### Indigenous Presence
Vancouver is on unceded Coast Salish territories:
- Musqueam, Squamish, Tsleil-Waututh nations
- Land acknowledgments common at events
- Growing Indigenous cultural visibility
- Reconciliation ongoing process

---

## Social Norms

### General Canadian Culture
- **Politeness**: "Sorry" is reflexive
- **Queuing**: Lines are respected
- **Personal space**: Maintain reasonable distance
- **Punctuality**: Generally on time
- **Small talk**: Weather always works

### Vancouver Specifics
- **Casual dress**: Very relaxed (tech/outdoor influence)
- **Outdoors culture**: Hiking/skiing talk is common
- **Environmental consciousness**: Recycling, composting expected
- **Health focus**: Yoga, cycling, organic food prevalent

### What Might Surprise
- People are friendly but friendships form slowly
- "Let's get coffee" may not mean anything
- Directness is less common than in US
- Conflict avoidance is cultural

---

## Diversity & Inclusion

### LGBTQ+
- Very accepting city
- Pride Parade (late July/August) is major event
- Davie Village is historic LGBTQ+ neighborhood
- Same-sex marriage legal since 2005

### Racial Diversity
- Generally accepting
- Racism exists but less overt than some places
- Asian communities very established
- Some tensions around housing/foreign investment

### Accessibility
- Good infrastructure generally
- Transit accessible
- Buildings have standards
- HandyDART for those who need it

---

## Religion

### Demographics
- ~30% no religion (growing)
- ~25% Catholic
- ~15% Protestant
- ~5% Sikh
- ~5% Muslim
- ~3% Buddhist
- Others

### Religious Sites
- Churches throughout city
- Gurdwaras (Sikh temples) especially in Surrey
- Mosques
- Buddhist temples
- Synagogues

### Religious Practice
- Generally private matter
- Christmas is cultural as much as religious
- Most businesses closed Christmas, Easter
- Diwali, Eid, Lunar New Year increasingly recognized

---

## Holidays & Celebrations

### Statutory Holidays
| Holiday | Date |
|---------|------|
| New Year's Day | Jan 1 |
| Family Day | Third Monday Feb |
| Good Friday | Varies |
| Victoria Day | Third Monday May |
| Canada Day | July 1 |
| BC Day | First Monday Aug |
| Labour Day | First Monday Sep |
| Truth & Reconciliation Day | Sep 30 |
| Thanksgiving | Second Monday Oct |
| Remembrance Day | Nov 11 |
| Christmas | Dec 25 |

### Cultural Celebrations
- **Lunar New Year** (Jan/Feb): Major in Richmond, Chinatown
- **Vaisakhi** (April): Sikh celebration, Surrey parade massive
- **Pride** (July/Aug): Downtown parade and celebrations
- **Diwali** (Oct/Nov): Growing recognition
- **Italian Day** (June): Commercial Drive festival
- **Greek Day** (June): Broadway festival

---

## Food Culture

### Dining Norms
- Tipping: 18-20% expected
- Reservations: Recommended for nice restaurants
- Casual dress: Almost everywhere accepts casual
- Sharing plates: Increasingly common

### Food Values
- Local/seasonal emphasized
- Sustainability matters
- Dietary accommodations expected
- Asian food is everyday, not "ethnic"

---

## Work Culture

### General
- Better work-life balance than US
- Less hustle culture than SF/NYC
- Outdoor activities prioritized
- Flexibility increasingly expected

### Meeting Culture
- Start on time
- Agendas helpful
- Less confrontational than US
- Consensus-seeking

### Office Norms
- Casual dress (very casual in tech)
- Coffee culture strong
- Lunch breaks taken
- Friday afternoons often quiet

---

## Dating & Relationships

### Dating Scene
- Apps dominant (Hinge, Bumble, Tinder)
- Coffee dates common
- Outdoor dates popular (hiking, beach)
- Dating scene described as "hard" (people are guarded)

### Relationship Norms
- Common-law recognized (after 2 years in BC)
- Same-sex marriage legal
- Living together before marriage normal
- Average age of marriage increasing

### The "Vancouver Dating Problem"
Common complaints:
- People are polite but not warm
- Hard to make close connections
- Transient population
- Everyone is "busy"

Reality: Takes effort, but deep friendships form with time.

---

## Making Friends

### The Challenge
Vancouver is notoriously hard for making friends:
- People are friendly but busy
- Established social circles
- Weather limits spontaneous gatherings
- Transient population

### What Works
- **Consistency**: Same gym class, same bar, same activity
- **Activities**: Join groups around hobbies
- **Work friends**: Natural starting point
- **Expat communities**: Others in same situation
- **Sports leagues**: Vancouver has many

### Activities for Connection
- Hiking groups
- Running clubs
- Sports leagues (volleyball, soccer)
- Climbing gyms
- Language exchanges
- Board game cafes
- Volunteer organizations

---

## Arts & Entertainment

### Live Music
- Commodore Ballroom (legendary)
- Rogers Arena (major acts)
- Various small venues
- Jazz festival (June)
- Folk festival (July)

### Theatre
- Arts Club Theatre
- Vancouver Playhouse
- Fringe Festival (September)

### Film
- VIFF (Vancouver International Film Festival)
- DOXA Documentary Festival
- Cinematheque

### Sports
| Team | Sport | Venue |
|------|-------|-------|
| Canucks | NHL Hockey | Rogers Arena |
| Whitecaps | MLS Soccer | BC Place |
| BC Lions | CFL Football | BC Place |
| Canadians | Minor League Baseball | Nat Bailey |

---

## Local Quirks

### Very Vancouver
- Complaining about housing prices (bonding activity)
- Wearing hiking gear everywhere
- Owning expensive rain gear
- Skiing on lunch break (some people actually do)
- Cycling year-round
- Yoga obsession
- Coffee snobbery
- Outdoor gear as fashion

### Vancouver vs Toronto
Vancouverites will joke about:
- "Toronto thinks it's the center of Canada"
- "At least we have mountains"
- "Toronto weather is worse"
- (Friendly rivalry)

### Vancouver vs Seattle
- Similar cities, often compared
- "Seattle but with healthcare"
- US comparison without moving to US

---

## Media & Staying Informed

### Local News
- **CBC British Columbia**: National broadcaster
- **Vancouver Sun/Province**: Print papers
- **Daily Hive Vancouver**: Online, local
- **The Tyee**: Independent, BC focus
- **BetaKit**: Tech news

### Reddit
- r/vancouver: Very active, sometimes cranky
- r/britishcolumbia
- Neighborhood-specific subs
