# Vancouver Cost of Living

## The Reality

Vancouver is one of North America's most expensive cities. Housing costs are the primary driver.

### Quick Numbers (Feb 2026)
| Item | Monthly Cost |
|------|--------------|
| 1BR rent (Downtown) | $2,400-3,200 |
| 1BR rent (East Van) | $1,800-2,400 |
| 1BR rent (suburbs) | $1,600-2,200 |
| Groceries (single) | $400-600 |
| Transit pass | $102-178 |
| Phone + Internet | $130-180 |
| Utilities (if not included) | $60-150 |
| Health insurance (if needed) | $0-200 |

---

## Housing Costs

### Rental Market

**Downtown/Central:**
| Type | Range | Notes |
|------|-------|-------|
| Studio | $1,800-2,300 | Rare |
| 1BR | $2,400-3,200 | Standard |
| 2BR | $3,200-4,500 | Scarce |
| 3BR | $4,500+ | Very rare |

**East Vancouver:**
| Type | Range | Notes |
|------|-------|-------|
| Studio | $1,500-1,900 | Limited |
| 1BR | $1,800-2,400 | Better value |
| 2BR | $2,300-3,200 | Available |
| Basement suite | $1,300-1,900 | Best value |

**Suburbs (Burnaby, Richmond, New West):**
| Type | Range | Notes |
|------|-------|-------|
| 1BR | $1,600-2,200 | Varies widely |
| 2BR | $2,100-2,800 | More available |

### Additional Housing Costs
| Item | Cost |
|------|------|
| Security deposit | Max 1/2 month rent |
| Pet deposit | Max 1/2 month rent |
| Contents insurance | $20-40/month |
| Parking (if extra) | $100-200/month |

### Buying Property
- **Average detached home**: $1.8-2.5M
- **Average condo**: $750K-1.2M
- **Down payment**: Minimum 5% (under $500K), 20% to avoid CMHC insurance
- **Foreign buyer tax**: 20%
- **Property transfer tax**: 1-3%
- **Property tax**: ~0.3% of assessed value annually

---

## Food & Groceries

### Grocery Budget
| Lifestyle | Monthly (Single) |
|-----------|------------------|
| Budget-conscious | $350-450 |
| Average | $450-600 |
| Premium/Organic | $600-800 |

### Grocery Store Comparison
| Store | Price Level | Best For |
|-------|-------------|----------|
| No Frills | $ | Budget |
| Superstore | $ | Bulk + variety |
| Save-On-Foods | $$ | Convenience |
| Safeway | $$ | Sales cycles |
| Whole Foods | $$$ | Organic/specialty |
| T&T | $$ | Asian groceries |

### Dining Out
| Meal Type | Cost Range |
|-----------|------------|
| Fast casual lunch | $15-22 |
| Casual dinner | $25-45/person |
| Mid-range dinner | $50-80/person |
| Fine dining | $100-200/person |
| Coffee | $4-7 |
| Craft beer (pint) | $8-12 |

### Tipping
Remember to budget 18-20% tip on all dining.

---

## Transportation

### Transit (Monthly Passes)
| Zones | Monthly Pass |
|-------|--------------|
| 1 Zone | $102.55 |
| 2 Zones | $137.10 |
| 3 Zones | $177.75 |

### Car Ownership
| Item | Annual Cost |
|------|-------------|
| ICBC insurance | $2,000-4,000 |
| Gas | $2,000-3,600 |
| Parking (if paying) | $2,400-4,800 |
| Maintenance | $500-1,500 |
| **Total** | **$7,000-14,000** |

### Car Alternatives
| Option | Cost |
|--------|------|
| Evo (occasional) | $0.45/min, $17.99/hr |
| Modo (planned) | $5/hr + $0.40/km |
| Uber (occasional) | ~$15-30/trip |
| Mobi bike share | $15/month |

---

## Utilities & Services

### Monthly Costs
| Utility | Range | Notes |
|---------|-------|-------|
| Electricity (BC Hydro) | $30-80 | Depends on heating |
| Gas (FortisBC) | $30-60 | If gas heating |
| Internet | $50-100 | Varies by speed/provider |
| Phone | $50-100 | Canadian plans expensive |
| Contents insurance | $20-40 | Recommended |

### Bundling Tips
- Telus/Shaw offer internet + phone bundles
- Contents insurance through CAA or online (SquareOne)
- Budget billing smooths seasonal variations

---

## Healthcare Costs

### MSP Coverage
- **Cost**: Free (as of 2020)
- **Covers**: Doctor visits, hospital, diagnostics
- **Not covered**: Dental, vision, drugs, physio

### If You Need More
| Coverage | Monthly Cost |
|----------|--------------|
| Extended health (employer) | Often included |
| Private extended health | $100-300 |
| Dental (standalone) | $50-100 |

### Out of Pocket
| Service | Cost |
|---------|------|
| Dental cleaning | $200-350 |
| Eye exam | $100-150 |
| Prescription drugs | Variable (PharmaCare helps) |
| Physiotherapy | $80-150/session |
| Massage therapy | $100-150/session |

---

## Childcare & Education

### Childcare
| Type | Monthly Cost |
|------|--------------|
| Infant care (0-18mo) | $1,500-2,200 |
| Toddler care (18mo-3yr) | $1,200-1,800 |
| Preschool (3-5yr) | $1,000-1,500 |
| Before/after school | $400-800 |

**Note**: BC $10/day childcare program rolling out, reducing costs at participating centres.

### Education
| Type | Cost |
|------|------|
| Public school (K-12) | Free |
| Private school | $15,000-40,000/year |
| UBC undergrad (domestic) | ~$6,000/year |
| UBC undergrad (international) | ~$45,000/year |

---

## Entertainment & Lifestyle

### Monthly Estimates
| Category | Budget | Average | Premium |
|----------|--------|---------|---------|
| Gym | $30-50 | $50-100 | $150-250 |
| Streaming services | $15-30 | $30-60 | $60-100 |
| Entertainment | $100 | $200-300 | $400+ |
| Dining out | $150 | $300-500 | $700+ |
| Coffee shops | $40 | $80-120 | $150+ |

### Seasonal Costs
| Activity | Cost |
|----------|------|
| Whistler ski day | $200-250 (lift ticket) |
| Local ski (Grouse) | $70-90 |
| Annual ski pass | $1,000-1,500 |
| Golf (round) | $50-150 |
| Yoga class (drop-in) | $20-30 |

---

## Taxes

### Income Tax (Combined Federal + BC)
| Income Range | Marginal Rate |
|--------------|---------------|
| First $55,867 | 20.06% |
| $55,867-$111,733 | 29.72% |
| $111,733-$173,205 | 40.70% |
| $173,205-$246,752 | 44.08% |
| Over $246,752 | 53.50% |

### Sales Tax
- **GST**: 5% (federal)
- **PST**: 7% (provincial)
- **Total**: 12% on most purchases
- **Exemptions**: Basic groceries, some services

### Property Tax
- ~0.3% of assessed value annually
- Vancouver has homeowner grant reducing amount

---

## Budget Examples

### Single Professional ($75K salary)
| Category | Monthly |
|----------|---------|
| Net income (after tax) | ~$4,800 |
| Rent (1BR East Van) | $2,100 |
| Groceries | $450 |
| Transit | $103 |
| Phone + Internet | $140 |
| Utilities | $70 |
| Health/Dental (employer) | $0 |
| Entertainment | $250 |
| Savings | $500 |
| Misc/Buffer | $187 |

### Couple, No Kids ($140K combined)
| Category | Monthly |
|----------|---------|
| Net income (after tax) | ~$8,700 |
| Rent (2BR Mount Pleasant) | $3,000 |
| Groceries | $700 |
| Transit/Car | $400 |
| Phone + Internet | $180 |
| Utilities | $100 |
| Entertainment | $500 |
| Savings/Investing | $2,000 |
| Misc/Buffer | $820 |

### Family with 2 Kids ($180K combined)
| Category | Monthly |
|----------|---------|
| Net income (after tax) | ~$10,800 |
| Rent/Mortgage (3BR suburbs) | $3,500 |
| Childcare (1 kid, 1 in school) | $1,200 |
| Groceries | $1,000 |
| Car costs | $800 |
| Phone + Internet | $200 |
| Utilities | $150 |
| Kids activities | $300 |
| Insurance | $200 |
| Savings | $1,500 |
| Misc | $950 |

---

## Cost Comparison

### Vancouver vs Other Cities
| Category | Vancouver | Toronto | Seattle | SF |
|----------|-----------|---------|---------|-----|
| 1BR rent | $2,400 | $2,300 | $2,000 | $3,200 |
| Transit pass | $103 | $156 | $99 | $81 |
| Healthcare | Free (MSP) | Free | ~$400/mo | ~$500/mo |
| Avg income | $65K CAD | $62K CAD | $85K USD | $120K USD |

### The Vancouver Trade-off
- **Lower salaries than US tech hubs**
- **Higher housing than most Canadian cities**
- **Free healthcare** (significant savings)
- **Better quality of life** (nature, safety)
- **PR pathway** for long-term stability

---

## Money-Saving Tips

### Housing
- Consider East Van, New Westminster for value
- Basement suites often best value
- Roommates significantly reduce costs
- Move outside peak season (Sept-Oct, Jan-Feb cheaper)

### Food
- Cook more, eat out less
- Ethnic grocery stores (cheaper produce)
- Meal prep and batch cooking
- Costco membership if volume makes sense

### Transport
- Transit is much cheaper than car
- Evo/Modo for occasional car needs
- Bike when possible

### Entertainment
- Free activities: Stanley Park, beaches, hiking
- Happy hours for dining deals
- Library (free books, movies, museum passes)
- Community center programs
