# Vancouver Climate & Weather Survival

## The Reality

Vancouver has Canada's mildest climate—but that comes with rain. Lots of rain.

### Quick Stats
- **Rainy days**: ~170/year
- **Snow days**: ~5-10/year (downtown)
- **Sunny summer days**: July-August spectacular
- **Temperature range**: 3°C winter to 23°C summer (average)
- **Extremes**: Rarely below -5°C or above 30°C

---

## Monthly Breakdown

| Month | Avg High | Avg Low | Rain Days | Character |
|-------|----------|---------|-----------|-----------|
| Jan | 7°C | 2°C | 17 | Grey, wet, cozy |
| Feb | 9°C | 2°C | 13 | Starting to lighten |
| Mar | 11°C | 4°C | 14 | Spring teasing |
| Apr | 14°C | 6°C | 12 | Cherry blossoms! |
| May | 17°C | 9°C | 10 | Gorgeous, warming |
| Jun | 20°C | 12°C | 8 | Summer starting |
| Jul | 23°C | 14°C | 5 | Best month |
| Aug | 23°C | 14°C | 5 | Best month |
| Sep | 19°C | 11°C | 7 | Golden autumn |
| Oct | 14°C | 7°C | 13 | Colours, rain returning |
| Nov | 9°C | 4°C | 18 | Grey settling in |
| Dec | 6°C | 2°C | 17 | Grey, festive |

---

## The Seasons

### Winter (November-March)
**The Grey Season**

**Reality**:
- Grey skies dominate (not dramatic storms, just... grey)
- Rain is light but persistent
- Snow rare at sea level (mountains get plenty)
- 4:30pm darkness in December

**How people cope**:
- Embrace indoor activities
- Ski season (Grouse, Cypress, Whistler)
- Hot yoga, gyms very busy
- Vitamin D supplements common
- Seasonal Affective Disorder (SAD) is real—get a light therapy lamp

**What to wear**:
- Waterproof jacket with hood (essential)
- Layers (rarely truly cold)
- Waterproof boots or shoes
- Umbrella optional (wind destroys them; hood preferred)

### Spring (April-May)
**Cherry Blossom Season**

**Reality**:
- Cherry blossoms transform the city (early April)
- Weather improves but still unpredictable
- Snow disappearing from local mountains
- Hiking season starting

**What to expect**:
- Mix of rain and sun
- Can be gorgeous then grey within hours
- Temperature swings

### Summer (June-September)
**The Best Months**

**Reality**:
- July and August are spectacular
- Long sunny days (sunset after 9pm in June)
- Warm but not hot (rarely above 28°C)
- Very low humidity
- Virtually no rain

**What to do**:
- Beaches (English Bay, Kits, Spanish Banks)
- Hiking (conditions perfect)
- Outdoor dining
- Festivals galore

**What to watch**:
- Wildfire smoke (July-September) can blanket city
- August can be hazier with smoke
- Book accommodations early (peak season)

### Fall (October)
**The Golden Month**

**Reality**:
- Beautiful fall colours
- Still pleasant temperatures
- Rain returning but not constant
- Great shoulder season

---

## Weather Phenomena

### Rain Types

**Drizzle** (Most Common):
- Light, misty rain
- Not dramatic, just persistent
- "It's not really raining" = Vancouver denial

**West Coast Rain**:
- Steady, moderate rain
- Different from prairie thunderstorms
- Rarely torrential

**Atmospheric Rivers**:
- Intense multi-day rain events
- Increasing with climate change
- Can cause flooding
- 2021 had catastrophic example

### Microclimates

Vancouver area has distinct microclimates:

| Area | Character |
|------|-----------|
| Downtown | Standard Vancouver |
| North Shore | Wetter (mountains catch moisture) |
| Richmond | Drier (rain shadow) |
| East Van | Slightly drier than West Side |
| UBC | Foggier |
| SFU/Burnaby Mountain | Foggier, cooler |

**Rain shadow effect**: Mountains north catch moisture, so southern areas (Richmond, Ladner) are measurably drier.

### Snow

**Reality**:
- 5-10 snow days per year on average
- Snow usually melts within 1-2 days
- City doesn't handle snow well (hilly, no equipment)
- Mountains get meters of snow (great for skiing)

**When snow hits**:
- Transit delays
- Schools may close
- People panic (we're not prepared)
- Main roads cleared, side streets not

### Heat Waves

**New reality** with climate change:
- 2021 heat dome: 42°C (lethal event)
- Heat waves becoming more frequent
- Most buildings lack AC
- Cooling centers open during events

**If extreme heat**:
- Find AC (malls, libraries, cooling centers)
- Stay hydrated
- Avoid midday outdoor activity
- Check on elderly neighbors

### Wildfire Smoke

**When**: July-September

**Sources**: Interior BC, Washington, Oregon fires

**Impact**:
- Air Quality Index can spike to hazardous
- Hazy skies, orange sun
- Health impacts for sensitive groups
- Can last days or weeks

**During smoke events**:
- Check AQI before outdoor activities
- Stay indoors when AQI >150
- Run air purifiers (HEPA filters)
- N95 masks for outdoors
- Limit exercise

---

## SAD & Mental Health

### Seasonal Affective Disorder

**Reality**: Vancouver's grey winters affect many people

**Symptoms**:
- Low energy
- Oversleeping
- Carb cravings
- Difficulty concentrating
- Feeling down

**What helps**:
- **Light therapy lamp**: Use 30 min every morning
- **Vitamin D**: Supplements widely taken
- **Exercise**: Gets harder when it's dark, but crucial
- **Social plans**: Combat isolation
- **Embrace the outdoors**: Rainy walks aren't that bad
- **Counseling/therapy**: If symptoms are significant

### The "Raincouver" Attitude

**How residents cope**:
- "There's no bad weather, only bad gear"
- Rain doesn't cancel outdoor plans (you just get wet)
- Appreciate sunny days intensely
- Summer is reward for winter
- Skiing makes winter worthwhile

---

## Outdoor Activity Seasons

### Hiking
| Season | Conditions | Best Areas |
|--------|------------|------------|
| Winter | Lower elevations only, muddy | Lighthouse Park, Pacific Spirit |
| Spring | Snow melting, some closures | Lower trails, some access opening |
| Summer | Perfect conditions | Everything open, alpine accessible |
| Fall | Beautiful, trails quieter | All elevations |

### Skiing
| Mountain | Drive Time | Season |
|----------|------------|--------|
| Grouse | 20 min | Nov-Apr |
| Cypress | 30 min | Nov-Apr |
| Seymour | 30 min | Dec-Mar |
| Whistler | 2 hours | Nov-May |

### Beaches
| Month | Swim? | Sunbathe? |
|-------|-------|-----------|
| Jun | Brave | Sometimes |
| Jul | Yes | Yes |
| Aug | Yes | Yes |
| Sep | Brave | Maybe |

Water temperature: 12-18°C (cold but swimmable)

---

## Packing Guide

### Vancouver Essentials
- [ ] Waterproof jacket with hood
- [ ] Waterproof shoes or boots
- [ ] Layers (temperature shifts)
- [ ] Light sweater even in summer
- [ ] Sunglasses (summer)
- [ ] Sunscreen (summer)

### What You DON'T Need
- Heavy winter coat (rare to need below 0°C)
- Snow boots (unless skiing)
- Dramatic rain gear (drizzle, not storms)
- AC (doesn't exist here)

### Buy Here
- MEC (Mountain Equipment Co-op): Local outdoor gear
- Patagonia: Waterproof quality
- Arc'teryx: Vancouver-born, premium (headquarters here!)
- Blundstones: Popular waterproof boots

---

## Forecast Resources

- **Environment Canada**: Official forecasts
- **Weather Network**: Good app
- **AQI**: aqicn.org or BC Air Quality
- **Mountain conditions**: Snow reports from resorts
- **Marine forecast**: If boating
