# Starting a Business in Vancouver

## Business Structures

### Sole Proprietorship
- Simplest structure
- You and business are same legal entity
- Personal liability for debts
- Easy to start, register business name

### Partnership
- Two or more owners
- General or limited partnership
- Partners share liability

### Corporation (Inc./Ltd.)
- Separate legal entity
- Limited liability
- More complex, higher costs
- Tax advantages possible

### Choosing Structure
| Factor | Sole Prop | Corporation |
|--------|-----------|-------------|
| Startup cost | $30-50 | $300-1,000 |
| Liability | Personal | Limited |
| Tax complexity | Simple | Complex |
| Credibility | Lower | Higher |
| Raising capital | Harder | Easier |

---

## Registration Process

### Sole Proprietorship
1. Name search (BC Registry)
2. Register business name (~$30)
3. Get business license (City of Vancouver)
4. Register for GST/PST if needed

### Corporation
1. Name approval (NUANS search)
2. File incorporation documents
3. Create articles, bylaws, resolutions
4. Register with BC Registry (~$350)
5. Business license
6. Set up corporate records

### Where to Register
- **BC Registry Services**: bcregistryservices.gov.bc.ca
- **Federal incorporation**: ised-isde.canada.ca
- Lawyers/accountants can handle

---

## Business Licenses

### City of Vancouver
- Required for most businesses
- Apply online: vancouver.ca/doing-business
- Fees vary by business type ($100-500+)
- Renewed annually

### Home-Based Business
- Allowed with restrictions
- Must be secondary to residential use
- Limitations on employees, signage, traffic
- Specific license category

### Provincial Licensing
Some industries require provincial licensing:
- Real estate
- Insurance
- Contractors
- Healthcare professions

---

## Taxes

### Federal (CRA)
- **Corporate tax**: 15% federal, 26.5% combined with BC
- **GST**: 5% on most goods/services
- **Payroll taxes**: CPP, EI contributions

### Provincial
- **PST**: 7% on goods (not services usually)
- **Corporate tax**: 12% general, 2% small business (<$500K)

### Small Business Deduction
- First $500,000 of active business income
- Combined rate ~12.5%
- Significant savings

### Filing Requirements
- Corporate tax return annually
- GST return (annual, quarterly, or monthly)
- T4s for employees
- Payroll remittances

---

## Hiring Employees

### Employment Standards (BC)
- Minimum wage: $17.40/hour (2024, increases annually)
- Overtime: 1.5x after 8 hours/day or 40 hours/week
- Statutory holidays: 10 per year
- Vacation: Minimum 2 weeks (4% pay)

### Payroll Obligations
| Deduction | Rate |
|-----------|------|
| CPP (employer) | 5.95% |
| EI (employer) | 1.4x employee rate |
| WorkSafeBC | Varies by industry |

### Contractors vs Employees
- CRA scrutinizes misclassification
- Factors: control, ownership of tools, financial risk
- Misclassification = penalties

---

## Funding Options

### Government Programs
| Program | What It Offers |
|---------|----------------|
| IRAP (NRC) | R&D funding for tech |
| SR&ED | R&D tax credits |
| Futurpreneur | Loans + mentoring for young entrepreneurs |
| BDC | Business Development Bank loans |
| BCIC | BC Innovation Council programs |
| Women's Enterprise Centre | Women entrepreneur programs |

### Venture Capital
- Version One Ventures
- Yaletown Partners
- TIMIA Capital
- Vanedge Capital
- BDC Capital

### Angel Networks
- VANTEC Angel Network
- Angel Forum
- Keiretsu Forum

### Bank Financing
- Harder for startups
- May require personal guarantee
- BDC more startup-friendly than Big 5

---

## Co-Working & Office Space

### Co-Working
| Space | Location | Notes |
|-------|----------|-------|
| WeWork | Downtown, multiple | Global chain |
| Spaces (Regus) | Downtown | Professional |
| The Hive | Various | Local |
| Launch Academy | Downtown | Startup focused |

### Office Lease
- Downtown: $40-60/sq ft/year
- Yaletown/Gastown: $35-50
- East Van/Mount Pleasant: $25-40
- Suburbs: $20-35

---

## Accounting & Legal

### Finding Professionals
- **Accountants**: CPA designation required
- **Lawyers**: Business/corporate law specialty
- Referrals from other entrepreneurs best

### Cost Expectations
| Service | Range |
|---------|-------|
| Incorporation (lawyer) | $1,000-2,500 |
| Annual accounting | $2,000-10,000+ |
| Bookkeeper (monthly) | $300-1,000 |
| Legal (hourly) | $300-600 |

### DIY Options
- Wave, QuickBooks for accounting
- Ownr, Incorporate.ca for incorporation
- Fine for simple businesses

---

## Industry-Specific

### Tech Startup
- SR&ED tax credits (significant)
- BC Tech Pilot for hiring immigrants
- Interactive Digital Media Tax Credit (17.5%)

### Food & Beverage
- Vancouver Coastal Health permits
- Food safety certification
- Liquor licensing (complex)

### Retail
- Business license per location
- Signage permits
- PST collection

### Professional Services
- May need professional licensing
- Insurance requirements
- Regulatory compliance

---

## Immigrant Entrepreneurs

### Start-up Visa Program
- For innovative businesses
- Need support from designated organization
- Can lead to PR

### BC PNP Entrepreneur Immigration
- Invest $200K+ in BC business
- Create jobs
- Leads to PR nomination

### Work Permit Options
- Owner-operator LMIA (can hire yourself)
- Intra-company transfer
- C11 Entrepreneur exemption (limited)

---

## Resources

### Government
- **Small Business BC**: smallbusinessbc.ca (excellent, free support)
- **BC Registries**: bcregistryservices.gov.bc.ca
- **CRA Business**: canada.ca/business

### Organizations
- **Vancouver Economic Commission**: vancouvereconomic.com
- **BC Chamber of Commerce**: bcchamber.org
- **Startup BC**: startupbc.com

### Programs
- **Futurpreneur**: futurpreneur.ca
- **Community Futures**: communityfutures.ca
- **Women's Enterprise Centre**: wec.ca
