# Valencia Visitor Tips

## Essential Knowledge

### Language
- **Spanish (Castellano)**: Everyone speaks it
- **Valenciano**: Co-official, you'll see it on signs
- **English**: Widely spoken in tourist areas, hotels, by young people
- **Useful phrases**:
  - "Hola, buenos días" — Hello, good morning
  - "La cuenta, por favor" — The bill, please
  - "¿Dónde está...?" — Where is...?
  - "Gracias / De nada" — Thank you / You're welcome

### Money
- **Currency**: Euro (€)
- **Cards**: Widely accepted, but carry some cash for:
  - Small bars and kiosks
  - Market stalls
  - Beach vendors
- **ATMs**: Abundant, use bank ATMs (avoid standalone ones)
- **Tipping**: Not obligatory. Round up or 5-10% for good service

### Timing
- **Lunch**: 13:30-15:30 (don't expect to eat paella at 11am)
- **Dinner**: 21:00-23:00 (restaurants often empty before 21:00)
- **Siesta**: Many shops close 14:00-17:00
- **Nightlife**: Bars fill after 23:00, clubs after 01:00

### Connectivity
- **WiFi**: Excellent in hotels, cafes, public spaces
- **SIM cards**: Orange, Vodafone, Yoigo — easy to get at any phone shop
- **eSIM**: Works with most carriers
- **Emergency**: 112

---

## Getting Around

### From Airport (VLC)
- **Metro**: Line 3/5, 25 min to Centro, €4.90 (airport supplement)
- **Taxi**: Fixed rate €20 to Centro, ~25 min
- **Bus**: Line 150, €1.45, 45 min

### Public Transport
- **Metro/Tram**: 9 lines, clean, efficient
- **EMT buses**: Dense network, real-time app "EMT Valencia"
- **Valenbisi**: Bike share, 275 stations, €30/year or €13/week
- **Single ride**: €1.50 (€2 with transfer bonuses)
- **Day pass**: €4 (unlimited bus/metro zones ABC)
- **Valencia Card**: Tourism pass with unlimited transport + museum discounts

### Taxis & Rideshare
- **Taxi**: White cars with green stripe, metered, reliable
- **Apps**: Cabify, Uber (limited), Free Now
- **From Centro to beach**: ~€10
- **From Centro to CAC**: ~€8

### Walking & Biking
- Centro Histórico: Completely walkable
- Jardín del Turia: 9km of car-free cycling/walking
- Valenbisi: First 30 min free, then €0.50/30 min
- Bike rentals: €10-15/day

---

## Day Trips

### By Train (RENFE)

| Destination | Time | Why Go |
|-------------|------|--------|
| Sagunto | 30 min | Roman theater, castle |
| Xàtiva | 45 min | Castle, Borgia history |
| Alicante | 1h 40min | Beaches, Santa Bárbara castle |
| Castellón | 1 hour | Quieter coast, nearby towns |

**Book at**: renfe.com or RENFE app

### By Bus (ALSA, Flixbus)

| Destination | Time | Why Go |
|-------------|------|--------|
| Peñíscola | 1h 30min | Medieval castle peninsula |
| Morella | 2h 15min | Walled medieval town |
| Guadalest | 2 hours | Mountain fortress |

### By Car

| Destination | Time | Why Go |
|-------------|------|--------|
| La Albufera | 20 min | Lagoon, rice paddies, paella |
| Requena | 1 hour | Wine country, bodegas |
| Montanejos | 1 hour | Hot springs, hiking |
| Chulilla | 45 min | Dramatic gorge, climbing |

**Rental**: Book ahead, pick up at airport or train station
**Parking in Valencia**: Difficult in Centro; use parkings públicos (€15-20/day)

---

## Safety

### General Safety
- **Valencia is very safe** — among safest large cities in Spain
- Normal precautions: watch bags in crowded areas
- **Pickpockets**: Rare but possible in Mercado Central, metro, tourist crowds
- **Scams**: Not common; watch for fake petitions or "friendship bracelet" sellers

### Beach Safety
- **Lifeguards**: Summer only, flagged zones
- **Belongings**: Don't leave valuables unattended
- **Sun**: SPF essential, even in "mild" weather

### Night Safety
- El Carmen is safe but busy late at night
- Ruzafa safe at all hours
- Avoid deserted areas in any city
- Taxis always available

### Health
- **Tap water**: Safe to drink
- **Pharmacies**: Green cross, many open late
- **Hospital**: Hospital La Fe, Hospital General
- **EU citizens**: EHIC card for free healthcare
- **Non-EU**: Travel insurance required

---

## Cultural Tips

### Do's
- ✅ Say "Hola" when entering shops
- ✅ Greet with two kisses (cheek, not lip) in social settings
- ✅ Take your time at meals — rushing is rude
- ✅ Dress slightly nicer than "full tourist"
- ✅ Respect siesta hours and noise levels
- ✅ Learn "por favor" and "gracias" — goes a long way

### Don'ts
- ❌ Don't expect quick service — it's intentional relaxation
- ❌ Don't skip the greeting ("Hola, buenos días")
- ❌ Don't order paella for dinner (lunch only for locals)
- ❌ Don't be loud after midnight in residential areas
- ❌ Don't mistake Valenciano for "bad Spanish"

### Fallas-Specific (March 15-19)
- Expect LOUD firecrackers at all hours
- Book everything months ahead
- Don't plan normal sightseeing — embrace the chaos
- Wear earplugs for sleeping (or join the party)
- Mascletà at 14:00 daily in Plaza del Ayuntamiento — don't miss it

---

## Practical Essentials

### What to Pack
- **Summer**: Sunscreen, hat, light clothing, swimwear
- **Winter**: Light jacket, umbrella, layers
- **Year-round**: Comfortable walking shoes, adapter (Type C/F plugs)

### Useful Apps
- **EMT Valencia**: Real-time bus tracking
- **Metrovalencia**: Metro maps and times
- **Valenbisi**: Bike share
- **Google Maps**: Works well for navigation
- **RENFE Ticket**: Train booking
- **TheFork/ElTenedor**: Restaurant reservations

### Tourist Information
- **Main office**: Plaza de la Reina (near Cathedral)
- **Airport**: Arrivals hall
- **Website**: visitvalencia.com

---

## Money-Saving Tips

1. **Menú del día**: Lunch 3-course menus €12-18 (huge savings vs à la carte)
2. **Free museums**: Many free on Sundays (Bellas Artes always free)
3. **Valenbisi**: €30/year unlimited bikes vs €15/day rental
4. **Tap water**: "Agua del grifo" at restaurants, don't pay for bottles
5. **Metro bonos**: 10-trip passes cheaper than singles
6. **Vermouth hour**: Cheap drinks 12:00-14:00 at traditional bars
7. **Beach**: Free, obviously — don't pay €20 for sunbeds
8. **Walking**: Centro is compact, save transport money

---

## Common Mistakes

1. **Expecting Barcelona pace**: Valencia is slower, embrace it
2. **Eating paella at dinner**: It's a lunch dish (tourist restaurants don't care, but you'll know)
3. **Only visiting CAC**: The historic center is where the soul is
4. **Ignoring Ruzafa**: Best neighborhood for eating and drinking
5. **Renting a car for city only**: Unnecessary and parking is painful
6. **August visit without research**: Many local places closed
7. **Skipping La Albufera**: The authentic paella experience
8. **Over-planning**: Leave time to wander and discover

---

## Quick Emergency Info

| Need | Number/Info |
|------|-------------|
| Emergency | 112 |
| Police | 091 (National), 092 (Local) |
| Ambulance | 112 |
| Hospital | Hospital La Fe, Av. Fernando Abril Martorell |
| Pharmacy finder | farmaciasvalencia.com |
| Lost & Found | EMT: 963 158 585 |
| Tourist Police | 963 539 642 |
