# Valencia Visas Guide

## Overview

Spain offers multiple visa pathways. EU citizens have it easy; non-EU citizens have increasingly good options including the Digital Nomad Visa (2023).

---

## EU Citizens

### No Visa Needed
EU/EEA/Swiss citizens can:
- Enter and stay indefinitely
- Work without permit
- Access public services after registration

### Registration Process
1. **First 3 months**: No registration required
2. **After 3 months**: Register for EU citizen certificate
3. **Requirements**: 
   - Employment, OR
   - Self-employment, OR
   - Sufficient funds + health insurance, OR
   - Student status

### Documents for Registration
- Passport/ID
- Proof of requirement (contract, bank statements, enrollment)
- Application form (EX-18)
- Fee: ~€12

---

## Non-EU Citizens

### Visa Categories

| Visa | Duration | Work | Best For |
|------|----------|------|----------|
| Tourist (Schengen) | 90 days | No | Short visits |
| Digital Nomad | Up to 5 years | Remote only | Remote workers |
| Non-Lucrative | 1 year, renewable | No | Retirees, wealthy |
| Autónomo | 1 year, renewable | Self-employed | Freelancers |
| Work Visa | 1-2 years | Yes | Employed workers |
| Student | 1 year | 20h/week | Students |
| Entrepreneur | 1 year, renewable | Yes | Business founders |
| Golden Visa | 2 years, renewable | Yes | Investors (€500K+) |

---

## Digital Nomad Visa (Most Relevant)

### Overview
Introduced January 2023 for remote workers employed by non-Spanish companies.

### Requirements
| Requirement | Details |
|-------------|---------|
| Income | €2,520/month minimum (2x IPREM) |
| Employment | Remote work for non-Spanish company |
| OR Freelance | 3+ months history, <20% Spanish clients |
| Education | Degree or 3+ years professional experience |
| Health insurance | Full coverage in Spain |
| Clean record | Criminal background check |
| Company age | Employer must exist 1+ year |

### Duration
- Initial: 1 year (applied from abroad) or 3 years (applied in Spain)
- Renewal: Up to 5 years total
- Path to residency: Yes

### Application Process
1. **From abroad**: Apply at Spanish consulate
2. **In Spain** (if legally present): Apply at Unidad de Grandes Empresas

### Documents Needed
- Passport (valid 1+ year)
- Criminal background check (apostilled)
- Health insurance proof
- Employment contract or client contracts
- Income proof (3-6 months bank statements)
- Degree or work experience proof
- Application forms
- Photos

### Processing Time
- From abroad: 1-3 months
- In Spain: 20 working days (official)

### Cost
- Visa fee: ~€80
- TIE card: ~€20
- Apostilles, translations: €100-300

### Benefits
- Work remotely for non-Spanish companies
- Bring family (spouse, children)
- Travel Schengen freely
- Path to permanent residency
- Beckham Law tax benefits possible

---

## Non-Lucrative Visa

### Overview
For those with passive income who won't work in Spain.

### Requirements
| Requirement | Details |
|-------------|---------|
| Income | ~€2,500/month (varies by consulate) |
| Source | Passive (investments, pension, rental) |
| Work | Not permitted |
| Health insurance | Full coverage |

### Best For
- Retirees with pension
- People living off investments
- Those who don't need to work

### Limitations
- Cannot work (at all)
- Cannot easily convert to work permit
- Must maintain income requirements

---

## Autónomo (Self-Employed) Visa

### Overview
For freelancers and self-employed professionals.

### Requirements
- Business plan
- Proof of qualifications
- Sufficient funds (~€5,000-10,000)
- Health insurance
- Clean record

### Process
1. Apply at consulate
2. If approved, enter Spain
3. Register as autónomo
4. Pay Social Security (~€300/month, discounts first year)

### Best For
- Freelancers with existing clients
- Consultants
- Independent professionals

---

## Work Visa (Employment)

### Overview
Traditional employment visa requiring Spanish employer sponsorship.

### Process
1. Spanish company offers job
2. Company applies for work authorization
3. Authorization granted (or denied)
4. You apply for visa at consulate
5. Enter Spain, get TIE

### Challenges
- Employer must prove no EU candidate available
- Bureaucratic process
- Dependent on employer

### Highly Qualified (EU Blue Card)
- For highly skilled workers
- Salary threshold: ~€45,000+
- Faster processing
- Better mobility within EU

---

## Student Visa

### Overview
For studying at Spanish educational institutions.

### Requirements
- Acceptance letter from school
- Proof of funds (~€600/month)
- Health insurance
- Clean record

### Work Rights
- 20 hours/week permitted
- Full-time during holidays

### Converting to Work Visa
- Possible after completing studies
- Must find employer willing to sponsor
- Or switch to autónomo

---

## Golden Visa (Investor)

### Overview
Residency through investment.

### Investment Options
| Investment | Minimum |
|------------|---------|
| Real estate | €500,000 |
| Bank deposit | €1,000,000 |
| Spanish company shares | €1,000,000 |
| Government bonds | €2,000,000 |
| Business creating jobs | Variable |

### Benefits
- Residency for investor + family
- Work permitted
- No minimum stay requirement
- Path to citizenship (10 years)

### Best For
- Wealthy individuals
- Property investors
- Those wanting minimal ties

---

## Beckham Law (Tax Benefits)

### Overview
Special tax regime for new tax residents.

### Benefits
- Flat 24% income tax (vs progressive up to 47%)
- Only Spanish-source income taxed (not worldwide)
- Duration: 6 years

### Eligibility
- Haven't been Spanish tax resident in past 5 years
- Moving for work (employed) or Digital Nomad Visa
- Must apply within 6 months of arrival

### How to Apply
1. Get NIE
2. Start employment/work
3. Apply via Model 149

### Limitations
- Can't own >25% of Spanish company employing you
- Must be "regular" employment (some interpretation for DN)
- Wealth tax still applies

---

## Family Reunification

### For Non-EU with Legal Residence
Can bring:
- Spouse
- Children under 18
- Dependent parents (in some cases)

### Requirements
- Proof of relationship
- Sufficient income to support family
- Adequate housing
- Health insurance for family members

### Process
1. Apply at Spanish consulate in family's country
2. Processing: 1-3 months
3. Family enters Spain
4. Apply for TIE cards

---

## Path to Permanent Residency

### Long-Term Residency
- After 5 years of legal residence
- Continuous (can't be absent >6 months/year)
- No need to renew

### Spanish Citizenship
- After 10 years of legal residence (general)
- After 2 years for Latin American nationals
- After 1 year if married to Spanish citizen
- Requires Spanish language test
- May require renouncing original citizenship

---

## Practical Tips

### Before Applying
1. Gather documents early (apostilles take time)
2. Get translations certified
3. Research your specific consulate's requirements
4. Budget for fees and translations

### Apostille
- Required for official documents
- Get in your home country BEFORE leaving
- Criminal record, degrees, marriage certificates

### Health Insurance
- Must cover full year
- No co-pays or deductibles (some consulates strict)
- Providers: Sanitas, Adeslas, Cigna Global

### Processing Times
- Vary wildly by consulate
- Summer: Slower
- Book appointment early

### Renewals
- Apply 60 days before expiration
- Don't let status lapse
- Keep documentation organized

---

## Useful Resources

| Resource | URL |
|----------|-----|
| Official immigration | extranjeros.inclusion.gob.es |
| Appointment booking | sede.administracionespublicas.gob.es |
| Consulate finder | exteriores.gob.es |
| Digital Nomad info | lamoncloa.gob.es |
