# Valencia Transport Guide

## Overview

Valencia has excellent public transport for a Spanish city. Unlike Madrid or Barcelona sprawl, the city is compact enough that many people live car-free.

### Quick Stats
- **Metro/Tram**: 9 lines
- **EMT Buses**: 60+ lines
- **Valenbisi**: 275 bike stations
- **Airport**: 8km from Centro

---

## Metro & Tram (Metrovalencia)

### Network
- **Lines**: 1, 2, 3, 4, 5, 6, 7, 9, 10 (some are tram)
- **Coverage**: Centro, beach, airport, suburbs
- **Hours**: 05:00-23:30 (varies by line)
- **Frequency**: 5-15 min depending on line/time

### Key Lines
| Line | Route | Useful For |
|------|-------|------------|
| 3 | Airport ↔ Centro ↔ Rafelbunyol | Airport access, Centro |
| 5 | Airport ↔ Centro ↔ Marítim | Airport, Centro, beach |
| 4 | Tram: Mas del Rosari ↔ Dr. Lluch | El Cabanyal, beach |
| 6 | Tram: Tossal ↔ Marítim | Beach access |

### Fares
| Ticket | Price | Notes |
|--------|-------|-------|
| Single (zones ABC) | €1.50 | Valid 60 min with transfers |
| Airport supplement | +€3.90 | Added to any ticket |
| Bonometro 10 trips | €7.60 | Best value for visitors |
| Monthly pass (ABC) | €45 | Unlimited metro + bus |
| SUMA 10 | €8.45 | Metro + EMT buses |

### Airport Connection
- **Lines 3 and 5** go to airport
- **Journey**: 25-30 min from Centro
- **Single ticket**: €4.90 (incl. airport supplement)
- **First train**: ~05:30
- **Last train**: ~23:30

### Tips
- **Mobilis card**: Rechargeable, buy at machines
- **App**: Metrovalencia app for times and route planning
- **Airport**: Allow 45 min from Centro (train + walking + security)

---

## Buses (EMT Valencia)

### Network
- 60+ lines covering the city
- Complements metro for areas not reached
- Generally slower than metro

### Useful Lines
| Line | Route | For |
|------|-------|-----|
| 25 | Centro → La Albufera | Day trips to lagoon |
| 150 | Airport → Centro | Airport alternative |
| 1 | Circular Centro | Tourist sights |
| 4, 19 | Beach lines | Malvarrosa |

### Fares
- Single: €1.50 (same as metro)
- Bonobús 10: €7.60
- Can use same Mobilis card as metro

### App
- **EMT Valencia**: Real-time arrivals, route planner
- Shows how crowded buses are
- Essential if using buses regularly

---

## Valenbisi (Bike Share)

### System
- 275 stations throughout the city
- 2,750 bikes available
- 24/7 service
- Electric bikes at some stations

### Pricing
| Plan | Cost | Best For |
|------|------|----------|
| Annual | €30/year | Residents |
| Weekly | €13/week | Visitors |
| First 30 min | Free | Short hops |
| 30-60 min | €0.52 | |
| 60-90 min | €0.99 | |
| 90+ min | €3/hour | Avoid this |

### How to Use
1. Register at valenbisi.es or machine
2. Get card or use app
3. Take bike from any station
4. Return to any station
5. Wait 5 min before taking another

### Tips
- Return before 30 min to keep it free
- Check bikes for working brakes, lights
- App shows station availability
- Jardín del Turia = best bike route

### Best Routes
- **Jardín del Turia**: 9km, car-free, beautiful
- **Beach promenade**: Malvarrosa to Patacona
- **Centro to Ruzafa**: Flat, easy
- **El Cabanyal exploration**: Nice for biking

---

## Taxis

### Basics
- **Color**: White with green stripe
- **Hailing**: Wave down, stands, or app
- **Meters**: Always used, always on
- **Safe**: Very safe, regulated

### Apps
- **Free Now**: Main taxi app
- **Uber**: Limited service
- **Cabify**: Works well
- **Pidetaxi**: Local alternative

### Typical Fares
| Route | Approximate |
|-------|-------------|
| Centro to Airport | €20 (fixed) |
| Centro to Beach | €10-12 |
| Centro to CAC | €8-10 |
| Ruzafa to El Cabanyal | €10-12 |

### Night Supplement
- After 22:00 and weekends: ~20% more
- Airport fare is fixed regardless

---

## Driving

### Do You Need a Car?

**Probably not if:**
- Living in Centro, Ruzafa, or beach areas
- Working remotely or in Centro
- Comfortable with public transit

**Maybe yes if:**
- Family with kids in suburban schools
- Regular trips to La Albufera, wine country
- Working in business parks
- Living in outer suburbs

### Parking

**Centro**: Extremely difficult
- Street parking nearly impossible
- Public garages: €2-3/hour, €15-25/day
- Resident permit system (limited)

**Ruzafa**: Difficult but possible
- Residents often have permits
- Some street parking at night

**Suburbs**: Easy
- Most buildings have parking

### Key Driving Facts
- **Side of road**: Right
- **License**: EU valid, non-EU may need IDP
- **Speed limits**: Urban 30-50, highway 120 km/h
- **Alcohol**: 0.5 g/L limit (0.3 for new drivers)

### Car Rental
- Airport or train station pickup
- Book ahead in summer
- Check insurance carefully
- Automatic transmission costs more

See `driving.md` for full details.

---

## Walking

Valencia is very walkable:

### Walk Times
| From Centro to | Minutes |
|----------------|---------|
| Ruzafa | 15 |
| Mercado Central | 5 |
| CAC | 25-30 |
| Beach | 35-40 (bike better) |
| El Carmen | 5-10 |

### Pedestrian Zones
- Most of Centro Histórico
- Jardín del Turia (entire 9km)
- Parts of El Carmen

### Tips
- Comfortable shoes for cobblestones
- Summer: Walk early morning or evening
- Winter: Pleasant all day

---

## Airport (VLC)

### Getting To/From

| Method | Time | Cost |
|--------|------|------|
| Metro (L3, L5) | 25 min | €4.90 |
| Taxi | 20 min | €20 (fixed) |
| Bus 150 | 45 min | €1.45 |
| Cabify/Uber | 20 min | €15-20 |

### Airport Tips
- Small airport, efficient
- Arrive 90 min before domestic, 2h international
- Metro runs 05:30-23:30
- Night arrivals = taxi only

### Destinations from VLC
- Most European capitals
- Some Africa and Middle East
- US via connections

---

## Train (RENFE)

### Types
- **Cercanías**: Regional commuter trains
- **Media Distancia**: To nearby cities
- **AVE**: High-speed to Madrid, Barcelona

### Useful Routes
| To | Type | Time | Price |
|----|------|------|-------|
| Madrid | AVE | 1h 40min | €25-60 |
| Barcelona | AVE | 2h 45min | €30-80 |
| Alicante | AVE/MD | 1h-1h 40min | €15-30 |
| Castellón | MD | 1 hour | €7-15 |
| Xàtiva | Cercanías | 45 min | €4-6 |

### Stations
- **Valencia Estación del Norte**: Beautiful station, main hub
- **Valencia Joaquín Sorolla**: AVE station (modern, nearby)

### Booking
- renfe.com (book ahead for AVE discounts)
- RENFE app
- Station machines

---

## Practical Tips

### Combined Cards
- **SUMA**: Metro + EMT buses
- **Valencia Card**: Unlimited transport + museum discounts

### Apps to Install
1. Metrovalencia
2. EMT Valencia
3. Valenbisi
4. Free Now (taxis)
5. Google Maps (integrates all)

### Visitor vs Resident
| Visitor (1 week) | Resident |
|------------------|----------|
| Bonometro 10 + walk | Monthly pass €45 |
| Valenbisi weekly €13 | Valenbisi annual €30 |
| Taxi for airport | Metro + occasional taxi |

### Google Maps
- Works well for all transit
- Real-time data integrated
- Use for route planning
- Sometimes misses Valenbisi stations
