# Valencia Startup Ecosystem

## Overview

Valencia's startup scene is growing rapidly. Lower costs than Madrid/Barcelona, improving infrastructure, and quality of life make it attractive for founders.

### Why Valencia for Startups

**Advantages**:
- 40-50% cheaper than Barcelona
- Growing investor presence
- Strong accelerator (Lanzadera)
- Quality of life attracts talent
- University talent pipeline
- Government support initiatives

**Challenges**:
- Smaller ecosystem than Madrid/Barcelona
- Less VC presence (improving)
- Fewer exits to date
- Spanish bureaucracy still applies

---

## Key Ecosystem Players

### Lanzadera (The Big One)

**What it is**: Spain's largest private accelerator, founded by Juan Roig (Mercadona)

**Location**: Marina de Empresas, Valencia port

**Programs**:
| Program | Duration | Investment | For |
|---------|----------|------------|-----|
| Lanzadera | 9 months | €0-200K | Early stage |
| Lanzadera Scale | Ongoing | €200K-2M | Growth |
| Angels | Ongoing | Up to €200K | Very early |

**What they provide**:
- Free coworking space
- Mentorship
- Investment (convertible loans)
- Network access
- Events and visibility

**Application**: Rolling, through lanzadera.es

**Culture**: Intense, founder-first, practical (Mercadona efficiency mindset)

### Marina de Empresas

**What it is**: Physical campus combining:
- Lanzadera (accelerator)
- EDEM (business school)
- Angels Capital (investment arm)
- Coworking and events

**Why it matters**: Concentration of startup activity, networking, resources

### Big Ban Angels

**What it is**: Angel network

**Focus**: Early-stage Valencian startups

**Typical investment**: €25K-200K

### Innsomnia

**What it is**: Corporate innovation hub

**Focus**: Corporate-startup collaboration, open innovation

**Programs**: Various corporate-sponsored accelerators

### StartUPV / Fundación Universidad-Empresa

**What it is**: University of Valencia / UPV startup support

**Services**: Incubation, pre-acceleration, academic spin-offs

---

## Funding Landscape

### Stages and Sources

| Stage | Typical Amount | Sources |
|-------|---------------|---------|
| Pre-seed | €10K-100K | FFF, angels, grants |
| Seed | €100K-500K | Angels, Lanzadera, micro-VCs |
| Series A | €500K-3M | VCs, Lanzadera Scale |
| Series B+ | €3M+ | Mostly Madrid/Barcelona VCs |

### Active Investors in Valencia

| Investor | Stage | Typical Check |
|----------|-------|---------------|
| Angels Capital | Pre-seed/Seed | €50K-200K |
| Big Ban Angels | Pre-seed/Seed | €25K-200K |
| Lanzadera | Seed | €0-200K (convertible) |
| Plug and Play | Seed | Varies |

### Spanish VCs (Madrid/Barcelona but active)

| VC | Stage | Notes |
|----|-------|-------|
| Kfund | Seed-A | Tech focus |
| Samaipata | Seed-A | Marketplace focus |
| JME Ventures | Seed | Generalist |
| Nauta Capital | A-B | B2B SaaS |
| Seaya | A-B | Large fund |

### International VCs
- Index Ventures
- Balderton
- Northzone
- Accel

*Most require Madrid/Barcelona presence or significant traction*

### Government Grants

| Program | Amount | Notes |
|---------|--------|-------|
| ENISA | €25K-1.5M | Participative loans |
| CDTI | Varies | R&D projects |
| IVACE | Varies | Valencian government |
| Horizon Europe | Large | EU research grants |

---

## Coworking & Spaces

### Startup-Focused

| Space | Location | Cost | Notes |
|-------|----------|------|-------|
| Lanzadera | Marina | Free* | For portfolio companies |
| Impact Hub | Ruzafa | €200-300 | Social impact focus |
| Wayco | Multiple | €150-250 | General coworking |
| La Pinada | Ruzafa | €150-200 | Creative focus |

### Events Venues
- Marina de Empresas (large events)
- Impact Hub (medium events)
- Various coworkings (small events)

---

## Startup Events

### Regular Events
| Event | Frequency | Focus |
|-------|-----------|-------|
| Lanzadera Demo Day | Biannual | Portfolio pitches |
| Startup Valencia meetups | Monthly | Networking |
| VLC Tech Hub events | Regular | Tech community |
| Product Tank Valencia | Monthly | Product management |

### Annual Conferences
- **South Summit Madrid**: Nearby, worth attending
- **4YFN Barcelona**: MWC startup event
- **Various Lanzadera events**: Throughout year

---

## Talent

### Finding Talent

**Local sources**:
- Universidad Politécnica de Valencia (UPV) — Engineering
- Universidad de Valencia — Business, sciences
- EDEM — Business school at Marina
- Bootcamps — Ironhack, Le Wagon

**Hiring**:
- LinkedIn: Standard
- InfoJobs: Spanish platform
- Manfred: Tech-focused
- GetOnBoard: Startups
- Twitter/X: Tech community
- Local meetups: Direct networking

### Salary Expectations (Tech)

| Role | Annual Range |
|------|--------------|
| Junior developer | €25K-35K |
| Mid developer | €35K-50K |
| Senior developer | €45K-70K |
| Tech lead | €55K-80K |
| CTO (startup) | €60K-100K + equity |

*30-40% lower than Madrid/Barcelona*

### Talent Advantages
- Lower salary expectations = longer runway
- Good technical universities
- Lifestyle attracts remote talent
- Growing international community

---

## Support Programs

### Accelerators

| Program | Focus | Application |
|---------|-------|-------------|
| Lanzadera | General | lanzadera.es |
| Plug and Play | Corporate | plugandplaytechcenter.com |
| Innsomnia | Open innovation | innsomnia.es |
| CEEI Valencia | General | ceeivalencia.es |

### Incubators

| Program | For | Contact |
|---------|-----|---------|
| StartUPV | University spin-offs | UPV |
| Parque Científico UV | Research-based | UV |
| Las Naves | Social innovation | lasnaves.com |

### Government Support

**IVACE** (Valencian government):
- Grants for startups
- Internationalization support
- Innovation funding

**ENISA** (National):
- Participative loans €25K-1.5M
- No collateral required
- Based on viability of project

---

## Legal Setup for Startups

### Recommended Structure
- **S.L. (Sociedad Limitada)**: Standard for raising investment
- **Minimum capital**: €3,000
- **Vesting**: Not automatic in Spain — must be contractually arranged

### Key Legal Considerations
- Shareholders' agreement essential
- IP assignment from founders
- Employee stock options are complex (tax issues)
- "Ley de Startups" (2022) improves some conditions

### Ley de Startups Benefits
- Reduced corporate tax (15% vs 25%)
- Better stock option taxation
- Digital Nomad Visa improvements
- Simplified bureaucracy (in theory)

### Finding Lawyers
- Cuatrecasas, Garrigues: Large firms
- Lexcrea, Metricson: Startup-focused
- Budget: €200-400/hour

---

## Success Stories from Valencia

Notable Valencia-connected startups:
- **Flywire**: Payment platform, IPO
- **Jeff**: Laundry app, major funding
- **Heura**: Plant-based food
- **Zeleros**: Hyperloop technology
- **Voicemod**: Voice modulator software

*Scene is younger than Madrid/Barcelona but producing results*

---

## Tips for Founders

### Getting Started
1. **Join Lanzadera** if possible — best local resource
2. **Attend events** — small scene, relationships matter
3. **Consider remote talent** — expand your hiring pool
4. **Connect with expat founders** — growing community
5. **Leverage cost advantage** — stretch runway

### Fundraising Realities
- **Seed**: Possible locally
- **Series A**: Likely need Madrid/Barcelona or international VCs
- **Be prepared to travel** for bigger rounds
- **Don't limit to Valencia** — Spanish investors look nationally

### Common Mistakes
- Underestimating bureaucracy time
- Not getting proper legal setup early
- Ignoring employee contracts/equity complexity
- Trying to do everything locally when network is bigger
- Not learning Spanish (limits local hiring/networking)

---

## Resources

### Websites
- lanzadera.es — Accelerator
- startupvalencia.org — Community
- vlctechhub.org — Tech community
- ivace.es — Government grants

### Communities
- Startup Valencia (Telegram/Slack)
- VLC Tech Hub
- Product Tank Valencia
- LinkedIn groups

### Reading
- Valencia Plaza (local business news)
- El Referente (Spanish startup news)
- EU-Startups (European coverage)
