# Valencia Skill — Setup Guide

## First-Time Setup

This skill helps you navigate Valencia for any purpose: visiting, moving, working, studying, or starting a business.

### Step 1: Initialize Your Profile

Create your Valencia knowledge base:

```
~/valencia/
├── profile.md          # Your situation and goals
├── progress.md         # What you've accomplished
├── bookmarks.md        # Saved places and resources
└── notes.md            # Personal observations
```

### Step 2: Define Your Context

Copy `memory-template.md` to `~/valencia/profile.md` and fill in:

1. **Your role**: Visitor, potential resident, new resident, established resident
2. **Your timeline**: When arriving, how long staying
3. **Your situation**: EU/non-EU, visa status, employment type
4. **Your priorities**: What matters most (cost, location, lifestyle)

### Step 3: Choose Your Path

Based on your role, start with the most relevant files:

| Role | Start With |
|------|------------|
| Tourist | `visitor-attractions.md`, `visitor-itineraries.md` |
| Planning to move | `visas.md`, `cost.md`, `neighborhoods-choosing.md` |
| Recently arrived | `resident.md`, `local.md`, `neighborhoods-index.md` |
| Working remotely | `visas.md` (Digital Nomad), `startup.md`, `lifestyle.md` |
| Starting business | `business.md`, `startup.md`, `visas.md` |
| Student | `education.md`, `neighborhoods-residential.md`, `cost.md` |
| With family | `education.md`, `healthcare.md`, `neighborhoods-residential.md` |

---

## Using This Skill

### Finding Information

**Quick Reference**: Start with `SKILL.md` — it has the file index organized by topic.

**Deep Dive**: Each auxiliary file covers its topic comprehensively with:
- Overview and key points
- Detailed sections with tables
- Practical tips
- Cost information where relevant

### Asking Questions

Be specific about your situation:

✅ Good: "I'm a US digital nomad earning $5k/month, want to live near the beach but be able to walk to cafes. What neighborhood?"

❌ Vague: "Where should I live in Valencia?"

### Tracking Progress

Update `~/valencia/progress.md` as you complete steps:

```markdown
## Completed
- [x] Got NIE (2024-03-15)
- [x] Found apartment in Ruzafa (2024-03-20)
- [x] Empadronamiento done (2024-03-25)

## In Progress
- [ ] Opening Spanish bank account
- [ ] Registering for healthcare

## Next Steps
- [ ] Find gym
- [ ] Join language exchange
```

---

## Topic Quick Reference

### Visiting
| Topic | File |
|-------|------|
| What to see | `visitor-attractions.md` |
| Day plans | `visitor-itineraries.md` |
| Where to stay | `visitor-lodging.md` |
| Practical tips | `visitor-tips.md` |

### Moving
| Topic | File |
|-------|------|
| Visa options | `visas.md` |
| Move-in process | `resident.md` |
| Living costs | `cost.md` |
| Banking, SIM, etc. | `local.md` |

### Working
| Topic | File |
|-------|------|
| Tech jobs | `tech.md` |
| Starting business | `business.md` |
| Startup ecosystem | `startup.md` |
| Coworking | `lifestyle.md` |

### Living
| Topic | File |
|-------|------|
| Neighborhoods | `neighborhoods-*.md` |
| Getting around | `transport.md` |
| Food scene | `food-*.md` |
| Safety | `safety.md` |
| Weather | `climate.md` |
| Culture | `culture.md` |

### Family
| Topic | File |
|-------|------|
| Schools | `education.md` |
| Healthcare | `healthcare.md` |
| Family life | `lifestyle.md` |
| Driving | `driving.md` |

---

## Updates

Valencia changes — here's how to stay current:

### What Changes Frequently
- Rent prices (update annually)
- Visa rules (check official sources)
- Restaurant recommendations (your mileage varies)
- Event dates (check annually)

### What's Stable
- Neighborhood character
- Climate patterns
- Cultural customs
- Government processes (slow to change)

### Verifying Information
- Visa rules: exteriores.gob.es (official)
- Rent prices: idealista.com
- Events: visitvalencia.com
- Transit: metrovalencia.es

---

## Getting Help

### Official Resources
| Resource | Website |
|----------|---------|
| City services | valencia.es |
| Tourism | visitvalencia.com |
| Immigration | extranjeros.inclusion.gob.es |
| Transit | metrovalencia.es |

### Community Resources
| Resource | Platform |
|----------|----------|
| Expat groups | Facebook |
| Local events | Meetup.com |
| Questions | Reddit r/valencia |
| Networking | InterNations |

---

## Feedback

If this skill helped you navigate Valencia, let others know:

```
clawhub star valencia
```

Found something outdated or wrong? Report it so it can be fixed.
