# Safety & Laws in Valencia

## Overview

Valencia is one of the safest large cities in Spain and Europe. Normal precautions apply, but violent crime is rare and most areas are safe at all hours.

### Safety Stats
- Crime rate: Lower than Barcelona, similar to Madrid
- Violent crime: Very rare
- Property crime: Pickpocketing exists but manageable
- Night safety: Generally excellent

---

## Personal Safety

### Day-to-Day
- **Walking alone**: Safe in all main areas
- **Public transport**: Safe, well-lit, cameras
- **Parks**: Safe during day, use judgment at night
- **Beach**: Safe, watch belongings while swimming

### At Night
- **El Carmen**: Busy until 4am, safe due to crowds
- **Ruzafa**: Safe, well-trafficked
- **Centro**: Safe, some quieter streets after midnight
- **Beach areas**: Safe but darker, use taxi late night
- **Suburbs**: Safe but can feel deserted

### Areas to Be Aware Of
Valencia has no true "no-go" areas, but some zones require more awareness:
- **Some parts of El Cabanyal** (improving rapidly)
- **Orriols** (further from center, less relevant)
- **Industrial zones** (not residential anyway)

None of these are dangerous in the traditional sense — just less polished.

---

## Property Crime

### Pickpocketing
**Where it happens:**
- Mercado Central (crowded)
- Metro during rush hour
- Tourist attractions
- Fallas (massive crowds)

**Prevention:**
- Use front pockets or crossbody bag
- Don't flash valuables
- Be aware in crowds
- Use hotel safe for passports

### Theft from Vehicles
- Don't leave anything visible in cars
- Rental cars sometimes targeted (tourist items)
- Use parking garages over street parking

### Apartment Break-ins
- Rare in residential areas
- Ground floor apartments slightly higher risk
- Use locks, don't leave windows open when out

---

## Beach Safety

### Swimming
- Lifeguards in summer (flag zones)
- Strong currents occasional (respect flags)
- Red flag = no swimming
- Don't swim drunk

### Belongings
- Don't leave valuables unattended
- Bring only what you need
- Take turns watching things
- Locker services at some beaches

### Sun Safety
- SPF even on cloudy days
- Hydrate constantly
- Shade at midday (12:00-16:00)
- Heat exhaustion is real

---

## Scams

Valencia has fewer scams than Barcelona or Madrid, but stay alert:

### Known Scams
- **Fake petitions**: Clipboard people asking for signatures, then money
- **Street games** (three-card monte): Always rigged, don't play
- **Friendship bracelets**: Tie on bracelet, demand payment
- **Rose sellers**: Aggressive selling in restaurants

### Taxi/Ride-Share
- Metered taxis: Reliable, regulated
- Airport fixed fare: €20 (don't pay more)
- Use official stands or apps

### Rental Scams
- Never pay before seeing apartment
- Verify landlord owns property
- Use established platforms (Idealista)
- If too good to be true, it is

---

## Legal Awareness

### Key Spanish Laws

**Alcohol**
| Rule | Details |
|------|---------|
| Drinking age | 18 |
| Public drinking | Technically prohibited (botellón laws) |
| Enforcement | Varies; parks/beaches often tolerated |
| Drunk and disorderly | Can be fined |

**Drugs**
| Rule | Details |
|------|---------|
| Cannabis | Illegal to sell/buy; personal use tolerated |
| Cannabis clubs | Gray area; private membership |
| Hard drugs | Illegal, penalties vary |
| Possession | Can result in fines or arrest |

**Driving**
| Rule | Details |
|------|---------|
| Blood alcohol | 0.5 g/L (0.3 for new drivers) |
| Phone use | Illegal while driving |
| Speed cameras | Everywhere |
| Parking fines | Enforced strictly |

**Other**
| Topic | Rule |
|-------|------|
| ID | Must carry (passport or NIE) |
| Photography | People require consent |
| Public nudity | Beaches often tolerated, elsewhere fined |
| Noise | Laws exist; 23:00-08:00 quiet hours |

---

## LGBTQ+ Safety

Valencia is LGBTQ+ friendly:
- **Legal**: Same-sex marriage legal since 2005
- **Social acceptance**: High, especially in cities
- **Pride**: Major annual event in June
- **Scene**: Ruzafa has LGBTQ+ friendly bars
- **Violence**: Hate crimes rare but not zero

### Practical Tips
- Public affection: Generally safe
- Ruzafa/El Carmen: Most welcoming
- Rural areas: More conservative
- Overall: One of Spain's most accepting cities

---

## Women's Safety

Valencia is safe for women:
- Solo travel: Common and safe
- Night transport: Metro until 23:30, taxis safe
- Harassment: Less common than many cities
- Cat-calling: Occasional but not pervasive

### Tips
- Trust instincts (same as anywhere)
- Night buses and taxis available
- El Carmen at night: Crowded, safe
- Beach at night: Use caution if alone

---

## Emergency Services

### Numbers
| Service | Number |
|---------|--------|
| All emergencies | 112 |
| Police (National) | 091 |
| Police (Local) | 092 |
| Ambulance | 112 |
| Fire | 080 |

### Hospitals
- **Hospital La Fe**: Major public hospital
- **Hospital General**: Central public hospital
- **Hospital Quirónsalud**: Private

### Police Stations
- **Policía Nacional**: NIE, crime reports
- **Policía Local**: Local issues, traffic
- **Tourist Police**: Plaza de la Reina (multilingual)

### Reporting Crime
1. Call 112 for emergencies
2. Go to police station for non-emergency
3. Request "denuncia" (official report)
4. Need for insurance claims

---

## Natural Hazards

### Gota Fría (Flash Floods)
- **When**: September-October mainly
- **What**: Intense Mediterranean storms
- **Risk**: Flash flooding, especially in low areas
- **What to do**: Stay indoors, don't drive through water

### Heat Waves
- **When**: July-August
- **Risk**: Heat exhaustion, dehydration
- **What to do**: Stay hydrated, avoid midday sun

### Earthquakes
- Minor tremors occasionally
- No major earthquake risk
- Buildings are seismically aware

### Forest Fires
- Risk in surrounding areas (not city)
- Follow local alerts if traveling to countryside

---

## Health Emergencies

### What to Do
1. **Emergency**: Call 112
2. **Non-emergency**: Centro de Salud (walk-in)
3. **Night/weekend**: Urgencias (ER)
4. **Pharmacy**: Green cross, many open late

### Pharmacies
- **Farmacia de guardia**: 24h rotating duty
- Find via: 112 or pharmacy signs
- Can help with minor issues

### EU Citizens
- EHIC card for immediate treatment
- Register for SIP card for long-term

### Non-EU Citizens
- Travel insurance essential
- Private hospitals accept most insurance
- Can still access public ER (may bill later)

---

## Documents

### What to Carry
- ID (passport or NIE) — required by law
- Health card (SIP) if registered
- Phone with emergency contacts
- Basic cash

### What to Store Safely
- Original passport (carry copy)
- Visa documents
- Large amounts of cash
- Expensive jewelry

### Lost Documents
1. Report to police (denuncia)
2. Contact embassy (if passport)
3. Get replacement documents
4. Update any affected accounts

---

## Practical Safety Tips

1. **Be aware, not paranoid** — Valencia is safe
2. **Carry less** — Don't need valuables everywhere
3. **Use common sense** — Same as any city
4. **Know emergency number** — 112
5. **Learn basic Spanish** — Helps in emergencies
6. **Trust official transport** — Taxis, metro are safe
7. **Keep copies** — Photos of documents on phone
8. **Insurance** — Health and travel insurance
9. **Share location** — With someone when alone
10. **Trust your instincts** — If something feels off, leave
