# Moving to Valencia — Resident Guide

## Overview

Moving to Valencia is relatively straightforward for EU citizens and increasingly accessible for non-EU with the new Digital Nomad Visa. This guide covers the practical steps.

---

## EU Citizens

### The Easy Path
EU citizens can:
- Move without visa
- Work immediately (no permit needed)
- Register and get NIE quickly
- Access public healthcare after registration
- Bring non-EU family members

### Step-by-Step Process

**Week 1-2: Arrive and Settle**
1. Find temporary accommodation (Airbnb, hostel)
2. Get local SIM card
3. Open bank account (some accept passport only)
4. Start apartment hunting

**Week 2-4: Get Your NIE**
1. **NIE (Número de Identidad de Extranjero)**
   - Needed for: bank account, work, contracts, everything
   - Apply at: Oficina de Extranjería or Police station
   - Documents: Passport, completed EX-15 form, payment (€12)
   - Processing: Same day to 2 weeks
   - Book appointment: sede.administracionespublicas.gob.es

**Week 3-6: Register Residence**
1. **Empadronamiento (City Registration)**
   - Where: Your local Ayuntamiento office
   - Documents: Passport, rental contract, landlord authorization
   - Cost: Free
   - Processing: Same day
   - Required for: Healthcare, voting, residency

2. **Residencia (EU Registration Certificate)**
   - After 3 months if staying
   - Documents: Passport, employment or sufficient funds proof
   - Gets you the "green card" (certificado de registro)

### Timeline Summary
| Step | When | Priority |
|------|------|----------|
| Arrive | Day 1 | - |
| Bank account | Week 1 | High |
| NIE application | Week 1-2 | Critical |
| Apartment | Week 1-4 | High |
| Empadronamiento | After apartment | Critical |
| EU residency certificate | After 3 months | Required |

---

## Non-EU Citizens

### Visa Options

| Visa Type | For | Duration | Work Allowed |
|-----------|-----|----------|--------------|
| Tourist | Visiting | 90 days | No |
| Digital Nomad | Remote workers | Up to 5 years | Remote only |
| Non-lucrative | Retirees/wealthy | 1 year, renewable | No |
| Autónomo | Self-employed | 1 year, renewable | Yes |
| Work visa | Employed | 1-2 years | Yes |
| Student | Studying | 1 year | 20h/week |

See `visas.md` for detailed requirements.

### General Process
1. Apply for visa in home country (consulate)
2. Arrive in Spain
3. Apply for TIE (foreigner ID card) within 30 days
4. Complete empadronamiento
5. Register with Social Security if working

---

## Finding an Apartment

### Where to Search
| Platform | Notes |
|----------|-------|
| Idealista | Largest, most listings |
| Fotocasa | Good secondary option |
| Pisos.com | Third option |
| Spotahome | Verified, easier for foreigners |
| Facebook groups | "Pisos en Valencia" |

### What You'll Need
- NIE or passport
- Proof of income (work contract, bank statements)
- 2-4 months rent upfront (first + deposit + agency)
- References (sometimes)

### Red Flags
- No in-person viewing offered
- Deposit over 2 months (illegal)
- Cash-only requests
- No proper contract
- Prices too good to be true

### Average Timeline
- 2-4 weeks to find apartment
- Start looking before arrival if possible
- Peak season: September (contract renewals)
- Easier: Winter months

### Contract Tips
- Minimum 5-year contracts for individuals
- "Temporal" contracts exist but less protection
- Get everything in writing
- Review with a lawyer if unsure (gestoría)

---

## Opening a Bank Account

### Easy Options (Digital)
| Bank | NIE Required | Notes |
|------|--------------|-------|
| N26 | No (passport OK) | German bank, app-based |
| Revolut | No | UK-based, useful for transfers |
| Wise | No | Multi-currency, not full bank |
| Vivid | No | German, easy setup |

### Traditional Spanish Banks
| Bank | NIE Required | Notes |
|------|--------------|-------|
| Sabadell | Yes | Foreigner-friendly |
| CaixaBank | Yes | Large network |
| BBVA | Yes | Tech-forward |
| Santander | Yes | Large, bureaucratic |

### What You'll Need
- Passport
- NIE (for Spanish banks)
- Proof of address (empadronamiento)
- Proof of income
- Tax residency declaration

### Recommendation
1. Open N26/Revolut immediately (works with passport)
2. Open Spanish bank after NIE (needed for some services)
3. Use Wise for international transfers

---

## Healthcare Registration

### Public Healthcare (EU Citizens)
1. Get empadronamiento first
2. Register at local Centro de Salud
3. Bring: passport, NIE, empadronamiento
4. Get SIP card (health card)
5. Access to doctors, specialists, hospitals

### Public Healthcare (Non-EU)
- If working: Covered through Social Security
- If Digital Nomad visa: Private insurance required initially
- After 1 year: Can access public system

### Private Healthcare
- Cost: €50-150/month
- Faster access, English-speaking doctors
- Providers: Sanitas, Adeslas, DKV

See `healthcare.md` for details.

---

## Social Security (If Working)

### Registration Process
1. Employer registers you (if employed)
2. Self-employed: Register as autónomo
3. Get Social Security number
4. Contributions deducted from salary

### What It Covers
- Healthcare
- Pension
- Unemployment insurance
- Maternity/paternity leave
- Disability

### Self-Employed (Autónomo)
- Minimum: ~€300/month first year
- Gradual increase over 3 years
- See `business.md` for details

---

## Tax Residency

### You Become Tax Resident If:
- Stay 183+ days per year in Spain
- Primary center of economic interests
- Spouse/children live in Spain

### What It Means
- Pay Spanish tax on worldwide income
- Must file annual tax return (IRPF)
- Beckham Law may apply (see `visas.md`)

### Tax Filing
- Deadline: June 30
- Online via Agencia Tributaria
- Consider hiring a gestor first year

---

## Setting Up Services

### Internet
| Provider | Speed | Price |
|----------|-------|-------|
| Movistar | 600Mbps | €45-60 |
| Orange | 600Mbps | €40-55 |
| Vodafone | 600Mbps | €45-55 |
| Digi | 500Mbps | €25-35 |
| MásMóvil | 600Mbps | €30-40 |

**Tip**: Digi and MásMóvil are cheapest, quality is good.

### Mobile Phone
| Provider | Plan | Price |
|----------|------|-------|
| Orange | 15GB | €15 |
| Vodafone | 20GB | €20 |
| Digi | 20GB | €10 |
| Lycamobile | 10GB | €10 |

### Utilities
- Already set up? Just change name
- New connection? Takes 1-2 weeks
- Companies: Iberdrola, Naturgy, Endesa

---

## Practical First Month Checklist

### Week 1
- [ ] Get SIM card
- [ ] Open digital bank account (N26/Revolut)
- [ ] Start apartment search
- [ ] Book NIE appointment

### Week 2
- [ ] NIE appointment
- [ ] Continue apartment search
- [ ] Explore neighborhoods

### Week 3
- [ ] Sign apartment contract
- [ ] Set up utilities
- [ ] Get internet

### Week 4
- [ ] Empadronamiento
- [ ] Open Spanish bank account
- [ ] Register for healthcare
- [ ] Get to know your neighborhood

---

## Useful Contacts

### Government
- **Policía Nacional** (NIE): cita-previa.mjusticia.gob.es
- **Agencia Tributaria**: agenciatributaria.es
- **Social Security**: seg-social.es
- **Ayuntamiento Valencia**: valencia.es

### Emergency
- **Emergency**: 112
- **Police**: 091
- **Medical**: 112

### Expat Resources
- Facebook: "Expats in Valencia"
- InterNations Valencia
- Reddit: r/valencia
- Meetup.com groups

---

## Common Mistakes

1. **Not booking NIE appointment early** — Can be weeks of wait
2. **Expecting US-speed bureaucracy** — Spain is slower, accept it
3. **Not getting empadronamiento** — Needed for everything
4. **Skipping Spanish bank** — Some services require it
5. **Ignoring gestoría** — Worth hiring for first year
6. **August apartment hunting** — Everyone's on vacation
7. **Not learning basic Spanish** — Makes everything harder
