# Ruzafa & Eixample — Valencia's Trendy Core

## Ruzafa (Russafa)

### Character
Valencia's hippest neighborhood. Once working-class, now the epicenter of brunch culture, craft cocktails, vintage shops, and creative professionals. The Brooklyn/Kreuzberg of Valencia.

### Living Here

**Pros**:
- Best food and coffee scene in Valencia
- Young, international community
- Walkable to Centro (10 min)
- Great nightlife without El Carmen noise
- Mercado de Ruzafa (local, authentic)
- Metro well-connected

**Cons**:
- Gentrified — prices rising
- Can feel "too cool for school"
- Some streets noisy on weekends
- High demand, hard to find apartments

### Rental Market

| Type | Price Range |
|------|-------------|
| Room in shared flat | €400-550/month |
| Studio | €750-950/month |
| 1BR apartment | €900-1,300/month |
| 2BR apartment | €1,200-1,700/month |

**Market reality**: Apartments go fast. Be ready to decide quickly.

### Best Streets
- **Calle Literato Azorín**: Restaurant row
- **Calle Sueca**: Mix of shops and bars
- **Calle Cuba / Calle Puerto Rico**: More residential, quieter
- **Around Mercado de Ruzafa**: Local feel, good value

### Food Scene

**Brunch**:
- Federal — Australian vibes, packed weekends
- Bluebell Coffee — Best coffee in Valencia
- Copenhagen — Scandinavian, avocado toast
- La Fábrica — Industrial chic

**Dinner**:
- La Salvaora — Modern Valencian
- Canalla Bistro — Ricard Camarena's casual spot
- Ma Khin — Thai, excellent
- Navarro — Traditional, old-school

**Drinks**:
- Olhöps — Craft beer heaven
- Slaughterhouse — Cocktails
- Ubik Café — Books + drinks

### Nightlife
Less wild than El Carmen, more cocktail bars and late-night dining than clubs.

**Noise level**: Moderate — busy weekend nights but not El Carmen crazy

### Demographics
- 25-45 year olds dominant
- Many remote workers and digital nomads
- International mix: Spanish, European, some Latin American
- LGBTQ+ friendly

### Verdict
Best for: Professionals, foodies, creatives, anyone wanting cool without chaos
Avoid if: Tight budget or dislike gentrified areas

---

## Eixample

### Character
Valencia's 19th-century expansion grid. Wide boulevards, modernista buildings, bourgeois elegance. Connects Ruzafa to Centro.

### Sub-Areas

**Gran Vía / Colón**:
- Main shopping district
- Higher-end apartments
- Very central
- Less neighborhood feel

**Pla del Real**:
- Near Jardines del Real
- Residential, upscale
- Families and professionals
- University area edge

**General Eixample**:
- Mix of residential and commercial
- Good metro access
- Modernista architecture

### Living Here

**Pros**:
- Central without tourist chaos
- Beautiful architecture
- Excellent metro connections
- Good balance of price and location

**Cons**:
- Less character than Ruzafa/Carmen
- Can feel impersonal
- Traffic noise on main streets

### Rental Market

| Type | Price Range |
|------|-------------|
| 1BR apartment | €800-1,100/month |
| 2BR apartment | €1,000-1,400/month |

**Tip**: Better value than Ruzafa with similar accessibility.

### Best Areas
- **Near Mercado de Colón**: Beautiful, slightly pricier
- **Between Gran Vía and Ruzafa**: Best of both worlds
- **Near Jardines del Real**: Quiet, green, family-friendly

### Verdict
Best for: Those wanting central + practical without "scene"
Avoid if: You want strong neighborhood identity

---

## Comparison: Ruzafa vs Eixample

| Factor | Ruzafa | Eixample |
|--------|--------|----------|
| Vibe | Trendy, creative | Classic, practical |
| Rent | €900-1,300 | €800-1,100 |
| Food scene | ★★★★★ | ★★★☆☆ |
| Nightlife | ★★★★☆ | ★★☆☆☆ |
| Family-friendly | ★★☆☆☆ | ★★★★☆ |
| Architecture | Interesting | Beautiful |
| Noise | Moderate | Lower |
| Metro | ★★★★☆ | ★★★★★ |

---

## Practical Info

### Transport
- **Metro**: Bailén, Amistat (L5, L7), Colón (L3, L5, L9)
- **Valenbisi**: Abundant stations
- **Walking**: 10 min to Centro

### Supermarkets
- Mercadona on Calle Sueca
- Consum multiple locations
- Mercado de Ruzafa (produce, local)

### Coworking
- Wayco Ruzafa — best in the area
- Impact Hub (nearby)
- Many cafes tolerate laptop workers

### Healthcare
- Centro de Salud Ruzafa
- Multiple pharmacies

### Schools
- Mostly primary schools, some in Eixample
- International schools require commute

---

## Digital Nomad Scene

Ruzafa is Valencia's digital nomad hub:
- **Cafes with good wifi**: Bluebell, Federal, Copenhagen, Dulce de Leche
- **Coworking**: Wayco, La Pinada Coworking
- **Community**: Regular meetups, Nomad List active
- **Visa-friendly**: Many on Digital Nomad Visa (see `visas.md`)

---

## Insider Tips

1. **Mercado de Ruzafa**: Go Saturday morning for local atmosphere
2. **Sunday rastro**: Small flea market near Mercado
3. **Living near Calle Sueca**: Noisier but most convenient
4. **Cuba/Puerto Rico streets**: Best residential quality
5. **Avoid ground floor**: Street noise from bars
6. **Check afternoon sun**: Some streets get hot in summer
