# Valencia Neighborhoods — Quick Index

## Overview Map

Valencia divides roughly into:
- **Centro Histórico**: Medieval core (El Carmen, La Seu, Mercat)
- **Eixample**: 19th-century expansion (grid streets, Ruzafa, Gran Vía)
- **Poblats Marítims**: Beach areas (El Cabanyal, Malvarrosa)
- **Residential suburbs**: North, west, south expansions

---

## Quick Comparison

| Neighborhood | Vibe | Rent 1BR | Walk Score | Best For |
|--------------|------|----------|------------|----------|
| El Carmen | Historic, nightlife | €900-1,200 | ★★★★★ | Young singles, culture |
| Ruzafa | Hipster, foodie | €900-1,300 | ★★★★★ | Professionals, foodies |
| Eixample | Classic, central | €800-1,100 | ★★★★☆ | Professionals, families |
| El Cabanyal | Beach, gentrifying | €700-1,000 | ★★★☆☆ | Beach lovers, artists |
| Malvarrosa | Beach, residential | €700-950 | ★★★☆☆ | Families, beach life |
| Benimaclet | Student, bohemian | €600-900 | ★★★★☆ | Students, budget |
| Campanar | Residential, quiet | €700-1,000 | ★★★☆☆ | Families |
| Patraix | Working-class, cheap | €550-800 | ★★★☆☆ | Budget, local |
| Quatre Carreres | Modern, CAC area | €750-1,000 | ★★☆☆☆ | Tech workers, families |

---

## By Profile

### Young Professionals
1. **Ruzafa** — Best food/nightlife, walkable
2. **El Carmen** — Historic charm, most central
3. **Eixample** — Balance of price and location

### Families
1. **Campanar** — Parks, schools, quiet
2. **Benimaclet** — Community feel, markets
3. **Patraix** — Affordable, authentic

### Students
1. **Benimaclet** — Near universities, cheap
2. **Blasco Ibáñez** — Campus-adjacent
3. **La Saïdia** — Budget option

### Beach Lovers
1. **El Cabanyal** — Trendy, walking distance to sand
2. **Malvarrosa** — Beachfront but residential
3. **Patacona** — Just north, quieter

### Budget Seekers
1. **Patraix** — Cheapest central area
2. **Benimaclet** — Student prices
3. **La Saïdia** — Overlooked, good value

### Digital Nomads
1. **Ruzafa** — Cafes, coworking, social
2. **El Carmen** — Atmosphere, walkable
3. **El Cabanyal** — Beach + creative scene

---

## Distance from Centro Histórico

| Neighborhood | By Metro | By Bike | By Walk |
|--------------|----------|---------|---------|
| Ruzafa | 5 min | 5 min | 10 min |
| Eixample | 5 min | 5 min | 10 min |
| El Cabanyal | 15 min | 15 min | 30 min |
| Malvarrosa | 20 min | 20 min | 40 min |
| Benimaclet | 10 min | 15 min | 25 min |
| Campanar | 12 min | 15 min | 30 min |
| Patraix | 10 min | 12 min | 25 min |
| Quatre Carreres | 12 min | 15 min | 35 min |

---

## Metro Coverage

**Lines through Centro**: 3, 5, 7, 9
**Well-connected**: Ruzafa, Eixample, Benimaclet, CAC area
**Less connected**: El Cabanyal (tram), western suburbs

---

## Rental Market (Feb 2026)

### Most Competitive (Hard to Find)
1. Ruzafa — High demand, low turnover
2. El Carmen — Limited stock, tourist apartments
3. El Cabanyal — Gentrifying, limited quality stock

### Easier to Find
1. Patraix — More availability
2. Campanar — Family-oriented, stable
3. Outskirts — Plenty of options

### Red Flags
- Idealista listings without photos
- "Habitación" when you want full apartment
- Deposits over 2 months (legal max is 2)
- No contract offered

---

## Neighborhood Files

| Area | File | Coverage |
|------|------|----------|
| Centro Histórico | `neighborhoods-centro.md` | El Carmen, La Seu, Mercat, Velluters |
| Ruzafa & Eixample | `neighborhoods-ruzafa.md` | Ruzafa, Gran Vía, Pla del Real |
| Beach Areas | `neighborhoods-beach.md` | El Cabanyal, Malvarrosa, Patacona |
| Residential | `neighborhoods-residential.md` | Benimaclet, Campanar, Patraix, others |
| Choosing Guide | `neighborhoods-choosing.md` | Decision framework |
