# Local Services Guide — Valencia

## Banking

### Opening a Bank Account

**Digital Banks (Easy)**
| Bank | NIE Required | Cards | Notes |
|------|--------------|-------|-------|
| N26 | No | Yes | German, app-only |
| Revolut | No | Yes | UK, multi-currency |
| Wise | No | Yes | Great for transfers |
| Vivid | No | Yes | German |

**Spanish Banks**
| Bank | NIE Required | Network | Notes |
|------|--------------|---------|-------|
| CaixaBank | Yes | Largest | Most ATMs |
| Sabadell | Yes | Large | Foreigner-friendly |
| BBVA | Yes | Large | Good app |
| Santander | Yes | Large | Bureaucratic |
| ING | Yes | Limited | No monthly fees |

### Documents Needed
- Passport
- NIE (for Spanish banks)
- Proof of address (empadronamiento)
- Proof of income (contract, bank statements)
- Tax residency declaration

### Fees
- Most Spanish banks: €0-8/month
- ATM: Free at own bank, €1-3 otherwise
- International transfers: Use Wise (much cheaper)

### ATMs
- Abundant throughout city
- CaixaBank ATMs everywhere
- Use bank ATMs, avoid standalone machines
- Withdraw at your own bank's ATMs for free

---

## Phone & Internet

### Mobile Plans

**Major Providers**
| Provider | 15GB Plan | Network |
|----------|-----------|---------|
| Movistar | €25 | Own |
| Orange | €20 | Own |
| Vodafone | €25 | Own |

**Budget MVNOs**
| Provider | 20GB Plan | Network |
|----------|-----------|---------|
| Digi | €10 | Movistar |
| Pepephone | €15 | Yoigo |
| Lowi | €12 | Vodafone |
| MásMóvil | €15 | Own |

### Getting a SIM
- **Where**: Phone shops, supermarkets, airports
- **Documents**: Passport or NIE
- **Types**: Prepaid or contract
- **Prepaid**: Easy, no commitment
- **Contract**: Better deals, requires NIE

### Home Internet
| Provider | Speed | Price |
|----------|-------|-------|
| Movistar | 600Mbps | €45-60 |
| Orange | 600Mbps | €40-55 |
| Vodafone | 600Mbps | €45-55 |
| Digi | 500Mbps | €25-35 |
| MásMóvil | 600Mbps | €30-40 |

**Installation**: 1-2 weeks typically
**Best value**: Digi or MásMóvil

---

## Postal Services

### Correos (National Post)
- **Locations**: Throughout city
- **Hours**: 08:30-14:30 (some until 20:30)
- **Services**: Mail, packages, banking

### Sending Mail
| Type | Domestic | EU | International |
|------|----------|-------|---------------|
| Letter | €0.75 | €1.65 | €2.20 |
| Package 1kg | €5-10 | €15-20 | €25-40 |

### Receiving Packages
- **Home delivery**: Works well
- **Correos pickup**: If not home
- **Amazon lockers**: Throughout city
- **International**: DHL, FedEx, UPS available

---

## Legal Help (Gestoría)

### What is a Gestoría?
An administrative agent who handles bureaucracy:
- Tax filings
- Visa paperwork
- Business registration
- NIE/empadronamiento assistance
- Contract reviews

### When to Use
- First year in Spain
- Starting a business
- Complex visa situation
- Tax issues
- Don't speak Spanish well

### Cost
- Simple task: €50-100
- Tax filing: €100-200
- Business setup: €300-500
- Ongoing: €50-100/month

### Finding One
- Ask expat community
- Google "gestoría Valencia"
- Get recommendations
- English-speaking available

---

## Healthcare Registration

### Getting Your SIP Card

**EU Citizens:**
1. Complete empadronamiento
2. Go to Centro de Salud (nearest to home)
3. Bring: passport, NIE, empadronamiento
4. Register
5. Receive SIP card (1-2 weeks)

**Non-EU Working:**
1. Social Security registration (via employer)
2. Complete empadronamiento
3. Go to Centro de Salud
4. Same process

### Centros de Salud
- Primary care clinics
- Walk-in or appointment
- Assigned based on address
- Free with SIP card

### Hospitals
| Hospital | Type | Notes |
|----------|------|-------|
| Hospital La Fe | Public | Largest, all specialties |
| Hospital General | Public | Central |
| Hospital Clínico | Public | University hospital |
| Quirónsalud | Private | Multiple locations |
| Hospital 9 de Octubre | Private | Good reputation |

---

## Utilities

### Electricity
**Providers**: Iberdrola, Endesa, Naturgy, and many others

**Setup:**
- If existing contract: Change name (easy)
- New connection: 1-2 weeks

**Cost**: €40-100/month (depends on usage, AC)

### Gas
**Provider**: Naturgy (mainly)

**Setup**: Similar to electricity

**Cost**: €20-50/month

### Water
**Provider**: EMIVASA (city utility)

**Setup**: Through landlord usually

**Cost**: €20-40/month

### Changing Name on Utilities
1. Previous tenant's final reading
2. Your ID and rental contract
3. Contact provider (phone or online)
4. Some landlords keep utilities in their name

---

## Government Services

### Ayuntamiento (City Hall)
- **Main office**: Plaza del Ayuntamiento
- **Services**: Empadronamiento, permits, info
- **Appointments**: Often needed (online booking)
- **Website**: valencia.es

### Oficina de Extranjería
- **For**: NIE, residency permits
- **Location**: Various police stations
- **Appointments**: Essential (book early)
- **Website**: sede.administracionespublicas.gob.es

### Social Security
- **For**: Work registration, healthcare
- **Website**: sede.seg-social.gob.es
- **Appointments**: Book online

### Tax Office (Agencia Tributaria)
- **For**: Tax filings, NIE sometimes
- **Location**: Several offices
- **Website**: agenciatributaria.es

---

## Shipping & Storage

### Shipping from Abroad
| Service | Speed | Cost (10kg) |
|---------|-------|-------------|
| National post | 1-3 weeks | €50-100 |
| DHL | 3-5 days | €80-150 |
| FedEx | 3-5 days | €80-150 |
| Sendiroo | Varies | Compare prices |

### Customs
- EU: No customs
- Non-EU: VAT (21%) on imports over €150
- Declare high-value items

### Storage
- Trasteros (storage units): €50-150/month
- Bluespace, OhMyBox, Homebox

---

## Laundry

### Options
- **Washing machine**: Most apartments have one
- **Lavanderías**: Self-service, €5-8 per load
- **Dry cleaning**: Tintorerías, €5-15 per item
- **Pick-up services**: Mr Jeff app

---

## Vehicle Registration

### Bringing a Car
- EU: Re-register within 60 days
- Non-EU: Import taxes apply
- Process: ITV inspection, registration (gestoría recommended)

### Buying a Car
- New: Dealerships throughout
- Used: Wallapop, Milanuncios, dealers
- Documents: NIE required
- Insurance: Mandatory (€300-600/year)

### Driving License
- EU: Valid in Spain
- Non-EU: Valid 6 months, then convert
- Some nationalities: Direct exchange
- Others: Must take Spanish test

---

## Pets

### Moving with Pets
- EU Pet Passport (dogs, cats, ferrets)
- Microchip required
- Rabies vaccination
- Check airline policies

### Vet Services
- Many clinics throughout city
- 24h emergency: Hospital Veterinario Valencia
- Registration: Optional chip registry

### Pet-Friendly Rentals
- Many apartments allow pets
- Deposit may increase
- Specify in rental search

---

## Expat Resources

### Communities
- **Facebook**: "Expats in Valencia", "Valencia Digital Nomads"
- **InterNations**: Regular events
- **Meetup**: Various interest groups
- **Reddit**: r/valencia

### Language Exchange
- Intercambio events at bars
- Apps: Tandem, HelloTalk
- Language schools

### Coworking
| Space | Location | Price |
|-------|----------|-------|
| Wayco | Multiple | €150-250/month |
| La Pinada | Ruzafa | €150-200/month |
| Impact Hub | Ruzafa | €200-300/month |
| Lanzadera | Marina | Free (startups) |

---

## Useful Websites

| Service | Website |
|---------|---------|
| City services | valencia.es |
| Police appointments | sede.administracionespublicas.gob.es |
| Tax office | agenciatributaria.es |
| Social Security | seg-social.gob.es |
| Public transport | metrovalencia.es, emtvalencia.es |
| Apartments | idealista.com |
| Events | lovingvalencia.com |
