# Valencia Healthcare Guide

## Overview

Spain has excellent healthcare — ranked among the best in the world. Valencia offers both public (free/low-cost) and private options.

---

## Public Healthcare (Sistema Nacional de Salud)

### Who Can Access

**Automatically covered**:
- Spanish citizens
- Legal residents with Social Security contributions
- EU citizens with EHIC (temporary) or registered residence

**Process for coverage**:
1. Get empadronamiento (city registration)
2. Register at local Centro de Salud
3. Receive SIP card (Valencian health card)

### How It Works

**Centro de Salud (Health Center)**:
- Primary care
- Your assigned doctor (médico de cabecera)
- Walk-in or appointment
- Referrals to specialists

**Hospitals**:
- For emergencies, specialists, procedures
- Referral from Centro de Salud
- Or direct to Urgencias (ER) if emergency

### Quality
- Generally excellent
- Modern facilities
- Well-trained doctors
- Can be crowded
- Wait times for non-urgent specialists

### Wait Times
| Service | Typical Wait |
|---------|--------------|
| Primary care | Same day - 3 days |
| Specialist (non-urgent) | 1-6 months |
| Specialist (urgent) | Days - 2 weeks |
| Surgery (non-urgent) | Months - 1 year |
| Emergency | By triage priority |

---

## Getting Your SIP Card

### Process

**EU Citizens:**
1. Complete empadronamiento
2. Visit Centro de Salud with:
   - Passport/ID
   - NIE
   - Empadronamiento certificate
3. Register
4. Receive SIP card (1-2 weeks)

**Non-EU with Work/Residency:**
1. Social Security registration (through employer)
2. Complete empadronamiento
3. Same Centro de Salud process

**Non-EU Digital Nomads:**
- First year: Private insurance required
- After 1 year contributing: May access public system

### Your Centro de Salud
- Assigned based on address
- Find yours: gva.es (Valencian health service)
- Can request specific doctor (if available)

---

## Private Healthcare

### Why Choose Private

**Advantages**:
- Shorter wait times
- Choose your doctor
- English-speaking doctors easier to find
- Private rooms
- More appointment flexibility

**Disadvantages**:
- Monthly cost (€50-200)
- May duplicate public coverage
- Not always better quality
- Some procedures still sent to public

### Insurance Providers

| Provider | Monthly Cost | Notes |
|----------|--------------|-------|
| Sanitas | €50-150 | Largest, good network |
| Adeslas | €50-150 | Good coverage |
| DKV | €60-150 | International focus |
| Mapfre | €50-120 | Insurance company |
| Asisa | €40-100 | Budget option |
| Cigna | €80-200 | International plans |

### Choosing a Plan

**Consider**:
- Existing conditions (may be excluded)
- Copays vs full coverage
- Dental included?
- Mental health coverage
- Repatriation (for expats)
- English-speaking doctor network

**Tips**:
- Get quotes from multiple providers
- Read exclusions carefully
- Age affects price significantly
- Pre-existing conditions matter

---

## Hospitals in Valencia

### Public

| Hospital | Specialties | Location |
|----------|-------------|----------|
| Hospital La Fe | All, largest in region | Campanar |
| Hospital General | All, central | Centro |
| Hospital Clínico | University, research | Blasco Ibáñez |
| Hospital Doctor Peset | General | South |
| Hospital Arnau de Vilanova | General | North |

### Private

| Hospital | Notes |
|----------|-------|
| Quirónsalud Valencia | Large private network |
| Hospital 9 de Octubre | Good reputation |
| Hospital IMED | Modern facilities |
| Hospital Vithas Nisa | Multiple locations |

---

## Finding Doctors

### English-Speaking Doctors
- Private hospitals have more
- Ask your insurance for list
- Expat community recommendations
- Doctoralia.es (reviews, languages listed)

### Specialists
**Public**: Referral from médico de cabecera required
**Private**: Direct booking possible

### Dentists
- NOT covered by public healthcare
- Private: €30-60 for checkup
- Many dentists speak English
- Dental insurance: €10-30/month extra

### Mental Health
- Public: Available but long waits
- Private: Better access, English-speaking options
- Psychologists: €50-80/session
- Psychiatrists: €80-150/session

---

## Pharmacies

### Finding Pharmacies
- Green cross signs everywhere
- "Farmacia de guardia": 24h rotating duty pharmacy
- Check: farmaciasvalencia.com for nearest open

### What They Do
- Dispense prescriptions
- Advise on minor issues
- Sell OTC medication
- Some services (blood pressure, etc.)

### Prescriptions
- Public: Heavily subsidized (€1-4 per item)
- Private: May pay more depending on insurance
- Electronic prescriptions: Sent directly to any pharmacy

### OTC vs Prescription
- More available OTC than in some countries
- Pharmacists can advise
- Some antibiotics still need prescription

---

## Emergencies

### Emergency Numbers
| Service | Number |
|---------|--------|
| All emergencies | 112 |
| Ambulance | 112 |
| Poison control | 915 620 420 |

### Emergency Rooms (Urgencias)
- Available 24/7
- Triage system (sickest first)
- Can be long waits for non-urgent
- Public hospitals always accept

### When to Go to ER
- Life-threatening conditions
- Severe pain
- Accidents
- Sudden serious symptoms

### For Non-Urgent
- Centro de Salud (daytime)
- Punto de Atención Continuada (after hours)
- Private urgent care

---

## Prescriptions & Medications

### Getting Prescriptions
**Public**:
1. See doctor at Centro de Salud
2. Prescription sent electronically
3. Pick up at any pharmacy
4. Small copay (€1-4)

**Private**:
1. See private doctor
2. Get prescription
3. Pharmacy may charge more

### Common Medications
- Many medications similar to home
- Brand names may differ
- Pharmacist can help with equivalents
- Some things OTC here that aren't elsewhere

### Bringing Medications from Abroad
- Personal supply (3 months) usually fine
- Carry prescription/doctor letter
- Controlled substances: Check regulations

---

## Maternity Care

### Public System
- Free prenatal care
- Hospital delivery included
- Midwife-led options
- Generally excellent

### Private Options
- More birthing choices
- Private room guaranteed
- Higher cost (€3,000-8,000 delivery)
- Some use private prenatal + public delivery

### Paternity/Maternity Leave
- 16 weeks each parent (fully paid)
- Can be taken simultaneously or sequentially
- Very generous by international standards

---

## Vaccinations

### Routine Vaccinations
- Spanish vaccination schedule similar to EU/US
- Children vaccinated through public system
- Records: "cartilla de vacunación"

### Travel Vaccines
- Available at:
  - Centro de Vacunación Internacional
  - Some pharmacies
  - Private clinics

### COVID-19
- Vaccines available through public system
- Boosters offered regularly
- No current restrictions

---

## Health Tips for Valencia

### Climate-Related
- **Summer**: Heat exhaustion risk, hydrate constantly
- **Sun**: SPF essential year-round
- **Beach**: Lifeguards summer only, respect flags
- **Air quality**: Generally good, occasional Saharan dust

### Food & Water
- Tap water: Safe to drink
- Food safety: Good standards
- Allergies: Inform restaurants, "tengo alergia a..."

### Lifestyle
- Mediterranean diet: Healthy default
- Walking culture: Stay active
- Siesta: Rest is culturally supported
- Work-life balance: Good for stress

---

## Costs Summary

### Public Healthcare
| Service | Cost |
|---------|------|
| Doctor visit | Free |
| Hospital stay | Free |
| Prescriptions | €1-4 per item |
| Specialist | Free (with referral) |

### Private Healthcare
| Service | Cost |
|---------|------|
| Insurance | €50-200/month |
| Doctor visit (copay) | €0-20 |
| Specialist (copay) | €0-30 |
| Hospital (excess) | Varies |

### Without Insurance
| Service | Cost |
|---------|------|
| Private doctor visit | €50-100 |
| Specialist | €80-150 |
| ER (private) | €100-200 |

---

## Resources

| Resource | Contact |
|----------|---------|
| Emergency | 112 |
| Valencia Health Service | gva.es/sanitat |
| Find Centro de Salud | gva.es |
| Pharmacy finder | farmaciasvalencia.com |
| Doctoralia (reviews) | doctoralia.es |
