# Food Practical Guide — Valencia

## Opening Hours

### Standard Restaurant Hours
| Meal | Kitchen Opens | Kitchen Closes |
|------|---------------|----------------|
| Lunch | 13:30 | 15:30-16:00 |
| Dinner | 20:30-21:00 | 23:00-23:30 |

**Key insight**: Kitchens close between meals. Don't expect food at 17:00.

### What's Open When
| Time | Options |
|------|---------|
| 08:00-10:00 | Cafeterías, bakeries (desayuno) |
| 10:30-12:00 | Bars for almuerzo (bocadillos) |
| 12:00-13:30 | Vermouth hour, light tapas |
| 13:30-16:00 | Full lunch service |
| 16:00-20:00 | Coffee shops, some bars (merienda) |
| 20:30-23:30 | Dinner service |
| 23:30-03:00 | Late-night spots, kebabs |

### Day Closures
- **Sunday**: Many restaurants closed (especially dinner)
- **Monday**: Some restaurants closed
- **August**: Many close 2-3 weeks
- **Fallas (March)**: Most open, some close to escape chaos

---

## Reservations

### When to Book

| Restaurant Type | When to Book |
|-----------------|--------------|
| Casual tapas | Walk-in usually fine |
| Ruzafa trendy | Book Friday/Saturday dinner |
| Paella restaurants | Book 30-45 min before (cooking time) |
| Fine dining | 1-4 weeks ahead |
| Brunch spots | Book weekends or go early |

### How to Book
1. **Phone**: Traditional, always works
2. **TheFork / ElTenedor**: App with discounts
3. **Google Maps**: Many have booking links
4. **Direct website**: Fine dining
5. **Instagram DM**: Some trendy places

### Walk-In Strategy
- Arrive at 13:30 or 20:30 (opening)
- Weekday lunches almost always fine
- Solo/duo easier than groups
- Ask "¿Tienen mesa para dos?"

---

## Tipping Culture

### The Basics
- **Not obligatory** in Spain
- **No one will judge you** for not tipping
- **Servers earn living wages** (unlike US)

### What Locals Do
| Situation | Typical Tip |
|-----------|-------------|
| Coffee | Nothing |
| Casual tapas | Round up (€0.50-2) |
| Nice dinner | 5-10% if excellent |
| Fine dining | 10% for exceptional |

### How to Tip
- Cash on table when leaving
- "Quédese con el cambio" — Keep the change
- Can add to card but cash preferred

---

## Paying

### Accepted Payment
- **Cash**: Always accepted, some prefer it
- **Cards**: Widely accepted (Visa, Mastercard)
- **Contactless**: Common
- **Amex**: Less accepted than Visa/MC

### Getting the Bill
- "La cuenta, por favor" — The bill, please
- Servers won't bring it unsolicited (not rushing you)
- May need to ask 2-3 times in busy places

### Splitting Bills
- "Por separado, por favor" — Separately, please
- Many places will split, some won't for large groups
- Bizum (Spanish payment app) common among locals

---

## Dietary Requests

### Useful Phrases
| English | Spanish |
|---------|---------|
| I'm vegetarian | Soy vegetariano/a |
| I'm vegan | Soy vegano/a |
| I don't eat meat | No como carne |
| I don't eat fish | No como pescado |
| I'm allergic to... | Soy alérgico/a a... |
| Gluten-free | Sin gluten |
| Nuts | Frutos secos |
| Dairy | Lácteos |
| Does this have...? | ¿Esto tiene...? |

### Common Hidden Ingredients
- **Jamón**: In many vegetable dishes, soups
- **Fish stock**: In rice dishes (paella base)
- **Anchovies**: In sauces
- **Dairy**: In many sauces and desserts

### Celiac / Gluten-Free
- Rice dishes are naturally GF (confirm no flour in sofrito)
- "Sin gluten, por favor"
- Apps: Find Me Gluten Free
- Shops: Celicioso (GF bakery)

---

## Alcohol

### Legal Drinking
- **Age**: 18 years
- **Where**: Bars, restaurants, shops (for home)
- **Public drinking**: Technically restricted but rarely enforced in parks/beaches

### What to Drink
| Drink | When | Notes |
|-------|------|-------|
| Cerveza | Anytime | Amstel is local |
| Vino tinto/blanco | Meals | Local DOs good value |
| Vermouth | Pre-lunch (12:00-14:00) | Tradition |
| Agua de Valencia | Celebration | OJ + cava + spirits |
| Cava | Celebrations | Spanish sparkling |
| Tinto de verano | Summer | Red wine + lemon soda |
| Clara | Summer | Beer + lemon soda |

### Vermouth Culture
- Traditional pre-lunch ritual
- Served with olives, chips, small tapas
- Best places: Casa Montaña, traditional bodegas
- "Un vermut, por favor"

### Alcohol-Free
- "Sin alcohol, por favor"
- Cerveza sin alcohol available everywhere
- Tinto de verano con casera blanca (no alcohol, just soda)

---

## Ramadan Considerations

Valencia has a growing Muslim population.

### Finding Halal
- Kebab shops throughout (usually halal)
- Check: HalalTrip app
- Ask: "¿Es halal?"

### Iftar
- Some Middle Eastern restaurants accommodate
- Plan ahead for Ramadan dining

### General Tips
- Spain is not halal by default
- Pork is in MANY dishes (hidden too)
- Be explicit about requirements

---

## Markets

### Mercado Central
- **Hours**: Mon-Sat 07:30-14:30
- **Closed**: Sunday
- **What to buy**: Produce, ham, cheese, olives
- **Eating**: Multiple stalls inside

### Mercado de Ruzafa
- **Hours**: Mon-Sat 07:00-14:00
- **Best time**: Saturday morning
- **Vibe**: Local, not touristy

### Mercado de Colón
- **Hours**: 08:00-01:00 (bars)
- **Not a food market**: More restaurant/bar space
- **Good for**: Drinks, oysters, casual

### Supermarkets
| Chain | Notes |
|-------|-------|
| Mercadona | Best prices, everywhere |
| Consum | Quality focus, Co-op model |
| Carrefour | Large hypermarkets |
| Lidl | Budget, German |
| El Corte Inglés | Premium, Gourmet Experience |

### Supermarket Hours
- Most: 09:00-21:30
- Closed Sunday (most)
- Some small shops open Sunday morning

---

## Ordering Cheat Sheet

### Essential Phrases
| Spanish | English |
|---------|---------|
| Una mesa para dos | Table for two |
| La carta, por favor | Menu, please |
| ¿Qué recomienda? | What do you recommend? |
| Para compartir | To share |
| ¿Tienen menú del día? | Do you have daily menu? |
| La cuenta, por favor | Bill, please |
| ¿Está incluido el servicio? | Is service included? |
| Muy bueno, gracias | Very good, thank you |

### Ordering Water
- "Agua, por favor" — They'll ask:
- "¿Con gas o sin gas?" — Sparkling or still?
- "Agua del grifo" — Tap water (free, safe)

### Coffee Orders
| Order | Result |
|-------|--------|
| Café solo | Espresso |
| Cortado | Espresso + splash of milk |
| Café con leche | Half coffee, half milk |
| Café americano | Long black |
| Café bombón | Espresso + condensed milk |
| Descafeinado | Decaf |

---

## Budget Tips

1. **Menú del día**: €12-18 for 3 courses + drink
2. **Tapas sharing**: Order for table, split bill
3. **Almuerzo**: €5-8 bocadillo + beer (mid-morning)
4. **Market eating**: Tapas at Mercado Central
5. **Picnic**: Buy at market, eat in Turia gardens
6. **Tap water**: "Agua del grifo" is free and safe
7. **Stand at bar**: Some places cheaper than table
8. **Raciones over tapas**: Better value for groups
