# Valencia Food Overview

## The Dining Scene

Valencia is Spain's underrated food capital. Birthplace of paella, home to the Mediterranean diet, and increasingly a destination for innovative cuisine.

### What Makes Valencia Special

**Paella origin**: The real thing comes from here. Valencians are protective and opinionated about it.

**Rice culture**: Beyond paella, dozens of rice dishes: arroz a banda, arroz negro, arroz al horno, fideuà.

**Mediterranean produce**: L'Horta (the fertile plain) supplies exceptional vegetables, fruits, and the ingredients for authentic Valencian cuisine.

**Seafood access**: Daily catches from the Mediterranean. El Cabanyal and the port area specialize in fresh fish.

**Orange country**: Valencia oranges are legendary. Fresh-squeezed OJ everywhere.

**Horchata**: The local drink — tiger nut milk, served cold with fartons (pastries).

---

## Key Cuisines Present

### Valencian / Spanish Traditional
- **Where**: El Carmen, Centro, La Albufera
- **Price**: €12-25 mains
- **Best for**: Paella, tapas, arroz dishes, traditional flavors

### Modern Spanish / Fusion
- **Where**: Ruzafa, some Centro locations
- **Price**: €20-50 mains
- **Best for**: Creative takes, tasting menus, wine pairings

### International
- **Where**: Ruzafa (strongest), El Carmen, beach areas
- **Price**: €10-25 mains
- **Best for**: Asian, Mexican, Middle Eastern, vegetarian options

### Fine Dining
- **Where**: Scattered, mostly Ruzafa and Centro
- **Price**: €80-200 tasting menus
- **Best for**: Special occasions, Michelin experience

---

## Meal Structure

### Spanish Timing
| Meal | Time | What to Expect |
|------|------|----------------|
| Desayuno | 08:00-10:00 | Coffee + tostada or pastry |
| Almuerzo | 10:30-11:30 | Second breakfast, bocadillo |
| Comida | 13:30-16:00 | Main meal, 2-3 courses |
| Merienda | 17:00-19:00 | Snack, coffee, light |
| Cena | 21:00-23:00 | Lighter than lunch |

**Key insight**: Lunch is the main meal. Dinner is lighter and later than you expect.

### Menú del Día
The best deal in Spain:
- **When**: Lunch only (13:30-16:00)
- **Price**: €12-18
- **Includes**: Starter, main, dessert or coffee, drink, bread
- **Where**: Almost everywhere except tourist traps

**Tip**: "¿Tienen menú del día?" — works anywhere

---

## Restaurant Categories

### Casual Dining
- **Tabernas/Bodegas**: Wine bars with tapas
- **Cervecerías**: Beer-focused with food
- **Arrocerías**: Rice specialists
- **Marisquerías**: Seafood focused

### Quick Eats
- **Bocadillerías**: Sandwich shops
- **Horchaterías**: Horchata and fartons
- **Panaderías**: Bakeries with pastries
- **Mercados**: Market stalls for tapas

### Fine Dining
- **Restaurante gastronómico**: Tasting menu places
- **Estrella Michelin**: Michelin-starred

---

## Must-Try Dishes

### Rice Dishes
| Dish | Description |
|------|-------------|
| Paella Valenciana | Chicken, rabbit, snails, beans, saffron |
| Arroz a banda | Rice cooked in fish stock, fish served separately |
| Arroz negro | Black rice with squid ink |
| Arroz del senyoret | "Lord's rice" — shellfish peeled for you |
| Fideuà | Like paella but with noodles |
| Arroz al horno | Oven-baked rice with chickpeas, morcilla |

### Tapas & Starters
| Dish | Description |
|------|-------------|
| Esgarraet | Roasted red peppers with salt cod |
| Clóchinas | Local mussels, steamed |
| Tellinas | Small clams |
| All i pebre | Eel stew with garlic and paprika |
| Buñuelos de bacalao | Salt cod fritters |

### Mains
| Dish | Description |
|------|-------------|
| Suquet | Fish stew |
| Sepia a la plancha | Grilled cuttlefish |
| Conejo al ajillo | Rabbit with garlic |

### Sweets
| Dish | Description |
|------|-------------|
| Horchata con fartons | Tiger nut drink with pastries |
| Coca de llanda | Valencian sponge cake |
| Buñuelos de calabaza | Pumpkin fritters (Fallas season) |
| Arnadí | Pumpkin/almond tart |

---

## Drinks

### Non-Alcoholic
- **Horchata**: Cold tiger nut milk — the local drink
- **Agua de Valencia**: Orange juice cocktail (despite the name, has alcohol)
- **Zumo de naranja natural**: Fresh-squeezed OJ everywhere

### Alcoholic
- **Agua de Valencia**: OJ, cava, vodka, gin — party drink
- **Cava**: Sparkling wine from nearby regions
- **Vino de la tierra**: Local wines (Utiel-Requena, Valencia DO)
- **Cerveza**: Amstel is the local brand
- **Vermut**: Vermouth culture strong, especially pre-lunch

### Coffee
- **Café solo**: Espresso
- **Cortado**: Espresso with splash of milk
- **Café con leche**: Half coffee, half milk
- **Café bombón**: Espresso with condensed milk (Valencian specialty)

---

## Price Expectations

| Type | Price per Person |
|------|------------------|
| Menú del día | €12-18 |
| Casual tapas dinner | €15-25 |
| Paella for 2 (split) | €12-18/person |
| Mid-range dinner | €25-40 |
| Fine dining | €80-150+ |

**Tipping**: Not obligatory. Round up or 5-10% for good service.

---

## Booking & Reservations

### When to Book
- **Casual places**: Walk in usually fine
- **Popular Ruzafa spots**: Book for Friday/Saturday dinner
- **Fine dining**: 1-2 weeks ahead
- **Special occasions**: 2-4 weeks (Ricard Camarena, El Poblet)

### How to Book
- **Phone**: Traditional but effective
- **TheFork/ElTenedor**: App with discounts
- **Google Maps**: Many restaurants have booking links
- **Instagram DM**: Some trendy places accept this

---

## Dietary Needs

### Vegetarian
- Improving but Spain is meat-heavy
- Ruzafa has best options (Copenhagen, Kimpira)
- Ask: "¿Tienen opciones vegetarianas?"
- Watch for hidden ham/fish stock

### Vegan
- Growing scene, mostly Ruzafa
- Apps: HappyCow
- Best spots: Copenhagen, Almalibre, Kimpira

### Gluten-Free
- Ask: "¿Tienen opciones sin gluten?"
- Many places accommodating
- Rice dishes naturally GF (confirm no flour in sofrito)
- Dedicated shops: Celicioso

### Halal
- Growing halal scene
- Kebab shops throughout
- Some Middle Eastern restaurants in Centro
- Check: HalalTrip app

---

## Files in This Section

| Topic | File |
|-------|------|
| Valencian & local dishes | `food-local.md` |
| International & fine dining | `food-international.md` |
| Best areas for eating | `food-areas.md` |
| Practical (hours, alcohol, Ramadan) | `food-practical.md` |
